/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.util.function.Function;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.HikariConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;

public class MySqlConnectionFactory
extends HikariConnectionFactory {
    public MySqlConnectionFactory(StorageCredentials configuration) {
        super(configuration);
    }

    @Override
    public String getImplementationName() {
        return "MySQL";
    }

    @Override
    protected String getDriverClass() {
        return "me.lucko.luckperms.lib.mysql.jdbc.jdbc2.optional.MysqlDataSource";
    }

    @Override
    protected void appendProperties(HikariConfig config, StorageCredentials credentials) {
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("alwaysSendSetIsolation", (Object)"false");
        config.addDataSourceProperty("cacheServerConfiguration", (Object)"true");
        config.addDataSourceProperty("elideSetAutoCommits", (Object)"true");
        config.addDataSourceProperty("useLocalSessionState", (Object)"true");
        config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("cacheCallableStmts", (Object)"true");
        super.appendProperties(config, credentials);
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace("'", "`");
    }
}

