/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import me.lucko.luckperms.common.utils.Scripting;
import me.lucko.luckperms.common.verbose.CheckData;
import me.lucko.luckperms.common.verbose.InvalidFilterException;

public final class VerboseFilter {
    private static final String DELIMITERS = " |&()!";
    private final ScriptEngine engine;
    private final List<Token> expression;

    public static VerboseFilter parse(String filter) throws InvalidFilterException {
        ScriptEngine engine = Scripting.getScriptEngine();
        if (engine == null) {
            throw new RuntimeException("Script engine not present");
        }
        return new VerboseFilter(engine, filter);
    }

    private VerboseFilter(ScriptEngine engine, String filter) throws InvalidFilterException {
        this.engine = engine;
        if (filter.isEmpty()) {
            this.expression = ImmutableList.of();
        } else {
            try {
                this.expression = VerboseFilter.generateExpression(engine, filter);
            }
            catch (Exception e) {
                throw new InvalidFilterException("Exception occurred whilst generating an expression for '" + filter + "'", e);
            }
        }
    }

    private static List<Token> generateExpression(ScriptEngine engine, String filter) throws ScriptException {
        StringTokenizer tokenizer = new StringTokenizer(filter, DELIMITERS, true);
        ImmutableList.Builder expressionBuilder = ImmutableList.builder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (VerboseFilter.isDelimiter(token)) {
                expressionBuilder.add((Object)new ConstantToken(token));
                continue;
            }
            expressionBuilder.add((Object)new VariableToken(token));
        }
        ImmutableList expression = expressionBuilder.build();
        VerboseFilter.testExpression((List<Token>)expression, engine);
        return expression;
    }

    private static void testExpression(List<Token> expression, ScriptEngine engine) throws ScriptException {
        String dummyExpression = expression.stream().map(Token::forDummyExpression).collect(Collectors.joining());
        String result = engine.eval(dummyExpression).toString();
        if (!result.equals("true") && !result.equals("false")) {
            throw new IllegalArgumentException("Expected true/false but got '" + result + "' instead.");
        }
    }

    public boolean evaluate(CheckData data) {
        if (this.expression.isEmpty()) {
            return true;
        }
        String expressionString = this.expression.stream().map(token -> token.forExpression(data)).collect(Collectors.joining());
        try {
            String result = this.engine.eval(expressionString).toString();
            if (!result.equals("true") && !result.equals("false")) {
                throw new IllegalArgumentException("Expected true/false but got '" + result + "' instead.");
            }
            return Boolean.parseBoolean(result);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean isBlank() {
        return this.expression.isEmpty();
    }

    public String toString() {
        return this.expression.stream().map(Object::toString).collect(Collectors.joining());
    }

    private static boolean isDelimiter(String string) {
        switch (string.charAt(0)) {
            case ' ': 
            case '!': 
            case '&': 
            case '(': 
            case ')': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private static final class VariableToken
    implements Token {
        private final String value;

        private VariableToken(String value) {
            this.value = value;
        }

        @Override
        public String forExpression(CheckData data) {
            return Boolean.toString(data.getCheckTarget().equalsIgnoreCase(this.value) || data.getPermission().toLowerCase().startsWith(this.value.toLowerCase()) || data.getResult().name().equalsIgnoreCase(this.value));
        }

        @Override
        public String forDummyExpression() {
            return "true";
        }

        public String toString() {
            return this.value;
        }
    }

    private static final class ConstantToken
    implements Token {
        private final String string;

        private ConstantToken(String string) {
            if (string.equals("&")) {
                string = "&&";
            } else if (string.equals("|")) {
                string = "||";
            }
            this.string = string;
        }

        @Override
        public String forExpression(CheckData data) {
            return this.string;
        }

        @Override
        public String forDummyExpression() {
            return this.string;
        }

        public String toString() {
            return this.string;
        }
    }

    private static interface Token {
        public String forExpression(CheckData var1);

        public String forDummyExpression();
    }
}

