/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.models.blocks;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import lumien.randomthings.block.BlockRuneBase;
import lumien.randomthings.config.Features;
import lumien.randomthings.lib.AtlasSprite;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelRune
implements IBakedModel {
    @AtlasSprite(resource="randomthings:blocks/runeBase")
    public static TextureAtlasSprite runeBase;
    @AtlasSprite(resource="randomthings:blocks/runeBaseFlat")
    public static TextureAtlasSprite runeBaseFlat;
    Cache<CacheEntry, List<BakedQuad>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == EnumFacing.UP && state instanceof IExtendedBlockState) {
            boolean[] connectionData;
            int[][] runeData = (int[][])((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockRuneBase.RUNE_DATA);
            CacheEntry entry = new CacheEntry(runeData, connectionData = (boolean[])((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockRuneBase.CONNECTION_DATA));
            ArrayList<BakedQuad> quadList = (ArrayList<BakedQuad>)this.modelCache.getIfPresent((Object)entry);
            if (quadList != null) {
                return quadList;
            }
            Random rng = new Random(rand);
            quadList = new ArrayList<BakedQuad>();
            for (int x = 0; x < runeData.length; ++x) {
                for (int z = 0; z < runeData[0].length; ++z) {
                    int rune = runeData[x][z];
                    float u = rng.nextInt(8) * 2;
                    float v = rng.nextInt(8) * 2;
                    if (rune != -1) {
                        quadList.add(this.generateNewRuneQuad(x * 4, z * 4, rune, 2, 2, u, v));
                        boolean[] connectedSides = new boolean[4];
                        connectedSides[0] = z == 0 && connectionData[x] || z != 0 && runeData[x][z - 1] == rune;
                        connectedSides[2] = z == 3 && connectionData[8 + x] || z != 3 && runeData[x][z + 1] == rune;
                        connectedSides[1] = x == 3 && connectionData[4 + z] || x != 3 && runeData[x + 1][z] == rune;
                        connectedSides[3] = x == 0 && connectionData[12 + z] || x != 0 && runeData[x - 1][z] == rune;
                        for (int i = 0; i < connectedSides.length; ++i) {
                            int modX;
                            u = rng.nextInt(8) * 2;
                            v = rng.nextInt(8) * 2;
                            if (!connectedSides[i]) continue;
                            int n = i == 1 ? 2 : (modX = i == 3 ? -1 : 0);
                            int modZ = i == 0 ? -1 : (i == 2 ? 2 : 0);
                            quadList.add(this.generateNewRuneQuad(x * 4 + modX, z * 4 + modZ, rune, modZ != 0 ? 2 : 1, modX != 0 ? 2 : 1, u, v));
                        }
                        continue;
                    }
                    for (int i = 0; i < 4; ++i) {
                        u = rng.nextInt(8) * 2;
                        v = rng.nextInt(8) * 2;
                    }
                }
            }
            this.modelCache.put((Object)new CacheEntry(runeData, connectionData), quadList);
            return quadList;
        }
        return new ArrayList<BakedQuad>();
    }

    private BakedQuad generateNewRuneQuad(int x, int z, int rune, int width, int height, float u, float v) {
        float part = 0.0625f;
        return this.createSidedBakedQuad(part + (float)x * part, part + (float)x * part + part * (float)width, part + (float)z * part, part + (float)z * part + part * (float)height, 0.2f * part, u, v, u + (float)width, v + (float)height, rune, Features.FLAT_RUNES ? runeBaseFlat : runeBase, EnumFacing.UP);
    }

    private BakedQuad createSidedBakedQuad(float x1, float x2, float z1, float z2, float y, float u1, float v1, float u2, float v2, int tintIndex, TextureAtlasSprite texture, EnumFacing side) {
        Vec3d c1 = ModelRune.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c2 = ModelRune.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c3 = ModelRune.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c4 = ModelRune.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        EnumFacing rotation = EnumFacing.SOUTH;
        if (side == EnumFacing.WEST || side == EnumFacing.EAST || side == EnumFacing.SOUTH) {
            rotation = EnumFacing.SOUTH;
        } else if (side == EnumFacing.NORTH) {
            rotation = EnumFacing.WEST;
            c1 = ModelRune.rotate(c1.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c2 = ModelRune.rotate(c2.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c3 = ModelRune.rotate(c3.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c4 = ModelRune.rotate(c4.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
        }
        if (side != EnumFacing.UP && side != EnumFacing.SOUTH) {
            c1 = ModelRune.rotate(c1.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c2 = ModelRune.rotate(c2.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c3 = ModelRune.rotate(c3.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c4 = ModelRune.rotate(c4.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
        }
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts((float)c1.field_72450_a, (float)c1.field_72448_b, (float)c1.field_72449_c, -1, texture, u1, v1, side), this.vertexToInts((float)c2.field_72450_a, (float)c2.field_72448_b, (float)c2.field_72449_c, -1, texture, u1, v2, side), this.vertexToInts((float)c3.field_72450_a, (float)c3.field_72448_b, (float)c3.field_72449_c, -1, texture, u2, v2, side), this.vertexToInts((float)c4.field_72450_a, (float)c4.field_72448_b, (float)c4.field_72449_c, -1, texture, u2, v1, side)}), tintIndex, side, texture, false, DefaultVertexFormats.field_176599_b);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Features.FLAT_RUNES ? runeBaseFlat : runeBase;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static Vec3d rotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }

    private int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, EnumFacing side) {
        int xN = (byte)(side.func_82601_c() * 127) & 0xFF;
        int yN = (byte)(side.func_96559_d() * 127) & 0xFF;
        int zN = (byte)(side.func_82599_e() * 127) & 0xFF;
        int normal = xN | yN << 8 | zN << 16;
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), normal};
    }

    private class CacheEntry {
        int[][] runeData;
        boolean[] connectionData;

        public CacheEntry(int[][] runeData, boolean[] connectionData) {
            this.runeData = runeData;
            this.connectionData = connectionData;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.connectionData);
            result = 31 * result + Arrays.deepHashCode((Object[])this.runeData);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (!Arrays.equals(this.connectionData, other.connectionData)) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.runeData, (Object[])other.runeData);
        }

        private ModelRune getOuterType() {
            return ModelRune.this;
        }
    }
}

