/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot;

import com.flowpowered.math.vector.Vector3d;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.moddedminecraft.mmcreboot.Config.Config;
import net.moddedminecraft.mmcreboot.Config.Messages;
import net.moddedminecraft.mmcreboot.EventListener;
import net.moddedminecraft.mmcreboot.Tasks.ShutdownTask;
import net.moddedminecraft.mmcreboot.commands.RebootCMD;
import net.moddedminecraft.mmcreboot.commands.RebootCancel;
import net.moddedminecraft.mmcreboot.commands.RebootConfirm;
import net.moddedminecraft.mmcreboot.commands.RebootHelp;
import net.moddedminecraft.mmcreboot.commands.RebootNow;
import net.moddedminecraft.mmcreboot.commands.RebootTime;
import net.moddedminecraft.mmcreboot.commands.RebootVote;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.bstats.sponge.Metrics2;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.world.World;

@Plugin(id="mmcreboot", name="MMCReboot", version="2.3.1", authors={"Leelawd93"})
public class Main {
    @Inject
    public Logger logger;
    @Inject
    private Metrics2 metrics;
    @Inject
    @ConfigDir(sharedRoot=false)
    public Path configDir;
    @Inject
    @DefaultConfig(sharedRoot=false)
    public Path defaultConf;
    @Inject
    @DefaultConfig(sharedRoot=false)
    public File defaultConfFile;
    public int voteCancel = 0;
    public int cdTimer = 0;
    public boolean voteStarted = false;
    public int yesVotes = 0;
    public int noVotes = 0;
    public ArrayList<Player> hasVoted = new ArrayList();
    public static ArrayList<Integer> realTimeTimes = new ArrayList();
    public int voteSeconds;
    public String reason;
    public long startTimestamp;
    public boolean justStarted = true;
    public boolean isRestarting = false;
    public boolean TPSRestarting = false;
    public int rebootConfirm = 0;
    public boolean tasksScheduled = false;
    public double nextRealTimeRestart;
    private ArrayList<Timer> warningTimers = new ArrayList();
    private Timer rebootTimer;
    private Timer justStartedTimer;
    private boolean playSoundNow = false;
    private Vector3d soundLoc;
    private Config config;
    private Messages messages;
    private CommandManager cmdManager = Sponge.getCommandManager();
    private Scoreboard board;
    private ServerBossBar bar;

    @Listener
    public void Init(GameInitializationEvent event) throws IOException, ObjectMappingException {
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventListener(this));
        this.config = new Config(this);
        this.messages = new Messages(this);
        this.loadCommands();
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) throws IOException {
        this.soundLoc = new Vector3d(0.0f, 64.0f, 0.0f);
        if (Config.restartType.equalsIgnoreCase("fixed")) {
            this.logger.info("[MMCReboot] Using fixed restart scheduler");
            this.scheduleTasks();
            if (!Config.defaultRestartReason.isEmpty()) {
                this.reason = Config.defaultRestartReason;
            }
        } else if (Config.restartType.equalsIgnoreCase("realtime")) {
            this.logger.info("[MMCReboot] Using realtime restart scheduler");
            this.scheduleRealTimeRestart();
            if (!Config.defaultRestartReason.isEmpty()) {
                this.reason = Config.defaultRestartReason;
            }
            Config.restartInterval = 0.0;
        } else {
            this.logger.info("[MMCReboot] No automatic restarts scheduled!");
        }
        if (Config.voteEnabled) {
            this.justStartedTimer = new Timer();
            this.justStartedTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Main.this.justStarted = false;
                }
            }, Config.timerStartvote * 60 * 1000);
        }
        Sponge.getScheduler().createTaskBuilder().execute(this::action).delay(250L, TimeUnit.MILLISECONDS).interval(500L, TimeUnit.MILLISECONDS).name("mmcreboot-s-sendAction").submit((Object)this);
        Sponge.getScheduler().createTaskBuilder().execute(this::reduceVote).interval(1L, TimeUnit.SECONDS).name("mmcreboot-s-reduceVoteCount").submit((Object)this);
        Sponge.getScheduler().createTaskBuilder().execute(this::checkRealTimeRestart).delay(1L, TimeUnit.HOURS).interval(15L, TimeUnit.MINUTES).name("mmcreboot-s-checkRealTimeRestart").submit((Object)this);
        Sponge.getScheduler().createTaskBuilder().execute(this::CheckTPSForRestart).delay((long)Config.tpsCheckDelay, TimeUnit.MINUTES).interval(30L, TimeUnit.SECONDS).name("mmcreboot-s-checkTPSForRestart").submit((Object)this);
        this.logger.info("MMCReboot Loaded");
    }

    @Listener
    public void onServerStop(GameStoppingEvent event) throws IOException {
        this.cancelTasks();
        this.logger.info("MMCReboot Disabled");
    }

    @Listener
    public void onPluginReload(GameReloadEvent event) throws IOException, ObjectMappingException {
        this.cancelTasks();
        this.removeScoreboard();
        this.removeBossBar();
        this.isRestarting = false;
        this.config = new Config(this);
        this.messages = new Messages(this);
        if (Config.restartType.equalsIgnoreCase("fixed")) {
            this.scheduleTasks();
            if (!Config.defaultRestartReason.isEmpty()) {
                this.reason = Config.defaultRestartReason;
            }
        } else if (Config.restartType.equalsIgnoreCase("realtime")) {
            this.scheduleRealTimeRestart();
            if (!Config.defaultRestartReason.isEmpty()) {
                this.reason = Config.defaultRestartReason;
            }
            Config.restartInterval = 0.0;
        } else {
            this.logger.info("[MMCReboot] No automatic restarts scheduled!");
        }
    }

    private void loadCommands() {
        CommandSpec help = CommandSpec.builder().description((Text)Text.of((String)"List of commands usable to the player")).executor((CommandExecutor)new RebootHelp(this)).build();
        CommandSpec vote = CommandSpec.builder().description((Text)Text.of((String)"Submit a vote to reboot the server")).executor((CommandExecutor)new RebootVote(this)).arguments(GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"optional")))).build();
        CommandSpec cancel = CommandSpec.builder().description((Text)Text.of((String)"Cancel the current timed reboot")).permission("mmcreboot.reboot.cancel").executor((CommandExecutor)new RebootCancel(this)).build();
        CommandSpec time = CommandSpec.builder().description((Text)Text.of((String)"Get the time remaining until the next restart")).permission("mmcreboot.reboot.time").executor((CommandExecutor)new RebootTime(this)).build();
        CommandSpec confirm = CommandSpec.builder().description((Text)Text.of((String)"Reboot the server immediately")).permission("mmcreboot.reboot.now").executor((CommandExecutor)new RebootConfirm(this)).build();
        CommandSpec now = CommandSpec.builder().description((Text)Text.of((String)"Reboot the server immediately")).permission("mmcreboot.reboot.now").executor((CommandExecutor)new RebootNow(this)).build();
        HashMap<String, String> choices = new HashMap<String, String>(){
            {
                this.put("h", "h");
                this.put("m", "m");
                this.put("s", "s");
            }
        };
        CommandSpec start = CommandSpec.builder().description((Text)Text.of((String)"Reboot base command")).permission("mmcreboot.reboot.start").arguments(new CommandElement[]{GenericArguments.choices((Text)Text.of((String)"h/m/s"), (Map)choices), GenericArguments.integer((Text)Text.of((String)"time")), GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"reason")))}).executor((CommandExecutor)new RebootCMD(this)).build();
        CommandSpec rbootmain = CommandSpec.builder().description((Text)Text.of((String)"Reboot base command")).child((CommandCallable)start, new String[]{"start"}).child((CommandCallable)now, new String[]{"now"}).child((CommandCallable)confirm, new String[]{"confirm"}).child((CommandCallable)time, new String[]{"time"}).child((CommandCallable)cancel, new String[]{"cancel"}).child((CommandCallable)vote, new String[]{"vote"}).child((CommandCallable)help, new String[]{"help"}).build();
        this.cmdManager.register((Object)this, (CommandCallable)rbootmain, new String[]{"reboot", "restart"});
    }

    public Double getTPS() {
        Double TPS = Sponge.getServer().getTicksPerSecond();
        return TPS;
    }

    public boolean getTPSRestarting() {
        return this.TPSRestarting;
    }

    public void setTPSRestarting(boolean bool) {
        this.TPSRestarting = bool;
    }

    public void CheckTPSForRestart() {
        if (this.getTPS() < (double)Config.tpsMinimum && Config.tpsEnabled && !this.getTPSRestarting()) {
            double timeLeft = Config.restartInterval * 3600.0 - (double)(System.currentTimeMillis() - this.startTimestamp) / 1000.0;
            int hours = (int)(timeLeft / 3600.0);
            int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
            if (hours == 0 && minutes > 20 || hours > 0) {
                this.setTPSRestarting(true);
                Timer warnTimer = new Timer();
                this.warningTimers.add(warnTimer);
                warnTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (Main.this.getTPS() < (double)Config.tpsMinimum) {
                            Main.this.isRestarting = true;
                            Config.restartInterval = (double)(Config.tpsTimer + 1) / 3600.0;
                            Main.this.logger.info("[MMCReboot] scheduling restart tasks...");
                            if (Config.tpsUseReason) {
                                Main.this.reason = Config.tpsMessage;
                            }
                            Main.this.scheduleTasks();
                        } else {
                            Main.this.setTPSRestarting(false);
                        }
                    }
                }, 15000L);
            }
        }
    }

    public void action() {
        if (this.isRestarting && Config.timerUseScoreboard) {
            if (Config.restartInterval > 0.0) {
                this.displayRestart(Config.restartInterval * 3600.0);
            } else if (this.nextRealTimeRestart > 0.0) {
                this.displayRestart(this.nextRealTimeRestart);
            }
        }
        if (this.voteStarted && this.voteCancel == 0 && Config.timerUseVoteScoreboard) {
            this.displayVotes();
        }
    }

    public void reduceVote() {
        if (this.voteStarted && this.voteCancel == 0) {
            if (this.voteSeconds > 0) {
                --this.voteSeconds;
            }
            if (this.voteSeconds < 0) {
                this.voteSeconds = 0;
            }
        }
    }

    public void checkRealTimeRestart() {
        if (Config.restartType.equalsIgnoreCase("realtime") && this.nextRealTimeRestart == 0.0 && !this.isRestarting && this.voteCancel == 0) {
            this.scheduleRealTimeRestart();
        }
    }

    public void scheduleRealTimeRestart() {
        this.cancelTasks();
        double rInterval = this.nextRealTimeRestart = (double)this.getNextRealTimeFromConfig();
        if (Config.timerBroadcast != null) {
            this.warningMessages(rInterval);
        }
        this.rebootTimer = new Timer();
        this.rebootTimer.schedule((TimerTask)new ShutdownTask(this), (long)(this.nextRealTimeRestart * 1000.0));
        this.logger.info("[MMCReboot] RebootCMD scheduled for " + (long)this.nextRealTimeRestart + " seconds from now!");
        this.tasksScheduled = true;
        this.startTimestamp = System.currentTimeMillis();
        this.isRestarting = true;
    }

    public void scheduleTasks() {
        boolean wasTPSRestarting = this.getTPSRestarting();
        this.cancelTasks();
        if (wasTPSRestarting) {
            this.setTPSRestarting(true);
        } else {
            this.setTPSRestarting(false);
        }
        double rInterval = Config.restartInterval * 3600.0;
        if (Config.timerBroadcast != null) {
            this.warningMessages(rInterval);
        }
        this.rebootTimer = new Timer();
        this.rebootTimer.schedule((TimerTask)new ShutdownTask(this), (long)(Config.restartInterval * 3600000.0));
        this.logger.info("[MMCReboot] RebootCMD scheduled for " + (long)(Config.restartInterval * 3600.0) + " seconds from now!");
        this.tasksScheduled = true;
        this.startTimestamp = System.currentTimeMillis();
        this.isRestarting = true;
    }

    private void warningMessages(final double rInterval) {
        Config.timerBroadcast.stream().filter(aTimerBroadcast -> rInterval * 60.0 - (double)aTimerBroadcast.intValue() > 0.0).forEach(aTimerBroadcast -> {
            Timer warnTimer = new Timer();
            this.warningTimers.add(warnTimer);
            if ((double)aTimerBroadcast.intValue() <= rInterval) {
                warnTimer.schedule(new TimerTask((Integer)aTimerBroadcast){
                    final /* synthetic */ Integer val$aTimerBroadcast;
                    {
                        this.val$aTimerBroadcast = n;
                    }

                    @Override
                    public void run() {
                        String message;
                        double timeLeft = rInterval - (double)(System.currentTimeMillis() - Main.this.startTimestamp) / 1000.0;
                        int hours = (int)(timeLeft / 3600.0);
                        int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
                        int seconds = (int)timeLeft % 60;
                        DecimalFormat formatter = new DecimalFormat("00");
                        String s = formatter.format(seconds);
                        if (minutes > 1) {
                            message = Messages.getRestartNotificationMinutes().replace("%minutes%", "" + minutes).replace("%seconds%", "" + s);
                            Main.this.broadcastMessage("&f[&6Restart&f] " + message);
                        } else if (minutes == 1) {
                            message = Messages.getRestartNotificationMinute().replace("%minutes%", "" + minutes).replace("%seconds%", "" + s);
                            Main.this.broadcastMessage("&f[&6Restart&f] " + message);
                        } else if (minutes < 1) {
                            message = Messages.getRestartNotificationSeconds().replace("%minutes%", "" + minutes).replace("%seconds%", "" + s);
                            Main.this.broadcastMessage("&f[&6Restart&f] " + message);
                        } else {
                            Main.this.logger.info("[MMCReboot] &bThe server will be restarting in &f" + hours + "h" + minutes + "m" + seconds + "s");
                        }
                        if (!Main.this.playSoundNow && Config.playSoundFirstTime >= (double)this.val$aTimerBroadcast.intValue()) {
                            Main.this.playSoundNow = true;
                        }
                        for (World w : Sponge.getServer().getWorlds()) {
                            if (!Config.playSoundEnabled || !Main.this.playSoundNow) continue;
                            Optional sound = Sponge.getGame().getRegistry().getType(SoundType.class, Config.playSoundString);
                            SoundType playSound = sound.isPresent() ? (SoundType)sound.get() : (SoundType)Sponge.getGame().getRegistry().getType(SoundType.class, "block.note.pling").get();
                            w.playSound(playSound, Main.this.soundLoc, 4000.0);
                        }
                        for (Player p : Sponge.getServer().getOnlinePlayers()) {
                            if (!Config.titleEnabled) continue;
                            if (Main.this.reason != null) {
                                p.sendTitle(Title.builder().title(Main.this.fromLegacy(Config.titleMessage.replace("{hours}", "" + hours).replace("{minutes}", "" + minutes).replace("{seconds}", "" + s))).subtitle(Main.this.fromLegacy(Main.this.reason)).fadeIn(Integer.valueOf(10)).fadeOut(Integer.valueOf(10)).stay(Integer.valueOf(Config.titleStayTime * 20)).build());
                                continue;
                            }
                            p.sendTitle(Title.builder().subtitle(Main.this.fromLegacy(Config.titleMessage.replace("{hours}", "" + hours).replace("{minutes}", "" + minutes).replace("{seconds}", "" + s))).fadeIn(Integer.valueOf(10)).fadeOut(Integer.valueOf(10)).stay(Integer.valueOf(Config.titleStayTime * 20)).build());
                        }
                        if (Main.this.reason != null) {
                            Main.this.broadcastMessage("&f[&6Restart&f] &d" + Main.this.reason);
                        }
                        Main.this.isRestarting = true;
                    }
                }, (long)((rInterval - (double)aTimerBroadcast.intValue()) * 1000.0));
                this.logger.info("[MMCReboot] warning scheduled for " + (long)(rInterval - (double)aTimerBroadcast.intValue()) + " seconds from now!");
            }
        });
    }

    public void cancelTasks() {
        for (Timer warningTimer : this.warningTimers) {
            warningTimer.cancel();
        }
        this.warningTimers.clear();
        if (this.rebootTimer != null) {
            this.rebootTimer.cancel();
        }
        this.rebootTimer = new Timer();
        this.tasksScheduled = false;
        this.isRestarting = false;
        this.TPSRestarting = false;
        this.nextRealTimeRestart = 0.0;
    }

    public boolean stopServer() {
        this.logger.info("[MMCReboot] Restarting...");
        this.isRestarting = false;
        this.broadcastMessage("&cServer is restarting, we'll be right back!");
        try {
            File file = new File(this.configDir + File.separator + "restart.txt");
            this.logger.info("[MMCReboot] Touching restart.txt at: " + file.getAbsolutePath());
            if (file.exists()) {
                file.setLastModified(System.currentTimeMillis());
            } else {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            this.logger.info("[MMCReboot] Something went wrong while touching restart.txt!");
            this.logger.info("Exception: " + e);
            return false;
        }
        try {
            Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), "save-all");
            if (Config.kickmessage.isEmpty()) {
                Sponge.getServer().shutdown();
            } else {
                Sponge.getServer().shutdown(this.fromLegacy(Config.kickmessage));
            }
        }
        catch (Exception e) {
            this.logger.info("[MMCReboot] Something went wrong while saving & stopping!");
            this.logger.info("Exception: " + e);
            return false;
        }
        return true;
    }

    public int getNextRealTimeFromConfig() {
        realTimeTimes = new ArrayList();
        for (String realTime : Config.realTimeInterval) {
            int time = this.getTimeUntil(realTime);
            realTimeTimes.add(time);
        }
        return Collections.min(realTimeTimes);
    }

    private int getTimeUntil(String time) {
        Calendar cal = Calendar.getInstance();
        int nowHour = cal.get(11);
        int nowMin = cal.get(12);
        return this.getTimeTill(nowHour, nowMin, time);
    }

    private int getTimeTill(int nowHour, int nowMin, String endTime) {
        Matcher m = Pattern.compile("(\\d{2}):(\\d{2})").matcher(endTime);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid time format: " + endTime);
        }
        int endHour = Integer.parseInt(m.group(1));
        int endMin = Integer.parseInt(m.group(2));
        if (endHour >= 24 || endMin >= 60) {
            throw new IllegalArgumentException("Invalid time format: " + endTime);
        }
        int timeTill = (endHour * 60 + endMin - (nowHour * 60 + nowMin)) * 60;
        if (timeTill < 0) {
            timeTill += 86400;
        }
        return timeTill;
    }

    public void useCommandOnRestart() {
        this.logger.info("[MMCReboot] Running Command");
        this.isRestarting = false;
        List<String> cmds = Config.restartCommands;
        for (String cmd : cmds) {
            Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), cmd.replace("/", ""));
        }
    }

    public int getTimeLeftInSeconds() {
        return this.voteSeconds;
    }

    public void displayRestart(double rInterval) {
        double timeLeft = rInterval - (double)(System.currentTimeMillis() - this.startTimestamp) / 1000.0;
        int hours = (int)(timeLeft / 3600.0);
        int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
        int seconds = (int)timeLeft % 60;
        DecimalFormat formatter = new DecimalFormat("00");
        String s = formatter.format(seconds);
        this.board = Scoreboard.builder().build();
        Objective obj = Objective.builder().name("restart").criterion(Criteria.DUMMY).displayName((Text)Text.of((String)Messages.getSidebarRestartTimerTitle())).build();
        this.board.addObjective(obj);
        this.board.updateDisplaySlot(obj, DisplaySlots.SIDEBAR);
        obj.getOrCreateScore((Text)Text.builder((String)(Integer.toString(minutes) + ":" + s)).color(TextColors.GREEN).build()).setScore(0);
        int mSec = minutes * 60;
        double val = (mSec + seconds) * 100 / 300;
        float percent = (float)val / 100.0f;
        Sponge.getServer().getOnlinePlayers().stream().filter(player -> minutes < 5 && hours == 0).forEach(player -> {
            player.setScoreboard(this.board);
            if (Config.bossbarEnabled) {
                if (this.bar == null) {
                    this.bar = ServerBossBar.builder().name((Text)Text.of((String)Config.bossbarTitle.replace("{minutes}", Integer.toString(minutes)).replace("{seconds}", s))).color(BossBarColors.GREEN).overlay(BossBarOverlays.PROGRESS).percent(percent).build();
                } else {
                    this.bar.setPercent(percent);
                }
                this.bar.addPlayer(player);
            }
        });
    }

    public void displayVotes() {
        this.board = Scoreboard.builder().build();
        Objective obj = Objective.builder().name("vote").criterion(Criteria.DUMMY).displayName((Text)Text.of((String)Messages.getSidebarTitle())).build();
        this.board.addObjective(obj);
        this.board.updateDisplaySlot(obj, DisplaySlots.SIDEBAR);
        obj.getOrCreateScore((Text)Text.builder((String)(Messages.getSidebarYes() + ":")).color(TextColors.GREEN).build()).setScore(this.yesVotes);
        obj.getOrCreateScore((Text)Text.builder((String)(Messages.getSidebarNo() + ":")).color(TextColors.AQUA).build()).setScore(this.noVotes);
        obj.getOrCreateScore((Text)Text.builder((String)(Messages.getSidebarTimeleft() + ":")).color(TextColors.RED).build()).setScore(this.getTimeLeftInSeconds());
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            player.setScoreboard(this.board);
        }
    }

    public void removeScoreboard() {
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            player.getScoreboard().clearSlot(DisplaySlots.SIDEBAR);
        }
    }

    public void removeBossBar() {
        if (this.bar != null) {
            this.bar.removePlayers(this.bar.getPlayers());
        }
    }

    public void broadcastMessage(String message) {
        Sponge.getServer().getBroadcastChannel().send(this.fromLegacy(message), ChatTypes.SYSTEM);
    }

    public void sendMessage(CommandSource sender, String message) {
        sender.sendMessage(this.fromLegacy(message));
    }

    public Text fromLegacy(String legacy) {
        return TextSerializers.FORMATTING_CODE.deserializeUnchecked(legacy);
    }
}

