/*
 * Decompiled with CFR 0.152.
 */
package extracells.container.fluid;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import extracells.api.IPortableFluidStorageCell;
import extracells.api.IWirelessFluidTermHandler;
import extracells.container.ContainerStorage;
import extracells.container.StorageType;
import extracells.util.AEUtils;
import extracells.util.FluidHelper;
import extracells.util.PlayerSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ContainerFluidStorage
extends ContainerStorage {
    public ContainerFluidStorage(EntityPlayer player, EnumHand hand) {
        super(StorageType.FLUID, player, hand);
    }

    public ContainerFluidStorage(IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, IPortableFluidStorageCell storageCell, EnumHand hand) {
        super(StorageType.FLUID, monitor, player, storageCell, hand);
    }

    public ContainerFluidStorage(IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, IWirelessFluidTermHandler handler, EnumHand hand) {
        super(StorageType.FLUID, monitor, player, handler, hand);
    }

    public ContainerFluidStorage(IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, EnumHand hand) {
        super(StorageType.FLUID, monitor, player, hand);
    }

    @Override
    public void doWork() {
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot != null && !secondSlot.func_190926_b() && secondSlot.func_190916_E() >= secondSlot.func_77976_d()) {
            return;
        }
        ItemStack container = this.inventory.func_70301_a(0);
        if (!FluidHelper.isFluidContainer(container)) {
            return;
        }
        if (this.monitor == null) {
            return;
        }
        container = container.func_77946_l();
        container.func_190920_e(1);
        if (FluidHelper.isDrainableFilledContainer(container)) {
            FluidStack containerFluid = FluidHelper.getFluidFromContainer(container);
            IAEFluidStack notInjected = (IAEFluidStack)this.monitor.injectItems((IAEStack)AEUtils.createFluidStack(containerFluid), Actionable.SIMULATE, (IActionSource)new PlayerSource(this.player, null));
            if (notInjected != null) {
                return;
            }
            ItemStack handItem = this.player.func_184586_b(this.hand);
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, handItem)) {
                    return;
                }
                this.handler.usePower(this.player, 20.0, handItem);
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, handItem)) {
                    return;
                }
                this.storageCell.usePower(this.player, 20.0, handItem);
            }
            Pair<Integer, ItemStack> drainedContainer = FluidHelper.drainStack(container, containerFluid);
            if (this.fillSecondSlot((ItemStack)drainedContainer.getRight())) {
                this.monitor.injectItems((IAEStack)AEUtils.createFluidStack(containerFluid), Actionable.MODULATE, (IActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
            }
        } else if (FluidHelper.isFillableContainerWithRoom(container)) {
            int proposedAmount;
            if (this.selectedFluid == null) {
                return;
            }
            int capacity = FluidHelper.getCapacity(container, this.selectedFluid);
            IAEFluidStack result = (IAEFluidStack)this.monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)capacity), Actionable.SIMULATE, (IActionSource)new PlayerSource(this.player, null));
            int n = proposedAmount = result == null ? 0 : (int)Math.min((long)capacity, result.getStackSize());
            if (proposedAmount == 0) {
                return;
            }
            Pair<Integer, ItemStack> filledContainer = FluidHelper.fillStack(container, new FluidStack(this.selectedFluid, proposedAmount));
            if (this.fillSecondSlot((ItemStack)filledContainer.getRight())) {
                this.monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (IActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
            }
        }
    }
}

