/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory.cell;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import extracells.api.ECApi;
import extracells.api.IFluidStorageCell;
import extracells.api.IHandlerFluidStorage;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class HandlerItemStorageFluid
implements ICellInventoryHandler<IAEFluidStack>,
IHandlerFluidStorage,
ICellInventory<IAEFluidStack> {
    private ItemStack storageStack;
    private NBTTagCompound stackTag;
    protected ArrayList<FluidStack> fluidStacks = new ArrayList();
    private ArrayList<Fluid> prioritizedFluids = new ArrayList();
    private int totalTypes;
    private int totalBytes;
    private ISaveProvider saveProvider;

    public HandlerItemStorageFluid(ItemStack _storageStack, ISaveProvider _saveProvider) {
        if (!_storageStack.func_77942_o()) {
            _storageStack.func_77982_d(new NBTTagCompound());
        }
        this.storageStack = _storageStack;
        this.stackTag = _storageStack.func_77978_p();
        this.totalTypes = ((IFluidStorageCell)_storageStack.func_77973_b()).getMaxTypes(_storageStack);
        this.totalBytes = ((IFluidStorageCell)_storageStack.func_77973_b()).getMaxBytes(_storageStack) * 250;
        for (int i = 0; i < this.totalTypes; ++i) {
            this.fluidStacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.stackTag.func_74775_l("Fluid#" + i)));
        }
        this.saveProvider = _saveProvider;
    }

    public HandlerItemStorageFluid(ItemStack _storageStack, ISaveProvider _saveProvider, ArrayList<Fluid> _filter) {
        this(_storageStack, _saveProvider);
        if (_filter != null) {
            this.prioritizedFluids = _filter;
        }
    }

    private boolean allowedByFormat(Fluid fluid) {
        return !this.isFormatted() || this.prioritizedFluids.contains(fluid);
    }

    public boolean canAccept(IAEFluidStack input) {
        if (input == null) {
            return false;
        }
        if (!ECApi.instance().canStoreFluid(input.getFluid())) {
            return false;
        }
        for (FluidStack fluidStack : this.fluidStacks) {
            if (fluidStack != null && fluidStack.getFluid() != input.getFluid()) continue;
            return this.allowedByFormat(input.getFluid());
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, IActionSource src) {
        if (request == null || !this.allowedByFormat(request.getFluid())) {
            return null;
        }
        ArrayList currentFluids = Lists.newArrayList(this.fluidStacks);
        for (int i = 0; i < this.fluidStacks.size(); ++i) {
            IAEFluidStack removedStack;
            FluidStack currentStack = this.fluidStacks.get(i);
            if (currentStack == null || !currentStack.getFluid().getName().equals(request.getFluid().getName())) continue;
            long endAmount = (long)currentStack.amount - request.getStackSize();
            if (endAmount >= 0L) {
                removedStack = request.copy();
                FluidStack toWrite = new FluidStack(currentStack.getFluid(), (int)endAmount);
                currentFluids.set(i, toWrite);
                if (mode == Actionable.MODULATE) {
                    this.writeFluidToSlot(i, toWrite);
                }
            } else {
                removedStack = (IAEFluidStack)StorageChannels.FLUID().createStack((Object)currentStack.copy());
                if (mode == Actionable.MODULATE) {
                    this.writeFluidToSlot(i, null);
                }
            }
            if (removedStack != null && removedStack.getStackSize() > 0L) {
                this.requestSave();
            }
            return removedStack;
        }
        return null;
    }

    public int freeBytes() {
        int i = 0;
        for (FluidStack stack : this.fluidStacks) {
            if (stack == null) continue;
            i += stack.amount;
        }
        return this.totalBytes - i;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        for (FluidStack fluidStack : this.fluidStacks) {
            if (fluidStack == null) continue;
            out.add(StorageChannels.FLUID().createStack((Object)fluidStack));
        }
        return out;
    }

    public IStorageChannel getChannel() {
        return StorageChannels.FLUID();
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, IActionSource src) {
        FluidStack toWrite;
        FluidStack currentStack;
        int i;
        if (input == null) {
            return input;
        }
        if (input.getStackSize() == 0L) {
            return input;
        }
        if (!this.allowedByFormat(input.getFluid())) {
            return input;
        }
        IAEFluidStack notAdded = input.copy();
        ArrayList currentFluids = Lists.newArrayList(this.fluidStacks);
        for (i = 0; i < currentFluids.size(); ++i) {
            currentStack = (FluidStack)currentFluids.get(i);
            if (notAdded == null || currentStack == null || input.getFluid() != currentStack.getFluid()) continue;
            if (notAdded.getStackSize() <= (long)this.freeBytes()) {
                toWrite = new FluidStack(currentStack.getFluid(), currentStack.amount + (int)notAdded.getStackSize());
                currentFluids.set(i, toWrite);
                if (mode == Actionable.MODULATE) {
                    this.writeFluidToSlot(i, toWrite);
                }
                notAdded = null;
                continue;
            }
            toWrite = new FluidStack(currentStack.getFluid(), currentStack.amount + this.freeBytes());
            currentFluids.set(i, toWrite);
            if (mode == Actionable.MODULATE) {
                this.writeFluidToSlot(i, toWrite);
            }
            notAdded.setStackSize(notAdded.getStackSize() - (long)this.freeBytes());
        }
        for (i = 0; i < currentFluids.size(); ++i) {
            currentStack = (FluidStack)currentFluids.get(i);
            if (notAdded == null || currentStack != null) continue;
            if (input.getStackSize() <= (long)this.freeBytes()) {
                toWrite = notAdded.getFluidStack();
                currentFluids.set(i, toWrite);
                if (mode == Actionable.MODULATE) {
                    this.writeFluidToSlot(i, toWrite);
                }
                notAdded = null;
                continue;
            }
            toWrite = new FluidStack(notAdded.getFluid(), this.freeBytes());
            currentFluids.set(i, toWrite);
            if (mode == Actionable.MODULATE) {
                this.writeFluidToSlot(i, toWrite);
            }
            notAdded.setStackSize(notAdded.getStackSize() - (long)this.freeBytes());
        }
        if (notAdded == null || !notAdded.equals(input)) {
            this.requestSave();
        }
        return notAdded;
    }

    @Override
    public boolean isFormatted() {
        if (this.prioritizedFluids.isEmpty()) {
            return false;
        }
        for (Fluid currentFluid : this.prioritizedFluids) {
            if (currentFluid == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return input != null && this.prioritizedFluids.contains(input.getFluid());
    }

    private void requestSave() {
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((ICellInventory)this);
        }
    }

    @Override
    public int totalBytes() {
        return this.totalBytes;
    }

    @Override
    public int totalTypes() {
        return this.totalTypes;
    }

    @Override
    public int usedBytes() {
        return this.totalBytes - this.freeBytes();
    }

    @Override
    public int usedTypes() {
        int i = 0;
        for (FluidStack stack : this.fluidStacks) {
            if (stack == null) continue;
            ++i;
        }
        return i;
    }

    public boolean validForPass(int i) {
        return true;
    }

    protected void writeFluidToSlot(int i, FluidStack fluidStack) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        if (fluidStack != null && fluidStack.amount > 0) {
            fluidStack.writeToNBT(fluidTag);
            this.stackTag.func_74782_a("Fluid#" + i, (NBTBase)fluidTag);
        } else {
            this.stackTag.func_82580_o("Fluid#" + i);
        }
        this.fluidStacks.set(i, fluidStack);
    }

    public ICellInventory<IAEFluidStack> getCellInv() {
        return this;
    }

    public boolean isPreformatted() {
        return this.isFormatted();
    }

    public boolean isFuzzy() {
        return this.getFuzzyMode() != FuzzyMode.IGNORE_ALL;
    }

    public IncludeExclude getIncludeExcludeMode() {
        return IncludeExclude.WHITELIST;
    }

    public ItemStack getItemStack() {
        return this.storageStack;
    }

    protected ICellWorkbenchItem getCellItem() {
        return (ICellWorkbenchItem)this.getItemStack().func_77973_b();
    }

    public double getIdleDrain() {
        return 1.0;
    }

    public FuzzyMode getFuzzyMode() {
        return this.getCellItem().getFuzzyMode(this.getItemStack());
    }

    public IItemHandler getConfigInventory() {
        return this.getCellItem().getConfigInventory(this.getItemStack());
    }

    public IItemHandler getUpgradesInventory() {
        return this.getCellItem().getUpgradesInventory(this.getItemStack());
    }

    public int getBytesPerType() {
        return 8;
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public long getTotalBytes() {
        return this.totalBytes();
    }

    public long getFreeBytes() {
        return this.freeBytes();
    }

    public long getUsedBytes() {
        return this.usedBytes();
    }

    public long getTotalItemTypes() {
        return this.totalTypes();
    }

    public long getStoredItemCount() {
        return 0L;
    }

    public long getStoredItemTypes() {
        return this.usedTypes();
    }

    public long getRemainingItemTypes() {
        return this.totalTypes() - this.usedTypes();
    }

    public long getRemainingItemCount() {
        return 0L;
    }

    public int getUnusedItemCount() {
        return 0;
    }

    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    public void persist() {
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((ICellInventory)this);
        }
    }
}

