/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.MekanismRecipeHelper;
import mekanism.api.util.BlockInfo;
import net.minecraft.block.Block;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.LogManager;

public class MekanismAPI {
    public static final String MODID = "mekanism";
    public static boolean debug = false;
    private static Set<BlockInfo> cardboardBoxIgnore = new HashSet<BlockInfo>();
    private static Set<String> cardboardBoxModIgnore = new HashSet<String>();
    private static MekanismRecipeHelper helper = null;

    public static boolean isBlockCompatible(Block block, int meta) {
        if (cardboardBoxModIgnore.contains(Objects.requireNonNull(block.getRegistryName()).func_110624_b())) {
            return false;
        }
        for (BlockInfo i : cardboardBoxIgnore) {
            if (i.block != block || i.meta != Short.MAX_VALUE && i.meta != meta) continue;
            return false;
        }
        return true;
    }

    public static void addBoxBlacklist(Block block, int meta) {
        if (block == null) {
            return;
        }
        cardboardBoxIgnore.add(new BlockInfo(block, meta));
    }

    public static void removeBoxBlacklist(Block block, int meta) {
        cardboardBoxIgnore.remove(new BlockInfo(block, meta));
    }

    public static Set<BlockInfo> getBoxIgnore() {
        return cardboardBoxIgnore;
    }

    public static void addBoxBlacklistMod(@Nonnull String modid) {
        cardboardBoxModIgnore.add(modid);
    }

    public static void removeBoxBlacklistMod(@Nonnull String modid) {
        cardboardBoxModIgnore.remove(modid);
    }

    public static Set<String> getBoxModIgnore() {
        return cardboardBoxModIgnore;
    }

    public static MekanismRecipeHelper recipeHelper() {
        if (helper == null) {
            try {
                helper = (MekanismRecipeHelper)Class.forName("mekanism.common.recipe.APIHandler").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LogManager.getLogger((String)"MekanismAPI").error("Could not find API Handler", (Throwable)e);
            }
        }
        return helper;
    }

    public static class BoxBlacklistEvent
    extends Event {
        public void blacklist(Block block, int meta) {
            MekanismAPI.addBoxBlacklist(block, meta);
        }

        public void blacklist(Block block) {
            MekanismAPI.addBoxBlacklist(block, Short.MAX_VALUE);
        }

        public void blacklistMod(String modid) {
            MekanismAPI.addBoxBlacklistMod(modid);
        }
    }
}

