/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransmitterNetworkRegistry {
    private static TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private static Logger logger = LogManager.getLogger((String)"MekanismTransmitters");
    private HashSet<DynamicNetwork> networks = Sets.newHashSet();
    private HashSet<DynamicNetwork> networksToChange = Sets.newHashSet();
    private HashSet<IGridTransmitter> invalidTransmitters = Sets.newHashSet();
    private HashMap<Coord4D, IGridTransmitter> orphanTransmitters = Maps.newHashMap();
    private HashMap<Coord4D, IGridTransmitter> newOrphanTransmitters = Maps.newHashMap();

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static void reset() {
        TransmitterNetworkRegistry.getInstance().networks.clear();
        TransmitterNetworkRegistry.getInstance().networksToChange.clear();
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().orphanTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.clear();
    }

    public static void invalidateTransmitter(IGridTransmitter transmitter) {
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.add(transmitter);
    }

    public static void registerOrphanTransmitter(IGridTransmitter transmitter) {
        Coord4D coord = transmitter.coord();
        IGridTransmitter previous = TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.put(coord, transmitter);
        if (previous != null && previous != transmitter) {
            logger.error("Different orphan transmitter was already registered at location! {}", (Object)coord.toString());
        }
    }

    public static void registerChangedNetwork(DynamicNetwork network) {
        TransmitterNetworkRegistry.getInstance().networksToChange.add(network);
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(DynamicNetwork network) {
        this.networks.add(network);
    }

    public void removeNetwork(DynamicNetwork network) {
        this.networks.remove(network);
        this.networksToChange.remove(network);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            this.tickEnd();
        }
    }

    public void tickEnd() {
        this.removeInvalidTransmitters();
        this.assignOrphans();
        this.commitChanges();
        for (DynamicNetwork net : this.networks) {
            net.tick();
        }
    }

    public void removeInvalidTransmitters() {
        if (MekanismAPI.debug && !this.invalidTransmitters.isEmpty()) {
            logger.info("Dealing with " + this.invalidTransmitters.size() + " invalid Transmitters");
        }
        for (IGridTransmitter invalid : this.invalidTransmitters) {
            Object n;
            if (invalid.isOrphan() && invalid.isValid() || (n = invalid.getTransmitterNetwork()) == null) continue;
            ((DynamicNetwork)n).invalidate();
        }
        this.invalidTransmitters.clear();
    }

    public void assignOrphans() {
        this.orphanTransmitters = new HashMap<Coord4D, IGridTransmitter>(this.newOrphanTransmitters);
        this.newOrphanTransmitters.clear();
        if (MekanismAPI.debug && !this.orphanTransmitters.isEmpty()) {
            logger.info("Dealing with " + this.orphanTransmitters.size() + " orphan Transmitters");
        }
        for (IGridTransmitter orphanTransmitter : new HashMap<Coord4D, IGridTransmitter>(this.orphanTransmitters).values()) {
            DynamicNetwork network = this.getNetworkFromOrphan(orphanTransmitter);
            if (network == null) continue;
            this.networksToChange.add(network);
            network.register();
        }
        this.orphanTransmitters.clear();
    }

    public <A, N extends DynamicNetwork<A, N>> DynamicNetwork<A, N> getNetworkFromOrphan(IGridTransmitter<A, N> startOrphan) {
        if (startOrphan.isValid() && startOrphan.isOrphan()) {
            Object network;
            OrphanPathFinder<A, N> finder = new OrphanPathFinder<A, N>(startOrphan);
            finder.start();
            switch (finder.networksFound.size()) {
                case 0: {
                    if (MekanismAPI.debug) {
                        logger.info("No networks found. Creating new network for " + finder.connectedTransmitters.size() + " transmitters");
                    }
                    network = startOrphan.createEmptyNetwork();
                    break;
                }
                case 1: {
                    if (MekanismAPI.debug) {
                        logger.info("Adding " + finder.connectedTransmitters.size() + " transmitters to single found network");
                    }
                    network = (DynamicNetwork)finder.networksFound.iterator().next();
                    break;
                }
                default: {
                    if (MekanismAPI.debug) {
                        logger.info("Merging " + finder.networksFound.size() + " networks with " + finder.connectedTransmitters.size() + " new transmitters");
                    }
                    network = startOrphan.mergeNetworks(finder.networksFound);
                }
            }
            ((DynamicNetwork)network).addNewTransmitters(finder.connectedTransmitters);
            return network;
        }
        return null;
    }

    public void commitChanges() {
        for (DynamicNetwork network : this.networksToChange) {
            network.commit();
        }
        this.networksToChange.clear();
    }

    public String toString() {
        return "Network Registry:\n" + this.networks;
    }

    public String[] toStrings() {
        String[] strings = new String[this.networks.size()];
        int i = 0;
        for (DynamicNetwork network : this.networks) {
            strings[i++] = network.toString();
        }
        return strings;
    }

    public class OrphanPathFinder<A, N extends DynamicNetwork<A, N>> {
        public IGridTransmitter<A, N> startPoint;
        public HashSet<Coord4D> iterated = Sets.newHashSet();
        public HashSet<IGridTransmitter<A, N>> connectedTransmitters = Sets.newHashSet();
        public HashSet<N> networksFound = Sets.newHashSet();
        private Deque<Coord4D> queue = new LinkedList<Coord4D>();

        public OrphanPathFinder(IGridTransmitter<A, N> start) {
            this.startPoint = start;
        }

        public void start() {
            if (this.queue.peek() != null) {
                logger.error("OrphanPathFinder queue was not empty?!");
                this.queue.clear();
            }
            this.queue.push(this.startPoint.coord());
            while (this.queue.peek() != null) {
                this.iterate(this.queue.removeFirst());
            }
        }

        public void iterate(Coord4D from) {
            if (this.iterated.contains(from)) {
                return;
            }
            this.iterated.add(from);
            if (TransmitterNetworkRegistry.this.orphanTransmitters.containsKey(from)) {
                IGridTransmitter transmitter = (IGridTransmitter)TransmitterNetworkRegistry.this.orphanTransmitters.get(from);
                if (transmitter.isValid() && transmitter.isOrphan()) {
                    this.connectedTransmitters.add(transmitter);
                    transmitter.setOrphan(false);
                    for (EnumFacing direction : EnumFacing.field_82609_l) {
                        Coord4D directionCoord;
                        if (direction.func_176740_k().func_176722_c() && !transmitter.world().func_175667_e(from.getPos().func_177972_a(direction)) || (directionCoord = transmitter.getAdjacentConnectableTransmitterCoord(direction)) == null || this.iterated.contains(directionCoord)) continue;
                        this.queue.addLast(directionCoord);
                    }
                }
            } else {
                this.addNetworkToIterated(from);
            }
        }

        public void addNetworkToIterated(Coord4D from) {
            N net = this.startPoint.getExternalNetwork(from);
            if (net != null) {
                this.networksFound.add(net);
            }
        }
    }
}

