/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.gui.element.GuiVisualsTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.inventory.container.ContainerDigitalMiner;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiDigitalMiner
extends GuiMekanism {
    public TileEntityDigitalMiner tileEntity;
    public GuiButton startButton;
    public GuiButton stopButton;
    public GuiButton configButton;

    public GuiDigitalMiner(InventoryPlayer inventory, TileEntityDigitalMiner tentity) {
        super(tentity, new ContainerDigitalMiner(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png")));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png")));
        this.guiElements.add(new GuiUpgradeTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png")));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png"), 163, 23));
        this.guiElements.add(new GuiVisualsTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png")));
        this.guiElements.add(new GuiEnergyInfo(() -> {
            double perTick = this.tileEntity.getPerTick();
            String multiplier = MekanismUtils.getEnergyDisplay(perTick);
            ArrayList<String> ret = new ArrayList<String>(4);
            ret.add(LangUtils.localize("mekanism.gui.digitalMiner.capacity") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getMaxEnergy()));
            ret.add(LangUtils.localize("gui.needed") + ": " + multiplier + "/t");
            if (perTick > this.tileEntity.getMaxEnergy()) {
                ret.add(TextFormatting.RED + LangUtils.localize("mekanism.gui.insufficientbuffer"));
            }
            ret.add(LangUtils.localize("mekanism.gui.bufferfree") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getMaxEnergy() - this.tileEntity.getEnergy()));
            return ret;
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png")));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png"), 151, 5).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png"), 143, 26));
        this.field_147000_g += 64;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.startButton = new GuiButton(0, guiWidth + 69, guiHeight + 17, 60, 20, LangUtils.localize("gui.start"));
        if (this.tileEntity.searcher.state != ThreadMinerSearch.State.IDLE && this.tileEntity.running) {
            this.startButton.field_146124_l = false;
        }
        this.stopButton = new GuiButton(1, guiWidth + 69, guiHeight + 37, 60, 20, LangUtils.localize("gui.stop"));
        if (this.tileEntity.searcher.state == ThreadMinerSearch.State.IDLE || !this.tileEntity.running) {
            this.stopButton.field_146124_l = false;
        }
        this.configButton = new GuiButton(2, guiWidth + 69, guiHeight + 57, 60, 20, LangUtils.localize("gui.config"));
        if (this.tileEntity.searcher.state != ThreadMinerSearch.State.IDLE) {
            this.configButton.field_146124_l = false;
        }
        this.field_146292_n.add(this.startButton);
        this.field_146292_n.add(this.stopButton);
        this.field_146292_n.add(this.configButton);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            TileNetworkList data = TileNetworkList.withContents(3);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
        } else if (guibutton.field_146127_k == 1) {
            TileNetworkList data = TileNetworkList.withContents(4);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
        } else if (guibutton.field_146127_k == 2) {
            Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.startButton.field_146124_l = this.tileEntity.searcher.state == ThreadMinerSearch.State.IDLE || !this.tileEntity.running;
        this.stopButton.field_146124_l = this.tileEntity.searcher.state != ThreadMinerSearch.State.IDLE && this.tileEntity.running;
        this.configButton.field_146124_l = this.tileEntity.searcher.state == ThreadMinerSearch.State.IDLE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), 69, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String runningType = this.tileEntity.getPerTick() > this.tileEntity.getMaxEnergy() ? LangUtils.localize("mekanism.gui.digitalMiner.lowPower") : (this.tileEntity.running ? LangUtils.localize("gui.digitalMiner.running") : LangUtils.localize("gui.idle"));
        this.field_146289_q.func_78276_b(runningType, 9, 10, 52480);
        this.field_146289_q.func_78276_b(this.tileEntity.searcher.state.desc, 9, 19, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + LangUtils.localize("gui." + (this.tileEntity.doEject ? "on" : "off")), 9, 30, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.pull") + ": " + LangUtils.localize("gui." + (this.tileEntity.doPull ? "on" : "off")), 9, 39, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.silk") + ": " + LangUtils.localize("gui." + (this.tileEntity.silkTouch ? "on" : "off")), 9, 48, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.toMine") + ":", 9, 59, 52480);
        this.field_146289_q.func_78276_b("" + this.tileEntity.clientToMine, 9, 68, 52480);
        if (!this.tileEntity.missingStack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            this.drawTexturedRectFromIcon(144, 27, MekanismRenderer.getColorIcon(EnumColor.DARK_RED), 16, 16);
            this.field_146296_j.func_180450_b(this.tileEntity.missingStack, 144, 27);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSlot.png"));
            this.func_73729_b(143, 26, GuiSlot.SlotOverlay.CHECK.textureX, GuiSlot.SlotOverlay.CHECK.textureY, 18, 18);
        }
        if (xAxis >= 164 && xAxis <= 168 && yAxis >= 25 && yAxis <= 77) {
            this.func_146279_a(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy(), this.tileEntity.getMaxEnergy()), xAxis, yAxis);
        }
        if (xAxis >= 147 && xAxis <= 161 && yAxis >= 47 && yAxis <= 61) {
            this.func_146279_a(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        if (xAxis >= 147 && xAxis <= 161 && yAxis >= 63 && yAxis <= 77) {
            this.func_146279_a(LangUtils.localize("gui.digitalMiner.autoPull"), xAxis, yAxis);
        }
        if (xAxis >= 144 && xAxis <= 160 && yAxis >= 27 && yAxis <= 43) {
            if (!this.tileEntity.missingStack.func_190926_b()) {
                this.func_146279_a(LangUtils.localize("gui.digitalMiner.missingBlock"), xAxis, yAxis);
            } else {
                this.func_146279_a(LangUtils.localize("gui.well"), xAxis, yAxis);
            }
        }
        if (xAxis >= 131 && xAxis <= 145 && yAxis >= 47 && yAxis <= 61) {
            this.func_146279_a(LangUtils.localize("gui.digitalMiner.reset"), xAxis, yAxis);
        }
        if (xAxis >= 131 && xAxis <= 145 && yAxis >= 63 && yAxis <= 77) {
            this.func_146279_a(LangUtils.localize("gui.digitalMiner.silkTouch"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        int displayInt = this.tileEntity.getScaledEnergyLevel(52);
        this.func_73729_b(guiWidth + 164, guiHeight + 25 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);
        if (xAxis >= 147 && xAxis <= 161 && yAxis >= 47 && yAxis <= 61) {
            this.func_73729_b(guiWidth + 147, guiHeight + 47, 180, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 147, guiHeight + 47, 180, 14, 14, 14);
        }
        if (xAxis >= 147 && xAxis <= 161 && yAxis >= 63 && yAxis <= 77) {
            this.func_73729_b(guiWidth + 147, guiHeight + 63, 194, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 147, guiHeight + 63, 194, 14, 14, 14);
        }
        if (xAxis >= 131 && xAxis <= 145 && yAxis >= 47 && yAxis <= 61) {
            this.func_73729_b(guiWidth + 131, guiHeight + 47, 208, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 131, guiHeight + 47, 208, 14, 14, 14);
        }
        if (xAxis >= 131 && xAxis <= 145 && yAxis >= 63 && yAxis <= 77) {
            this.func_73729_b(guiWidth + 131, guiHeight + 63, 222, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 131, guiHeight + 63, 222, 14, 14, 14);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            TileNetworkList data;
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 147 && xAxis <= 161 && yAxis >= 47 && yAxis <= 61) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                data = TileNetworkList.withContents(0);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            }
            if (xAxis >= 147 && xAxis <= 161 && yAxis >= 63 && yAxis <= 77) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                data = TileNetworkList.withContents(1);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            }
            if (xAxis >= 131 && xAxis <= 145 && yAxis >= 47 && yAxis <= 61) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                data = TileNetworkList.withContents(5);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            }
            if (xAxis >= 131 && xAxis <= 145 && yAxis >= 63 && yAxis <= 77) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                data = TileNetworkList.withContents(9);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            }
        }
    }
}

