/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPowerBar
extends GuiElement {
    private int xLocation;
    private int yLocation;
    private int width = 6;
    private int height = 56;
    private int innerOffsetY = 2;
    private IStrictEnergyStorage tileEntity;
    private IPowerInfoHandler handler;

    public GuiPowerBar(IGuiWrapper gui, IStrictEnergyStorage tile, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiPowerBar.png"), gui, def);
        this.tileEntity = tile;
        this.handler = new IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiPowerBar.this.tileEntity.getEnergy(), GuiPowerBar.this.tileEntity.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiPowerBar.this.tileEntity.getEnergy() / GuiPowerBar.this.tileEntity.getMaxEnergy();
            }
        };
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiPowerBar(IGuiWrapper gui, IPowerInfoHandler h, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiPowerBar.png"), gui, def);
        this.handler = h;
        this.xLocation = x;
        this.yLocation = y;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, this.height);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiPowerBar.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, 0, 0, this.width, this.height);
        if (this.handler.getLevel() > 0.0) {
            int displayInt = (int)(this.handler.getLevel() * 52.0) + this.innerOffsetY;
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation + this.height - displayInt, 6, this.height - displayInt, this.width, displayInt);
        }
        GuiPowerBar.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiPowerBar.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.getTooltip() != null && xAxis >= this.xLocation && xAxis <= this.xLocation + this.width && yAxis >= this.yLocation && yAxis <= this.yLocation + this.height) {
            this.displayTooltip(this.handler.getTooltip(), xAxis, yAxis);
        }
        GuiPowerBar.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static abstract class IPowerInfoHandler {
        public String getTooltip() {
            return null;
        }

        public abstract double getLevel();
    }
}

