/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRateBar
extends GuiElement {
    private int xLocation;
    private int yLocation;
    private int width = 8;
    private int height = 60;
    private IRateInfoHandler handler;

    public GuiRateBar(IGuiWrapper gui, IRateInfoHandler h, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiRateBar.png"), gui, def);
        this.handler = h;
        this.xLocation = x;
        this.yLocation = y;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, this.height);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiRateBar.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, 0, 0, this.width, this.height);
        if (this.handler.getLevel() > 0.0) {
            int displayInt = (int)(this.handler.getLevel() * 58.0);
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation + 1, guiHeight + this.yLocation + this.height - 1 - displayInt, 8, this.height - 2 - displayInt, this.width - 2, displayInt);
        }
        GuiRateBar.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiRateBar.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.getTooltip() != null && xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1) {
            this.displayTooltip(this.handler.getTooltip(), xAxis, yAxis);
        }
        GuiRateBar.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static abstract class IRateInfoHandler {
        public String getTooltip() {
            return null;
        }

        public abstract double getLevel();
    }
}

