/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.ColourRGBA;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import org.lwjgl.opengl.GL11;

public abstract class RenderTransmitterBase<T extends TileEntityTransmitter>
extends TileEntitySpecialRenderer<T> {
    public static Function<ResourceLocation, TextureAtlasSprite> textureGetterFlipV = location -> DummyAtlasTextureFlipV.instance;
    private static OBJModel contentsModel;
    private static Map<String, IBakedModel> contentsMap;
    protected Minecraft mc = Minecraft.func_71410_x();

    public RenderTransmitterBase() {
        if (contentsModel == null) {
            try {
                contentsModel = (OBJModel)OBJLoader.INSTANCE.loadModel(MekanismUtils.getResource(MekanismUtils.ResourceType.MODEL, "transmitter_contents.obj"));
                contentsMap = RenderTransmitterBase.buildModelMap(contentsModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static HashMap<String, IBakedModel> buildModelMap(OBJModel objModel) {
        HashMap<String, IBakedModel> modelParts = new HashMap<String, IBakedModel>();
        if (!objModel.getMatLib().getGroups().keySet().isEmpty()) {
            Iterator iterator = objModel.getMatLib().getGroups().keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String k = key = (String)iterator.next();
                if (modelParts.containsKey(key)) continue;
                modelParts.put(k, objModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)k), false), Attributes.DEFAULT_BAKED_FORMAT, textureGetterFlipV));
            }
        }
        return modelParts;
    }

    protected void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    protected void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void renderTransparency(BufferBuilder renderer, TextureAtlasSprite icon, IBakedModel cc, ColourRGBA color) {
        if (!renderer.field_179010_r) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        }
        for (EnumFacing side : EnumFacing.values()) {
            for (BakedQuad quad : cc.func_188616_a(null, side, 0L)) {
                quad = MekanismRenderer.iconTransform(quad, icon);
                LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)color.argb());
            }
        }
        for (BakedQuad quad : cc.func_188616_a(null, null, 0L)) {
            quad = MekanismRenderer.iconTransform(quad, icon);
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)color.argb());
        }
    }

    public IBakedModel getModelForSide(TileEntityTransmitter part, EnumFacing side) {
        String sideName = side.name().toLowerCase(Locale.ROOT);
        String typeName = part.getConnectionType(side).name().toUpperCase();
        String name = sideName + typeName;
        return contentsMap.get(name);
    }

    static {
        contentsMap = new HashMap<String, IBakedModel>();
    }

    private static class DummyAtlasTextureFlipV
    extends TextureAtlasSprite {
        public static DummyAtlasTextureFlipV instance = new DummyAtlasTextureFlipV();

        protected DummyAtlasTextureFlipV() {
            super("dummyFlipV");
        }

        public float func_94214_a(double u) {
            return (float)u / 16.0f;
        }

        public float func_94207_b(double v) {
            return (float)v / -16.0f;
        }
    }
}

