/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mekanism.api.IMekWrench;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.ITierItem;
import mekanism.common.block.property.PropertyConnection;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityRestrictiveTransporter;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTransmitter
extends Block
implements ITileEntityProvider {
    public static AxisAlignedBB[] smallSides = new AxisAlignedBB[7];
    public static AxisAlignedBB[] largeSides = new AxisAlignedBB[7];
    public static AxisAlignedBB smallDefault;
    public static AxisAlignedBB largeDefault;

    public BlockTransmitter() {
        super(Material.field_76233_E);
        this.func_149647_a(Mekanism.tabMekanism);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
    }

    private static AxisAlignedBB getDefaultForTile(TileEntitySidedPipe tile) {
        if (tile == null || tile.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL) {
            return smallDefault;
        }
        return largeDefault;
    }

    private static void setDefaultForTile(TileEntitySidedPipe tile, AxisAlignedBB box) {
        if (tile == null) {
            return;
        }
        if (box == null) {
            throw new IllegalStateException("box should not be null");
        }
        if (tile.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL) {
            smallDefault = box;
            return;
        }
        largeDefault = box;
    }

    private static TileEntitySidedPipe getTileEntitySidedPipe(IBlockAccess world, BlockPos pos) {
        TileEntity childEntity;
        TileEntity tileEntity = MekanismUtils.getTileEntitySafe(world, pos);
        TileEntitySidedPipe sidedPipe = null;
        if (tileEntity instanceof TileEntitySidedPipe) {
            sidedPipe = (TileEntitySidedPipe)tileEntity;
        } else if (Mekanism.hooks.MCMPLoaded && (childEntity = MultipartMekanism.unwrapTileEntity(world)) instanceof TileEntitySidedPipe) {
            sidedPipe = (TileEntitySidedPipe)childEntity;
        }
        return sidedPipe;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe(worldIn, pos);
        if (tile != null) {
            state = state.func_177226_a(BlockStateTransmitter.tierProperty, (Comparable)((Object)tile.getBaseTier()));
        }
        return state;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.get(meta);
        return this.func_176223_P().func_177226_a(BlockStateTransmitter.typeProperty, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        BlockStateTransmitter.TransmitterType type = (BlockStateTransmitter.TransmitterType)((Object)state.func_177229_b(BlockStateTransmitter.typeProperty));
        return type.ordinal();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateTransmitter(this);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess w, BlockPos pos) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe(w, pos);
        if (tile != null) {
            return tile.getExtendedState(state);
        }
        TileEntitySidedPipe.ConnectionType[] typeArray = new TileEntitySidedPipe.ConnectionType[]{TileEntitySidedPipe.ConnectionType.NORMAL, TileEntitySidedPipe.ConnectionType.NORMAL, TileEntitySidedPipe.ConnectionType.NORMAL, TileEntitySidedPipe.ConnectionType.NORMAL, TileEntitySidedPipe.ConnectionType.NORMAL, TileEntitySidedPipe.ConnectionType.NORMAL};
        PropertyConnection connectionProp = new PropertyConnection(0, 0, typeArray, true);
        return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE, (Object)new OBJModel.OBJState(Arrays.asList(new String[0]), true)).withProperty((IUnlistedProperty)PropertyConnection.INSTANCE, (Object)connectionProp);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe(world, pos);
        if (tile != null && tile.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL) {
            return smallSides[6];
        }
        return largeSides[6];
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe((IBlockAccess)world, pos);
        if (tile != null) {
            List<AxisAlignedBB> boxes = tile.getCollisionBoxes(entityBox.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())));
            for (AxisAlignedBB box : boxes) {
                collidingBoxes.add(box.func_186670_a(pos));
            }
        }
    }

    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return BlockTransmitter.getDefaultForTile(BlockTransmitter.getTileEntitySidedPipe((IBlockAccess)world, pos)).func_186670_a(pos);
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe((IBlockAccess)world, pos);
        if (tile == null) {
            return null;
        }
        List<AxisAlignedBB> boxes = tile.getCollisionBoxes();
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(pos, start, end, boxes);
        if (result != null && result.valid()) {
            BlockTransmitter.setDefaultForTile(tile, result.bounds);
        }
        return result != null ? result.hit : null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        RayTraceResult raytrace;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        IMekWrench wrenchHandler = Wrenches.getHandler(stack);
        if (wrenchHandler != null && wrenchHandler.canUseWrench(player, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos)) && player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.dismantleBlock(state, world, pos, false);
            }
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemStack = ItemStack.field_190927_a;
        TileEntitySidedPipe tileEntity = BlockTransmitter.getTileEntitySidedPipe((IBlockAccess)world, pos);
        if (tileEntity != null) {
            itemStack = new ItemStack(MekanismBlocks.Transmitter, 1, tileEntity.getTransmitterType().ordinal());
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            ITierItem tierItem = (ITierItem)itemStack.func_77973_b();
            tierItem.setBaseTier(itemStack, tileEntity.getBaseTier());
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(state, null, world, pos, null);
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public void func_149666_a(CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        for (BlockStateTransmitter.TransmitterType type : BlockStateTransmitter.TransmitterType.values()) {
            if (type.hasTiers()) {
                for (Tier.BaseTier tier : Tier.BaseTier.values()) {
                    if (!tier.isObtainable()) continue;
                    list.add((Object)MekanismUtils.getTransmitter(type, tier, 1));
                }
                continue;
            }
            list.add((Object)MekanismUtils.getTransmitter(type, Tier.BaseTier.BASIC, 1));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe((IBlockAccess)world, pos);
        if (tile != null) {
            tile.onAdded();
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe((IBlockAccess)world, pos);
        if (tile != null) {
            EnumFacing side = EnumFacing.func_176737_a((float)(neighbor.func_177958_n() - pos.func_177958_n()), (float)(neighbor.func_177956_o() - pos.func_177956_o()), (float)(neighbor.func_177952_p() - pos.func_177952_p()));
            tile.onNeighborBlockChange(side);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntitySidedPipe tile = BlockTransmitter.getTileEntitySidedPipe(world, pos);
        if (tile != null) {
            EnumFacing side = EnumFacing.func_176737_a((float)(neighbor.func_177958_n() - pos.func_177958_n()), (float)(neighbor.func_177956_o() - pos.func_177956_o()), (float)(neighbor.func_177952_p() - pos.func_177952_p()));
            tile.onNeighborTileChange(side);
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        BlockStateTransmitter.TransmitterType type = (BlockStateTransmitter.TransmitterType)((Object)state.func_177229_b(BlockStateTransmitter.typeProperty));
        if (layer == BlockRenderLayer.TRANSLUCENT && (type == BlockStateTransmitter.TransmitterType.LOGISTICAL_TRANSPORTER || type == BlockStateTransmitter.TransmitterType.DIVERSION_TRANSPORTER)) {
            return true;
        }
        return layer == BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, this.getPickBlock(state, null, world, pos, player));
            world.func_72838_d((Entity)entityItem);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.get(meta);
        switch (type) {
            case UNIVERSAL_CABLE: {
                return new TileEntityUniversalCable();
            }
            case MECHANICAL_PIPE: {
                return new TileEntityMechanicalPipe();
            }
            case PRESSURIZED_TUBE: {
                return new TileEntityPressurizedTube();
            }
            case LOGISTICAL_TRANSPORTER: {
                return new TileEntityLogisticalTransporter();
            }
            case DIVERSION_TRANSPORTER: {
                return new TileEntityDiversionTransporter();
            }
            case RESTRICTIVE_TRANSPORTER: {
                return new TileEntityRestrictiveTransporter();
            }
            case THERMODYNAMIC_CONDUCTOR: {
                return new TileEntityThermodynamicConductor();
            }
        }
        return null;
    }

    static {
        BlockTransmitter.smallSides[0] = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.3, 0.7);
        BlockTransmitter.smallSides[1] = new AxisAlignedBB(0.3, 0.7, 0.3, 0.7, 1.0, 0.7);
        BlockTransmitter.smallSides[2] = new AxisAlignedBB(0.3, 0.3, 0.0, 0.7, 0.7, 0.3);
        BlockTransmitter.smallSides[3] = new AxisAlignedBB(0.3, 0.3, 0.7, 0.7, 0.7, 1.0);
        BlockTransmitter.smallSides[4] = new AxisAlignedBB(0.0, 0.3, 0.3, 0.3, 0.7, 0.7);
        BlockTransmitter.smallSides[5] = new AxisAlignedBB(0.7, 0.3, 0.3, 1.0, 0.7, 0.7);
        BlockTransmitter.smallSides[6] = new AxisAlignedBB(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
        BlockTransmitter.largeSides[0] = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);
        BlockTransmitter.largeSides[1] = new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.0, 0.75);
        BlockTransmitter.largeSides[2] = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25);
        BlockTransmitter.largeSides[3] = new AxisAlignedBB(0.25, 0.25, 0.75, 0.75, 0.75, 1.0);
        BlockTransmitter.largeSides[4] = new AxisAlignedBB(0.0, 0.25, 0.25, 0.25, 0.75, 0.75);
        BlockTransmitter.largeSides[5] = new AxisAlignedBB(0.75, 0.25, 0.25, 1.0, 0.75, 0.75);
        BlockTransmitter.largeSides[6] = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
        smallDefault = smallSides[6];
        largeDefault = largeSides[6];
    }
}

