/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.injection")
@ModOnly(value="mtlib")
@ZenRegister
public class ChemicalInjection {
    public static final String NAME = "Mekanism Chemical Injection Chamber";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IGasStack gasInput, IItemStack itemOutput) {
        if (itemInput == null || gasInput == null || itemOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        AdvancedMachineInput input = new AdvancedMachineInput(InputHelper.toStack((IItemStack)itemInput), GasHelper.toGas(gasInput).getGas());
        ItemStackOutput output = new ItemStackOutput(InputHelper.toStack((IItemStack)itemOutput));
        InjectionRecipe recipe = new InjectionRecipe(input, output);
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe<AdvancedMachineInput, InjectionRecipe>(NAME, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient gasInput) {
        if (itemOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        if (gasInput == null) {
            gasInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get(), itemOutput, itemInput, gasInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe<AdvancedMachineInput, InjectionRecipe> {
        private IIngredient itemOutput;
        private IIngredient itemInput;
        private IIngredient gasInput;

        public Remove(String name, Map<AdvancedMachineInput, InjectionRecipe> map, IIngredient itemOutput, IIngredient itemInput, IIngredient gasInput) {
            super(name, map);
            this.itemOutput = itemOutput;
            this.itemInput = itemInput;
            this.gasInput = gasInput;
        }

        @Override
        public void addRecipes() {
            HashMap<AdvancedMachineInput, InjectionRecipe> recipesToRemove = new HashMap<AdvancedMachineInput, InjectionRecipe>();
            for (Map.Entry<AdvancedMachineInput, InjectionRecipe> entry : RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get().entrySet()) {
                IItemStack inputItem = InputHelper.toIItemStack((ItemStack)entry.getKey().itemStack);
                CraftTweakerGasStack inputGas = new CraftTweakerGasStack(new GasStack(entry.getKey().gasType, 1));
                IItemStack outputItem = InputHelper.toIItemStack((ItemStack)((ItemStackOutput)entry.getValue().recipeOutput).output);
                if (!StackHelper.matches((IIngredient)this.itemOutput, (IItemStack)outputItem) || !StackHelper.matches((IIngredient)this.itemInput, (IItemStack)inputItem) || !GasHelper.matches(this.gasInput, inputGas)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logInfo((String)String.format("No %s recipe found for %s, %s and %s. Command ignored!", ChemicalInjection.NAME, this.itemOutput.toString(), this.itemInput.toString(), this.gasInput.toString()));
            }
        }
    }
}

