/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.oxidizer")
@ModOnly(value="mtlib")
@ZenRegister
public class ChemicalOxidizer {
    public static final String NAME = "Mekanism Chemical Oxidizer";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IGasStack gasOutput) {
        if (itemInput == null || gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        OxidationRecipe recipe = new OxidationRecipe(InputHelper.toStack((IItemStack)itemInput), GasHelper.toGas(gasOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe<ItemStackInput, OxidationRecipe>(NAME, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasOutput, @Optional IIngredient itemInput) {
        if (gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get(), gasOutput, itemInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe<ItemStackInput, OxidationRecipe> {
        private IIngredient gasOutput;
        private IIngredient itemInput;

        public Remove(String name, Map<ItemStackInput, OxidationRecipe> map, IIngredient gasOutput, IIngredient itemInput) {
            super(name, map);
            this.gasOutput = gasOutput;
            this.itemInput = itemInput;
        }

        @Override
        public void addRecipes() {
            HashMap<ItemStackInput, OxidationRecipe> recipesToRemove = new HashMap<ItemStackInput, OxidationRecipe>();
            for (Map.Entry<ItemStackInput, OxidationRecipe> entry : RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get().entrySet()) {
                IItemStack inputItem = InputHelper.toIItemStack((ItemStack)entry.getKey().ingredient);
                CraftTweakerGasStack outputGas = new CraftTweakerGasStack(((GasOutput)entry.getValue().recipeOutput).output);
                if (!StackHelper.matches((IIngredient)this.itemInput, (IItemStack)inputItem) || !GasHelper.matches(this.gasOutput, outputGas)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logInfo((String)String.format("No %s recipe found for %s and %s. Command ignored!", ChemicalOxidizer.NAME, this.gasOutput.toString(), this.itemInput.toString()));
            }
        }
    }
}

