/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.multipart;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.addon.IMCMPAddon;
import mcmultipart.api.addon.MCMPAddon;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.event.DrawMultipartHighlightEvent;
import mcmultipart.api.item.ItemBlockMultipart;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartRegistry;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import mcmultipart.multipart.MultipartRegistry;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockTransmitter;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.multipart.MultipartGlowPanel;
import mekanism.common.integration.multipart.MultipartTile;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.integration.multipart.MultipartTransmitter;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MCMPAddon
public class MultipartMekanism
implements IMCMPAddon {
    public static MultipartTransmitter TRANSMITTER_MP;
    public static MultipartGlowPanel GLOWPANEL_MP;

    public static boolean hasConnectionWith(TileEntity tile, EnumFacing side) {
        IPartInfo partInfo;
        IMultipartTile multipartTile;
        if (tile != null && tile.hasCapability(MCMPCapabilities.MULTIPART_TILE, null) && (multipartTile = (IMultipartTile)tile.getCapability(MCMPCapabilities.MULTIPART_TILE, null)) instanceof MultipartTile && ((MultipartTile)multipartTile).getID().equals("transmitter") && (partInfo = ((MultipartTile)multipartTile).getInfo()) != null) {
            for (IPartInfo info : partInfo.getContainer().getParts().values()) {
                IMultipart multipart = info.getPart();
                Collection<AxisAlignedBB> origBounds = MultipartMekanism.getTransmitterSideBounds(multipartTile, side);
                if (!MultipartOcclusionHelper.testBoxIntersection(origBounds, (Collection)multipart.getOcclusionBoxes(info))) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<AxisAlignedBB> getTransmitterSideBounds(IMultipartTile tile, EnumFacing side) {
        if (tile.getTileEntity() instanceof TileEntityTransmitter) {
            TileEntityTransmitter transmitter = (TileEntityTransmitter)tile.getTileEntity();
            boolean large = transmitter.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.LARGE;
            AxisAlignedBB ret = large ? BlockTransmitter.largeSides[side.ordinal()] : BlockTransmitter.smallSides[side.ordinal()];
            return Collections.singletonList(ret);
        }
        return Collections.emptyList();
    }

    static IMultipartContainer getContainer(IBlockAccess world, BlockPos pos) {
        IMultipartContainer container = null;
        if (world instanceof IMultipartBlockAccess) {
            container = ((IMultipartBlockAccess)world).getPartInfo().getContainer();
        } else {
            TileEntity possibleContainer = world.func_175625_s(pos);
            if (possibleContainer instanceof IMultipartContainer) {
                container = (IMultipartContainer)possibleContainer;
            }
        }
        return container;
    }

    public static boolean hasCenterSlot(IBlockAccess world, BlockPos pos) {
        boolean hasCenterSlot = false;
        IMultipartContainer container = MultipartMekanism.getContainer(world, pos);
        if (container != null) {
            hasCenterSlot = container.getPart((IPartSlot)EnumCenterSlot.CENTER).isPresent();
        }
        return hasCenterSlot;
    }

    public static TileEntity unwrapTileEntity(IBlockAccess world) {
        TileEntity tile = null;
        if (world instanceof IMultipartBlockAccess) {
            tile = ((IMultipartBlockAccess)world).getPartInfo().getTile().getTileEntity();
        }
        return tile;
    }

    public static boolean placeMultipartBlock(Block block, ItemStack is, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        return ItemBlockMultipart.placeAt((ItemStack)is, (EntityPlayer)player, (EnumHand)player.func_184600_cs(), (World)world, (BlockPos)pos, (EnumFacing)side, (float)hitX, (float)hitY, (float)hitZ, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> ((Block)block).getStateForPlacement(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8), (int)is.func_77960_j(), (IMultipart)MultipartRegistry.INSTANCE.getPart(block), (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> ((ItemBlock)((ItemBlock)is.func_77973_b())).placeBlockAt(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8), ItemBlockMultipart::placePartAt);
    }

    @SubscribeEvent
    public void onAttachTile(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tile = (TileEntity)event.getObject();
        if (tile instanceof TileEntityTransmitter) {
            this.register(event, "transmitter");
        } else if (tile instanceof TileEntityGlowPanel) {
            this.register(event, "glow_panel");
        }
    }

    public void registerParts(IMultipartRegistry registry) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TRANSMITTER_MP = new MultipartTransmitter();
        registry.registerPartWrapper(MekanismBlocks.Transmitter, (IMultipart)TRANSMITTER_MP);
        GLOWPANEL_MP = new MultipartGlowPanel();
        registry.registerPartWrapper(MekanismBlocks.GlowPanel, (IMultipart)GLOWPANEL_MP);
        MultipartCapabilityHelper.registerCapabilityJoiner(Capabilities.TILE_NETWORK_CAPABILITY, MultipartTileNetworkJoiner::new);
    }

    private void register(final AttachCapabilitiesEvent<TileEntity> e, final String id) {
        e.addCapability(new ResourceLocation("mekanism:" + id), new ICapabilityProvider(){
            private MultipartTile tile;

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == MCMPCapabilities.MULTIPART_TILE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == MCMPCapabilities.MULTIPART_TILE) {
                    if (this.tile == null) {
                        this.tile = new MultipartTile((TileEntity)e.getObject(), id);
                    }
                    return (T)MCMPCapabilities.MULTIPART_TILE.cast((Object)this.tile);
                }
                return null;
            }
        });
    }

    public void init() {
        this.registerMicroMaterials();
    }

    public void registerMicroMaterials() {
        for (int i = 0; i < 16; ++i) {
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, i));
            if (!BlockStateMachine.MachineType.get((BlockStateMachine.MachineBlock)BlockStateMachine.MachineBlock.MACHINE_BLOCK_1, (int)i).hasModel) {
                FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.MachineBlock, 1, i));
            }
            if (BlockStateMachine.MachineType.get((BlockStateMachine.MachineBlock)BlockStateMachine.MachineBlock.MACHINE_BLOCK_2, (int)i).hasModel) continue;
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.MachineBlock2, 1, i));
        }
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock2, 1, 0));
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.CardboardBox));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawBlockHighlightEvent(DrawMultipartHighlightEvent ev) {
        IBlockState state = ev.getPartInfo().getState();
        if (state.func_177230_c() == MekanismBlocks.GlowPanel || state.func_177230_c() == MekanismBlocks.Transmitter) {
            EntityPlayer player = ev.getPlayer();
            AxisAlignedBB bb = state.func_177230_c().func_180640_a(state, ev.getPartInfo().getPartWorld(), ev.getPartInfo().getPartPos());
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)ev.getPartialTicks();
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)ev.getPartialTicks();
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)ev.getPartialTicks();
            RenderGlobal.func_189697_a((AxisAlignedBB)bb.func_186662_g(0.002).func_72317_d(-x, -y, -z), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            ev.setCanceled(true);
        }
    }
}

