/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.InventoryPersonalChest;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPersonalChest
implements IMessageHandler<PersonalChestMessage, IMessage> {
    public IMessage onMessage(PersonalChestMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            if (message.packetType == PersonalChestPacketType.SERVER_OPEN) {
                try {
                    if (message.isBlock) {
                        TileEntityPersonalChest tileEntity = (TileEntityPersonalChest)message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                        MekanismUtils.openPersonalChestGui((EntityPlayerMP)player, tileEntity, null, true);
                    } else {
                        ItemStack stack = player.func_184586_b(message.currentHand);
                        if (BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.PERSONAL_CHEST) {
                            InventoryPersonalChest inventory = new InventoryPersonalChest(player, message.currentHand);
                            MekanismUtils.openPersonalChestGui((EntityPlayerMP)player, null, inventory, false);
                        }
                    }
                }
                catch (Exception e) {
                    Mekanism.logger.error("Error while handling electric chest open packet.");
                    e.printStackTrace();
                }
            } else if (message.packetType == PersonalChestPacketType.CLIENT_OPEN) {
                try {
                    Mekanism.proxy.openPersonalChest(player, message.guiType, message.windowId, message.isBlock, message.coord4D == null ? BlockPos.field_177992_a : message.coord4D.getPos(), message.currentHand);
                }
                catch (Exception e) {
                    Mekanism.logger.error("Error while handling electric chest open packet.");
                    e.printStackTrace();
                }
            }
        }, player);
        return null;
    }

    public static class PersonalChestMessage
    implements IMessage {
        public PersonalChestPacketType packetType;
        public boolean isBlock;
        public int guiType;
        public int windowId;
        public Coord4D coord4D;
        public EnumHand currentHand;

        public PersonalChestMessage() {
        }

        public PersonalChestMessage(PersonalChestPacketType type, boolean b1, int i1, int i2, Coord4D c1, EnumHand hand) {
            this.packetType = type;
            switch (this.packetType) {
                case CLIENT_OPEN: {
                    this.guiType = i1;
                    this.windowId = i2;
                    this.isBlock = b1;
                    if (this.isBlock) {
                        this.coord4D = c1;
                        break;
                    }
                    this.currentHand = hand;
                    break;
                }
                case SERVER_OPEN: {
                    this.isBlock = b1;
                    if (this.isBlock) {
                        this.coord4D = c1;
                        break;
                    }
                    this.currentHand = hand;
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            switch (this.packetType) {
                case CLIENT_OPEN: {
                    dataStream.writeInt(this.guiType);
                    dataStream.writeInt(this.windowId);
                    dataStream.writeBoolean(this.isBlock);
                    if (this.isBlock) {
                        this.coord4D.write(dataStream);
                        break;
                    }
                    dataStream.writeInt(this.currentHand.ordinal());
                    break;
                }
                case SERVER_OPEN: {
                    dataStream.writeBoolean(this.isBlock);
                    if (this.isBlock) {
                        this.coord4D.write(dataStream);
                        break;
                    }
                    dataStream.writeInt(this.currentHand.ordinal());
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = PersonalChestPacketType.values()[dataStream.readInt()];
            if (this.packetType == PersonalChestPacketType.SERVER_OPEN) {
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                } else {
                    this.currentHand = EnumHand.values()[dataStream.readInt()];
                }
            } else if (this.packetType == PersonalChestPacketType.CLIENT_OPEN) {
                this.guiType = dataStream.readInt();
                this.windowId = dataStream.readInt();
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                } else {
                    this.currentHand = EnumHand.values()[dataStream.readInt()];
                }
            }
        }
    }

    public static enum PersonalChestPacketType {
        CLIENT_OPEN,
        SERVER_OPEN;

    }
}

