/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ItemStackInput
extends MachineInput<ItemStackInput> {
    public ItemStack ingredient = ItemStack.field_190927_a;
    private ItemStackInput wildVersion = null;
    private int ingredientHash;

    public ItemStackInput(ItemStack stack) {
        this.ingredient = stack;
        this.ingredientHash = this.hashIngredients();
    }

    public ItemStackInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.ingredient = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("input"));
        this.ingredientHash = this.hashIngredients();
        this.wildVersion = null;
    }

    @Override
    public ItemStackInput copy() {
        return new ItemStackInput(this.ingredient.func_77946_l());
    }

    @Override
    public boolean isValid() {
        return !this.ingredient.func_190926_b();
    }

    public ItemStackInput wildCopy() {
        if (this.wildVersion == null) {
            this.wildVersion = this.ingredient.func_77960_j() != Short.MAX_VALUE ? new ItemStackInput(new ItemStack(this.ingredient.func_77973_b(), this.ingredient.func_190916_E(), Short.MAX_VALUE)) : this;
        }
        return this.wildVersion;
    }

    public boolean useItemStackFromInventory(NonNullList<ItemStack> inventory, int index, boolean deplete) {
        if (ItemStackInput.inputContains((ItemStack)inventory.get(index), this.ingredient)) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract((ItemStack)inventory.get(index), this.ingredient));
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.ingredient);
    }

    @Override
    public boolean testEquality(ItemStackInput other) {
        return MachineInput.inputItemMatches(this.ingredient, other.ingredient);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof ItemStackInput;
    }

    @Override
    public int hashCode() {
        return this.ingredientHash;
    }
}

