/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflectionUtils {
    public static <T> Object getPrivateValue(T obj, Class<? super T> c, String[] fields) {
        for (String field : fields) {
            try {
                Field f = c.getDeclaredField(field);
                f.setAccessible(true);
                return f.get(obj);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static <T> void setPrivateValue(T obj, Object value, Class<? super T> c, String[] fields) {
        for (String field : fields) {
            try {
                Field f = c.getDeclaredField(field);
                f.setAccessible(true);
                f.set(obj, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Method getPrivateMethod(Class<?> c, String[] methods, Class<?> ... params) {
        for (String method : methods) {
            try {
                Method m = c.getDeclaredMethod(method, params);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

