/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.util;

import asmodeuscore.core.astronomy.SpaceData;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class GSUtils {
    public static List<String> changelog = new ArrayList<String>();
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;
    public static String path;

    public static ItemStack[] getItemsForModules(String module) {
        switch (module) {
            case "sensor": {
                return new ItemStack[]{new ItemStack(GCItems.sensorGlasses, 1, 0)};
            }
            case "nightvision": {
                ItemStack potion = new ItemStack((Item)Items.field_151068_bn);
                PotionUtils.func_185188_a((ItemStack)potion, (PotionType)PotionType.func_185168_a((String)"long_night_vision"));
                return new ItemStack[]{potion};
            }
            case "jetpack": {
                return new ItemStack[]{new ItemStack(GSItems.JETPACK, 1, GSItems.JETPACK.func_77612_l())};
            }
            case "speed": {
                return new ItemStack[]{new ItemStack(GCItems.rocketEngine, 2, 1)};
            }
            case "gravity": {
                return new ItemStack[]{new ItemStack(GSItems.COMPRESSED_PLATES, 2, 1)};
            }
            case "stepassist": {
                return new ItemStack[]{new ItemStack(Items.field_151123_aH, 4, 0)};
            }
            case "jump": {
                return new ItemStack[]{new ItemStack(Item.func_150898_a((Block)Blocks.field_150331_J), 2, 0)};
            }
            case "energy": {
                return new ItemStack[]{new ItemStack(GSItems.ADVANCED_BATTERY, 1, GSItems.ADVANCED_BATTERY.func_77612_l())};
            }
            case "sublight_engine": {
                return new ItemStack[]{new ItemStack(GSItems.ROCKET_MODULES, 1, 6)};
            }
        }
        return null;
    }

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return GSUtils.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b(spriteLocation.func_110624_b() + ":blocks/" + spriteLocation.func_110623_a() + addpath);
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getItemTexture(Item item, String addpath) {
        if (item == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = item.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b(spriteLocation.func_110624_b() + ":items/" + spriteLocation.func_110623_a() + addpath);
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, int side) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GSUtils.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, GSUtils.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean testFuel(String name) {
        if (name.contains("helium")) {
            return true;
        }
        return name.contains("fuel");
    }

    public static int fillWithGCFuel(FluidTank tank, FluidStack liquid, boolean doFill, EntityTieredRocket rocket) {
        if (liquid != null && GSUtils.testFuel(FluidRegistry.getFluidName((FluidStack)liquid))) {
            FluidStack liquidInTank = tank.getFluid();
            if (liquid.isFluidEqual(new FluidStack(rocket.getRocketTier() > 10 ? GSFluids.HeliumHydrogen : GCFluids.fluidFuel, 1))) {
                if (liquidInTank == null) {
                    return tank.fill(new FluidStack(liquid.getFluid(), liquid.amount), doFill);
                }
                if (liquidInTank.amount < tank.getCapacity()) {
                    return tank.fill(new FluidStack(liquidInTank, liquid.amount), doFill);
                }
            }
        }
        return 0;
    }

    public static int getColor(int r, int g, int b, int a) {
        int color = a >> 24 | r >> 16 | g >> 8 | b;
        return color - 0x1000000;
    }

    public static Vector3 getDimColor(Vector3 daycolor, Vector3 nightcolor, float starbrightness) {
        float night = starbrightness;
        float day = 1.0f - starbrightness;
        float dayColR = daycolor.floatX() / 255.0f;
        float dayColG = daycolor.floatY() / 255.0f;
        float dayColB = daycolor.floatZ() / 255.0f;
        float nightColR = nightcolor.floatX() / 255.0f;
        float nightColG = nightcolor.floatY() / 255.0f;
        float nightColB = nightcolor.floatZ() / 255.0f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static void checkFluidTankTransfer(NonNullList<ItemStack> stacks, int slot, FluidTank tank) {
        FluidStack liquid;
        if (FluidUtil.isValidContainer((ItemStack)((ItemStack)stacks.get(slot))) && (liquid = tank.getFluid()) != null) {
            if (liquid.getFluid() == GSFluids.LiquidEthaneMethane) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.EM_CANISTER);
            } else if (liquid.getFluid().getName().contains("methane")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)AsteroidsItems.methaneCanister);
            } else if (liquid.getFluid() == GSFluids.Helium3) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.HELIUM_CANISTER);
            } else if (liquid.getFluid() == GSFluids.HeliumHydrogen) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.HELIUM_HYDROGEN_CANISTER);
            } else if (liquid.getFluid().getName().contains("hydrogen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.HYDROGEN_CANISTER);
            } else if (liquid.getFluid().getName().contains("ethane")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GSItems.ETHANE_CANISTER);
            } else if (liquid.getFluid().getName().contains("liquidoxygen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)AsteroidsItems.canisterLOX);
            } else if (liquid.getFluid().getName().contains("oil")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GCItems.oilCanister);
            } else if (liquid.getFluid().getName().contains("fuel")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)GCItems.fuelCanister);
            } else if (liquid.getFluid().getName().contains("nirtogen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)AsteroidsItems.canisterLN2);
            } else if (liquid.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1)) && ((ItemStack)stacks.get(slot)).func_77973_b() instanceof ItemBucket) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)Items.field_151133_ar);
            } else if (!liquid.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1)) || ((ItemStack)stacks.get(slot)).func_77973_b() instanceof ItemBucket) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, stacks, (int)slot, (Item)Items.field_151133_ar);
            }
        }
    }

    public static void start() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)mc, (int)mc.field_71443_c, (int)mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        try {
            String str;
            URL url = new URL("https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/1.12.2/1.12.2/changelog.txt");
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.addRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            int i = 0;
            while ((str = in.readLine()) != null) {
                String str2;
                if (mc.func_135016_M().func_135041_c().func_135034_a().startsWith("ru_")) {
                    ++i;
                    str2 = new String(str.getBytes(), "UTF-8");
                    if (!str2.startsWith("r.")) continue;
                    str2 = str2.replace("r.", "");
                    changelog.add(str2);
                    if (str2.length() <= 70) continue;
                    changelog.add("");
                    continue;
                }
                ++i;
                str2 = new String(str.getBytes(), "UTF-8");
                if (!str2.startsWith("e.")) continue;
                str2 = str.replace("e.", "");
                changelog.add(str2);
                if (str2.length() <= 70) continue;
                changelog.add("");
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addBlockJsonFiles(Block block, String addPath) {
        try {
            File blockStates = new File(path + "/blockstates/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            File modelBlock = new File(path + "/models/block/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            File modelItemBlock = new File(path + "/models/item/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            if (!blockStates.exists()) {
                if (blockStates.createNewFile()) {
                    GSUtils.blockstateJson(block, blockStates);
                } else if (blockStates.exists()) {
                    GSUtils.blockstateJson(block, blockStates);
                }
            }
            if (!modelBlock.exists()) {
                if (modelBlock.createNewFile()) {
                    GSUtils.modelBlockJson(block, modelBlock, addPath);
                } else if (modelBlock.exists()) {
                    GSUtils.modelBlockJson(block, modelBlock, addPath);
                }
            }
            if (!modelItemBlock.exists()) {
                if (modelItemBlock.createNewFile()) {
                    GSUtils.modelItemBlockJson(block, modelItemBlock, addPath);
                } else if (modelItemBlock.exists()) {
                    GSUtils.modelItemBlockJson(block, modelItemBlock, addPath);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void blockstateJson(Block block, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{\n \"variants\": {\n \"normal\": { \"model\" : \"galaxyspace:" + block.func_149739_a().toLowerCase().substring(5) + "\"}}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelBlockJson(Block block, File file, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \"parent\": \"block/cube_all\",  \"textures\": { \"all\" : \"galaxyspace:blocks/" + addPath + block.func_149739_a().toLowerCase().substring(5) + "\"}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelItemBlockJson(Block block, File file, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{\n\t\"parent\": \"galaxyspace:block/" + block.func_149739_a().toLowerCase().substring(5) + "\" \n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void addItemJsonFiles(Item item) {
        GSUtils.addItemJsonFiles(item, "", item.func_77658_a().toLowerCase().substring(5));
    }

    public static void addItemJsonFiles(Item item, String folder) {
        GSUtils.addItemJsonFiles(item, folder, item.func_77658_a().toLowerCase().substring(5));
    }

    public static void addItemJsonFiles(Item item, String folder, String name) {
        try {
            File modelItemFile;
            File pathFolder = new File(path + "/models/item/" + folder);
            if (!pathFolder.exists()) {
                pathFolder.mkdirs();
            }
            if (!(modelItemFile = new File(pathFolder, name + ".json")).exists()) {
                if (modelItemFile.createNewFile()) {
                    GSUtils.modelItemJson(item, modelItemFile, folder);
                } else if (modelItemFile.exists()) {
                    GSUtils.modelItemJson(item, modelItemFile, folder);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelItemJson(Item item, File file, String folder) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \"parent\": \"item/generated\",  \"textures\": { \"layer0\" : \"galaxyspace:items/" + folder + item.func_77658_a().toLowerCase().substring(5) + "\"}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void addBlockMetadataJsonFiles(Block block, String[] variants, String property, String addPath) {
        try {
            File blockstateItemBlockMeta = new File(path + "/blockstates/", block.func_149739_a().toLowerCase().substring(5) + ".json");
            for (int i = 0; i < variants.length; ++i) {
                File modelBlockMeta = new File(path + "/models/block/" + addPath, variants[i] + ".json");
                File modelItemBlockMeta = new File(path + "/models/item/" + addPath, variants[i] + ".json");
                if (!modelBlockMeta.exists()) {
                    if (modelBlockMeta.createNewFile()) {
                        GSUtils.modelBlockMetaJson(block, variants, modelBlockMeta, i, addPath);
                    } else if (modelBlockMeta.exists()) {
                        GSUtils.modelBlockMetaJson(block, variants, modelBlockMeta, i, addPath);
                    }
                }
                if (modelItemBlockMeta.exists()) continue;
                if (modelItemBlockMeta.createNewFile()) {
                    GSUtils.modelItemBlockMetaJson(block, variants, modelItemBlockMeta, i, addPath);
                    continue;
                }
                if (!modelItemBlockMeta.exists()) continue;
                GSUtils.modelItemBlockMetaJson(block, variants, modelItemBlockMeta, i, addPath);
            }
            if (!blockstateItemBlockMeta.exists()) {
                if (blockstateItemBlockMeta.createNewFile()) {
                    GSUtils.blockstateItemBlockMetaJson(block, blockstateItemBlockMeta, variants, property);
                } else if (blockstateItemBlockMeta.exists()) {
                    GSUtils.blockstateItemBlockMetaJson(block, blockstateItemBlockMeta, variants, property);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void blockstateItemBlockMetaJson(Block block, File file, String[] variants, String property) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \n\t\"variants\": { \n");
            for (int i = 0; i < variants.length; ++i) {
                String string = "\"" + property + "=" + variants[i] + "\": { \"model\": \"" + "galaxyspace" + ":" + variants[i] + "\"}";
                if (variants[i] != variants[0]) {
                    writer.write(", \n\t\t" + string);
                    continue;
                }
                writer.write("\t\t" + string);
            }
            writer.write("\n\t} \n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelBlockMetaJson(Block block, String[] variants, File file, int i, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \n\t\"parent\": \"block/cube_all\", \n \t\"textures\": { \"all\" : \"galaxyspace:blocks/" + addPath + variants[i] + "\"}\n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelItemBlockMetaJson(Block block, String[] variants, File file, int i, String addPath) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{\n\t\"parent\": \"galaxyspace:block/" + variants[i] + "\" \n}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static void addItemMetadataJsonFiles(Item item, String[] variants, String folder) {
        try {
            for (int i = 0; i < variants.length; ++i) {
                File modelVariantsItemMeta;
                File folders = new File(path + "/models/item/" + folder);
                if (!folders.exists()) {
                    folders.mkdirs();
                }
                if ((modelVariantsItemMeta = new File(path + "/models/item/" + folder, variants[i] + ".json")).exists()) continue;
                if (modelVariantsItemMeta.createNewFile()) {
                    GSUtils.modelVariantsItemMetaJson(item, variants, modelVariantsItemMeta, i, folder);
                    continue;
                }
                if (!modelVariantsItemMeta.exists()) continue;
                GSUtils.modelVariantsItemMetaJson(item, variants, modelVariantsItemMeta, i, folder);
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void modelVariantsItemMetaJson(Item item, String[] variants, File file, int i, String folder) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("{ \"parent\": \"item/generated\",  \"textures\": { \"layer0\" : \"galaxyspace:items/" + folder + variants[i] + "\"}}");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    static {
        texMap = null;
        path = "K://MCP/codding/1.12.2/src/main/resources/assets/galaxyspace/";
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }

    public static enum SpaceSuit_Modules {
        SENSOR("sensor", Module_Type.SPACESUIT, EntityEquipmentSlot.HEAD, true, new String[]{"nightvision"}),
        NIGHTVISION("nightvision", Module_Type.SPACESUIT, EntityEquipmentSlot.HEAD, true, new String[]{"sensor"}),
        JETPACK("jetpack", Module_Type.SPACESUIT, EntityEquipmentSlot.CHEST, true, new String[]{""}),
        SPEED("speed", Module_Type.SPACESUIT, EntityEquipmentSlot.LEGS, true, new String[]{""}),
        GRAVITY("gravity", Module_Type.SPACESUIT, EntityEquipmentSlot.FEET, true, new String[]{"jump"}),
        STEPASSIST("stepassist", Module_Type.SPACESUIT, EntityEquipmentSlot.FEET, false, new String[]{""}),
        JUMP("jump", Module_Type.SPACESUIT, EntityEquipmentSlot.FEET, true, new String[]{"gravity"}),
        ENERGY("energy", Module_Type.SPACESUIT, null, false, new String[]{""}),
        SUBLIGHT_ENGINE(SpaceData.Engine_Type.SUBLIGHT_ENGINE.getName(), Module_Type.ROCKET, null, false, new String[]{""});

        private final String name;
        private final Module_Type type;
        private final EntityEquipmentSlot slot;
        private final String[] forb_modules;
        private final boolean isActive;

        private SpaceSuit_Modules(String name, Module_Type type, EntityEquipmentSlot slot, boolean isActive, String[] forb_modules) {
            this.name = name;
            this.type = type;
            this.slot = slot;
            this.isActive = isActive;
            this.forb_modules = forb_modules;
        }

        public String getName() {
            return this.name;
        }

        public Module_Type getType() {
            return this.type;
        }

        public EntityEquipmentSlot getSlot() {
            return this.slot;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public String[] getForbiddenModules() {
            return this.forb_modules;
        }
    }

    public static enum Module_Type {
        SPACESUIT,
        ROCKET,
        OXYGEN_TANK;

    }
}

