/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem;

import asmodeuscore.core.astronomy.BodiesHelper;
import asmodeuscore.core.astronomy.dimension.world.OreGenerator;
import asmodeuscore.core.astronomy.dimension.world.gen.ACBiome;
import galaxyspace.GalaxySpace;
import galaxyspace.api.IBodies;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.SolarSystem.moons.callisto.dimension.TeleportTypeCallisto;
import galaxyspace.systems.SolarSystem.moons.callisto.dimension.WorldProviderCallisto;
import galaxyspace.systems.SolarSystem.moons.enceladus.dimension.TeleportTypeEnceladus;
import galaxyspace.systems.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus;
import galaxyspace.systems.SolarSystem.moons.europa.dimension.TeleportTypeEuropa;
import galaxyspace.systems.SolarSystem.moons.europa.dimension.WorldProviderEuropa;
import galaxyspace.systems.SolarSystem.moons.europa.recipes.CraftingRecipesEuropa;
import galaxyspace.systems.SolarSystem.moons.ganymede.dimension.TeleportTypeGanymede;
import galaxyspace.systems.SolarSystem.moons.ganymede.dimension.WorldProviderGanymede;
import galaxyspace.systems.SolarSystem.moons.ganymede.recipes.CraftingRecipesGanymede;
import galaxyspace.systems.SolarSystem.moons.io.dimension.TeleportTypeIo;
import galaxyspace.systems.SolarSystem.moons.io.dimension.WorldProviderIo;
import galaxyspace.systems.SolarSystem.moons.io.recipes.CraftingRecipesIo;
import galaxyspace.systems.SolarSystem.moons.miranda.dimension.TeleportTypeMiranda;
import galaxyspace.systems.SolarSystem.moons.miranda.dimension.WorldProviderMiranda;
import galaxyspace.systems.SolarSystem.moons.miranda.recipes.CraftingRecipesMiranda;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.TeleportTypeTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.systems.SolarSystem.planets.ceres.dimension.TeleportTypeCeres;
import galaxyspace.systems.SolarSystem.planets.ceres.dimension.WorldProviderCeres;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.TeleportTypeKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.mars.recipes.CraftingRecipesMars;
import galaxyspace.systems.SolarSystem.planets.mercury.dimension.TeleportTypeMercury;
import galaxyspace.systems.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.systems.SolarSystem.planets.mercury.recipes.CraftingRecipesMercury;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemSchematics;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.CraftingRecipesOverworld;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicBodyRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicBoosterRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicConeRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicEngineRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicFinsRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicOxTankRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicTier2Recipe;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicBody;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicBooster;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicCone;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicEngine;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicFins;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicOxTank;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicTier2Rocket;
import galaxyspace.systems.SolarSystem.planets.pluto.dimension.TeleportTypePluto;
import galaxyspace.systems.SolarSystem.planets.pluto.dimension.WorldProviderPluto;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.gen.OreGenOtherMods;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@IBodiesHandler
public class SolarSystemBodies
implements IBodies {
    public static Planet planetMercury;
    public static Planet planetMars;
    public static Planet planetCeres;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Planet planetPluto;
    public static Planet planetKuiperBelt;
    public static Planet planetHaumea;
    public static Planet planetMakemake;
    public static Planet planetEris;
    public static Planet planetDeeDee;
    public static Moon phobosMars;
    public static Moon deimosMars;
    public static Moon ioJupiter;
    public static Moon europaJupiter;
    public static Moon ganymedeJupiter;
    public static Moon callistoJupiter;
    public static Moon mimasSaturn;
    public static Moon enceladusSaturn;
    public static Moon tethysSaturn;
    public static Moon dioneSaturn;
    public static Moon rheyaSaturn;
    public static Moon titanSaturn;
    public static Moon iapetusSaturn;
    public static Moon mirandaUranus;
    public static Moon arielUranus;
    public static Moon umbrielUranus;
    public static Moon titaniaUranus;
    public static Moon oberonUranus;
    public static Moon proteusNeptune;
    public static Moon tritonNeptune;
    public static Moon charonPluto;
    public static Satellite marsSpaceStation;
    public static Satellite venusSpaceStation;
    private static boolean wg;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        SolarSystem sol = GalacticraftCore.solarSystemSol;
        wg = GSConfigCore.enableWorldEngine;
        planetMercury = BodiesHelper.registerPlanet((SolarSystem)sol, (String)"mercury", (String)"galaxyspace", WorldProviderMercury.class, (int)GSConfigDimensions.dimensionIDMercury, (int)3, (float)1.45f, (float)0.5f, (float)0.5f, (float)0.24096386f, (Biome[])new Biome[]{ACBiome.ACSpace});
        planetCeres = (Planet)BodiesHelper.registerPlanet((SolarSystem)sol, (String)"ceres", (String)"galaxyspace", WorldProviderCeres.class, (int)GSConfigDimensions.dimensionIDCeres, (int)3, (float)2.0f, (float)0.5f, (float)1.7f, (float)15.0f, (Biome[])new Biome[]{ACBiome.ACSpace}).setRingColorRGB(0.0f, 0.0f, 0.0f);
        planetJupiter = BodiesHelper.registerPlanet((SolarSystem)sol, (String)"jupiter", (String)"galaxyspace", null, (int)-1, (int)-1, (float)((float)Math.PI), (float)1.0f, (float)2.0f, (float)11.861994f, (Biome[])new Biome[0]);
        planetSaturn = BodiesHelper.registerPlanet((SolarSystem)sol, (String)"saturn", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.5707964f, (float)1.0f, (float)2.25f, (float)29.463308f, (Biome[])new Biome[0]);
        planetUranus = BodiesHelper.registerPlanet((SolarSystem)sol, (String)"uranus", (String)"galaxyspace", null, (int)-1, (int)-1, (float)((float)Math.PI), (float)1.0f, (float)2.5f, (float)84.06353f, (Biome[])new Biome[0]);
        planetNeptune = BodiesHelper.registerPlanet((SolarSystem)sol, (String)"neptune", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.0f, (float)1.0f, (float)2.75f, (float)164.84119f, (Biome[])new Biome[0]);
        planetPluto = (Planet)BodiesHelper.registerPlanet((SolarSystem)sol, (String)"pluto", (String)"galaxyspace", WorldProviderPluto.class, (int)GSConfigDimensions.dimensionIDPluto, (int)6, (float)0.1f, (float)0.5f, (float)3.0f, (float)250.0f, (Biome[])new Biome[]{ACBiome.ACSpace, ACBiome.ACSpaceLowPlains, ACBiome.ACSpaceLowHills, ACBiome.ACSpaceMidPlains}).atmosphereComponent(EnumAtmosphericGas.NITROGEN);
        planetKuiperBelt = (Planet)BodiesHelper.registerPlanet((SolarSystem)sol, (String)"kuiperbelt", (String)"galaxyspace", WorldProviderKuiperBelt.class, (int)GSConfigDimensions.dimensionIDKuiperBelt, (int)6, (float)1.5f, (float)0.5f, (float)3.25f, (float)300.0f, (Biome[])new Biome[]{ACBiome.ACSpace}).setRingColorRGB(1.0f, 0.0f, 0.0f);
        phobosMars = BodiesHelper.registerMoon((Planet)(GSConfigCore.enableGCMars ? MarsModule.planetMars : planetMars), (String)"phobos", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.0f, (float)0.0017f, (float)8.0f, (float)100.0f, (Biome[])new Biome[0]);
        deimosMars = BodiesHelper.registerMoon((Planet)(GSConfigCore.enableGCMars ? MarsModule.planetMars : planetMars), (String)"deimos", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.0f, (float)0.0017f, (float)16.0f, (float)300.0f, (Biome[])new Biome[0]);
        ioJupiter = BodiesHelper.registerMoon((Planet)planetJupiter, (String)"io", (String)"galaxyspace", WorldProviderIo.class, (int)GSConfigDimensions.dimensionIDIo, (int)4, (float)1.0f, (float)0.0017f, (float)10.0f, (float)50.0f, (Biome[])new Biome[]{ACBiome.ACSpace, ACBiome.ACSpaceLowHills, ACBiome.ACSpaceLowPlains});
        europaJupiter = BodiesHelper.registerMoon((Planet)planetJupiter, (String)"europa", (String)"galaxyspace", WorldProviderEuropa.class, (int)GSConfigDimensions.dimensionIDEuropa, (int)4, (float)1.0f, (float)0.0017f, (float)15.0f, (float)100.0f, (Biome[])new Biome[0]);
        ganymedeJupiter = BodiesHelper.registerMoon((Planet)planetJupiter, (String)"ganymede", (String)"galaxyspace", WorldProviderGanymede.class, (int)GSConfigDimensions.dimensionIDGanymede, (int)4, (float)1.0f, (float)0.0017f, (float)20.0f, (float)150.0f, (Biome[])new Biome[0]);
        callistoJupiter = BodiesHelper.registerMoon((Planet)planetJupiter, (String)"callisto", (String)"galaxyspace", WorldProviderCallisto.class, (int)GSConfigDimensions.dimensionIDCallisto, (int)4, (float)1.0f, (float)0.0017f, (float)30.0f, (float)200.0f, (Biome[])new Biome[0]);
        mimasSaturn = BodiesHelper.registerMoon((Planet)planetSaturn, (String)"mimas", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.5707964f, (float)0.0017f, (float)10.0f, (float)20.0f, (Biome[])new Biome[0]);
        enceladusSaturn = BodiesHelper.registerMoon((Planet)planetSaturn, (String)"enceladus", (String)"galaxyspace", WorldProviderEnceladus.class, (int)GSConfigDimensions.dimensionIDEnceladus, (int)5, (float)1.0471976f, (float)0.0017f, (float)15.0f, (float)50.0f, (Biome[])new Biome[0]);
        tethysSaturn = BodiesHelper.registerMoon((Planet)planetSaturn, (String)"tethys", (String)"galaxyspace", null, (int)-1, (int)-1, (float)((float)Math.PI), (float)0.0017f, (float)20.0f, (float)120.0f, (Biome[])new Biome[0]);
        dioneSaturn = BodiesHelper.registerMoon((Planet)planetSaturn, (String)"dione", (String)"galaxyspace", null, (int)-1, (int)-1, (float)0.7853982f, (float)0.0017f, (float)25.0f, (float)180.0f, (Biome[])new Biome[0]);
        rheyaSaturn = BodiesHelper.registerMoon((Planet)planetSaturn, (String)"rheya", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.0471976f, (float)0.0017f, (float)30.0f, (float)220.0f, (Biome[])new Biome[0]);
        titanSaturn = (Moon)BodiesHelper.registerMoon((Planet)planetSaturn, (String)"titan", (String)"galaxyspace", WorldProviderTitan.class, (int)GSConfigDimensions.dimensionIDTitan, (int)5, (float)0.62831855f, (float)0.0017f, (float)35.0f, (float)280.0f, (Biome[])new Biome[0]).atmosphereComponent(EnumAtmosphericGas.NITROGEN).atmosphereComponent(EnumAtmosphericGas.METHANE).atmosphereComponent(EnumAtmosphericGas.HYDROGEN);
        iapetusSaturn = BodiesHelper.registerMoon((Planet)planetSaturn, (String)"iapetus", (String)"galaxyspace", null, (int)-1, (int)-1, (float)((float)Math.PI), (float)0.0017f, (float)40.0f, (float)350.0f, (Biome[])new Biome[0]);
        mirandaUranus = BodiesHelper.registerMoon((Planet)planetUranus, (String)"miranda", (String)"galaxyspace", WorldProviderMiranda.class, (int)GSConfigDimensions.dimensionIDMiranda, (int)5, (float)((float)Math.PI), (float)0.0017f, (float)10.0f, (float)20.0f, (Biome[])new Biome[]{ACBiome.ACSpace, ACBiome.ACSpaceLowPlains, ACBiome.ACSpaceMidHills});
        arielUranus = BodiesHelper.registerMoon((Planet)planetUranus, (String)"ariel", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.5707964f, (float)0.0017f, (float)15.0f, (float)50.0f, (Biome[])new Biome[0]);
        umbrielUranus = BodiesHelper.registerMoon((Planet)planetUranus, (String)"umbriel", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.0471976f, (float)0.0017f, (float)20.0f, (float)120.0f, (Biome[])new Biome[0]);
        titaniaUranus = BodiesHelper.registerMoon((Planet)planetUranus, (String)"titania", (String)"galaxyspace", null, (int)-1, (int)-1, (float)0.7853982f, (float)0.0017f, (float)25.0f, (float)180.0f, (Biome[])new Biome[0]);
        oberonUranus = BodiesHelper.registerMoon((Planet)planetUranus, (String)"oberon", (String)"galaxyspace", null, (int)-1, (int)-1, (float)0.62831855f, (float)0.0017f, (float)30.0f, (float)200.0f, (Biome[])new Biome[0]);
        proteusNeptune = BodiesHelper.registerMoon((Planet)planetNeptune, (String)"proteus", (String)"galaxyspace", null, (int)-1, (int)-1, (float)((float)Math.PI), (float)0.0017f, (float)10.0f, (float)50.0f, (Biome[])new Biome[0]);
        tritonNeptune = BodiesHelper.registerMoon((Planet)planetNeptune, (String)"triton", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.5707964f, (float)0.0017f, (float)25.0f, (float)-200.0f, (Biome[])new Biome[0]);
        charonPluto = BodiesHelper.registerMoon((Planet)planetPluto, (String)"charon", (String)"galaxyspace", null, (int)-1, (int)-1, (float)1.5707964f, (float)0.0017f, (float)15.0f, (float)50.0f, (Biome[])new Biome[0]);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        VenusModule.planetVenus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.745f, 0.74f)).setRingColorRGB(0.0f, 0.4f, 0.9f);
        GalacticraftCore.satelliteSpaceStation.setRingColorRGB(0.0f, 0.4f, 0.9f);
        GalacticraftCore.moonMoon.setRingColorRGB(0.0f, 0.4f, 0.9f);
        MarsModule.planetMars.setRingColorRGB(0.0f, 0.4f, 0.9f);
        AsteroidsModule.planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        titanSaturn.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), true, true, -4.0f, 0.8f, 0.0f));
        if (GSConfigCore.enableOverworldOres) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.OVERWORLD_ORES.func_176203_a(0), 12, 0, 60, 5, Blocks.field_150348_b.func_176223_P(), 0), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.OVERWORLD_ORES.func_176203_a(1), 6, 0, 45, 4, Blocks.field_150348_b.func_176223_P(), 0), (int)1);
        }
        OreGenOtherMods.addOre((Block)GSBlocks.MARS_ORES, (int)0, (int)1, (int)1, (int)0, (boolean)false, (int)ConfigManagerMars.dimensionIDMars);
        OreGenOtherMods.data.forEach(s -> GalaxySpace.debug(s.oreBlock + " | " + s.dimRestrict));
        SolarSystemBodies.registrycelestial();
        SolarSystemBodies.registryteleport();
        SolarSystemBodies.registerDungeonLoot();
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicCone());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicBody());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicEngine());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicBooster());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicFins());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicOxTank());
        for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
            if (!(page instanceof micdoodle8.mods.galacticraft.planets.mars.schematic.SchematicTier2Rocket)) continue;
            SchematicRegistry.schematicRecipes.remove(page);
            break;
        }
        for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
            if (!(page instanceof SchematicTier3Rocket)) continue;
            SchematicRegistry.schematicRecipes.remove(page);
            break;
        }
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier2Rocket());
        GCItems.hiddenItems.add(new ItemStack(MarsItems.schematic, 1, 0).func_77973_b());
        GalacticraftRegistry.registerGear((int)40, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_4);
        GalacticraftRegistry.registerGear((int)40, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_4);
        GalacticraftRegistry.registerGear((int)41, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_5);
        GalacticraftRegistry.registerGear((int)41, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_5);
        GalacticraftRegistry.registerGear((int)42, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_6);
        GalacticraftRegistry.registerGear((int)42, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_6);
        GalacticraftRegistry.registerGear((int)43, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_EPP);
        GalacticraftRegistry.registerGear((int)43, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_EPP);
        GalacticraftRegistry.registerGear((int)101, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER, (ItemStack)new ItemStack(GSItems.BASIC, 1, 16));
    }

    private static void registerDungeonLoot() {
        GalacticraftRegistry.addDungeonLoot((int)1, (ItemStack)new ItemStack(GSItems.BASIC, 1, 10));
        GalacticraftRegistry.addDungeonLoot((int)1, (ItemStack)new ItemStack(GSItems.SCHEMATICS, 1, 5));
        GalacticraftRegistry.getDungeonLoot((int)2).clear();
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(GSItems.SCHEMATICS, 1, 5));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 1));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(GSItems.BASIC, 1, 10));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.BASIC, 1, 16));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.BASIC, 1, 18));
        GalacticraftRegistry.addDungeonLoot((int)3, (ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 6));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 6));
    }

    private static void registrycelestial() {
        ItemStack[] suit = new ItemStack[]{new ItemStack(GSItems.SPACE_SUIT_HELMET, 1, 1), new ItemStack(GSItems.SPACE_SUIT_BODY, 1, 1), new ItemStack(GSItems.SPACE_SUIT_LEGGINS, 1, 1), new ItemStack(GSItems.SPACE_SUIT_BOOTS, 1, 1)};
        BodiesHelper.BodiesData data = new BodiesHelper.BodiesData(BodiesHelper.yellow + " " + BodiesHelper.dwarf, 28.088f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)GalacticraftCore.solarSystemSol.getMainStar(), (BodiesHelper.BodiesData)data);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)3.8f), 0, 6.0f, 0.0f, 176000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)planetMercury, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableMercury);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)8.88f), 92, 12.0f, 1.2f, 182000L, false, false).addItemStackList(suit);
        data.addItemStack(new ItemStack(GSItems.BASIC, 1, 16));
        BodiesHelper.registerBody((CelestialBody)VenusModule.planetVenus, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableVenus);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)10.0f), 1, 1.0f, 1.0f, 24000L, true, false);
        BodiesHelper.registerBody((CelestialBody)GalacticraftCore.planetOverworld, (BodiesHelper.BodiesData)data, (boolean)false);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)2.37f), 0, -1.5f, 0.0f, 10000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)planetCeres, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableCeres);
        data = new BodiesHelper.BodiesData(null, 0.0f, 0, -2.0f, 0.0f, 0L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)AsteroidsModule.planetAsteroids, (BodiesHelper.BodiesData)data, (boolean)false);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)8.375f), 100, -5.0f, 10.0f, 9000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetJupiter, (BodiesHelper.BodiesData)data, (boolean)true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)7.37f), 100, -5.0f, 10.0f, 11000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetSaturn, (BodiesHelper.BodiesData)data, (boolean)true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)8.61f), 100, -5.0f, 10.0f, 16000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetUranus, (BodiesHelper.BodiesData)data, (boolean)true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)8.547f), 100, -8.0f, 10.0f, 18000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetNeptune, (BodiesHelper.BodiesData)data, (boolean)true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)2.62f), 0, -5.0f, 0.0f, 98000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)planetPluto, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enablePluto);
        data = new BodiesHelper.BodiesData(null, 0.0f, 0, -6.0f, 0.0f, 0L, false, true).addItemStackList(suit);
        data.addItemStack(new ItemStack(AsteroidsItems.grapple, 1, 0));
        data.addItemStack(new ItemStack(Items.field_151007_F, 16, 0));
        BodiesHelper.registerBody((CelestialBody)planetKuiperBelt, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableKuiperBelt);
        data = new BodiesHelper.BodiesData(null, 0.062f, 0, 0.0f, 0.0f, 192000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)GalacticraftCore.moonMoon, (BodiesHelper.BodiesData)data, (boolean)false);
        data = new BodiesHelper.BodiesData(null, 0.068f, 0, -1.0f, 0.0f, 12000L, false, false);
        BodiesHelper.registerBody((CelestialBody)phobosMars, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enablePhobos);
        data = new BodiesHelper.BodiesData(null, 0.064f, 0, -1.0f, 0.0f, 24000L, false, false);
        BodiesHelper.registerBody((CelestialBody)deimosMars, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableDeimos);
        data = new BodiesHelper.BodiesData(null, 0.052f, 0, -2.0f, 0.0f, 42000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)ioJupiter, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableIo);
        data = new BodiesHelper.BodiesData(null, 0.062f, 0, -3.0f, 0.0f, 58000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)europaJupiter, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableEuropa);
        data = new BodiesHelper.BodiesData(null, 0.057f, 0, -2.0f, 0.0f, 102000L, false, false);
        BodiesHelper.registerBody((CelestialBody)ganymedeJupiter, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableGanymede);
        data = new BodiesHelper.BodiesData(null, 0.054f, 0, -3.0f, 0.0f, 154000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)callistoJupiter, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableCallisto);
        data = new BodiesHelper.BodiesData(null, 0.058f, 0, -3.0f, 0.0f, 32000L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)enceladusSaturn, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableEnceladus);
        data = new BodiesHelper.BodiesData(null, 0.058f, 5, -3.0f, 0.0f, 105500L, false, false);
        BodiesHelper.registerBody((CelestialBody)titanSaturn, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableTitan);
        data = new BodiesHelper.BodiesData(null, 0.057f, 0, -4.0f, 0.0f, 33500L, false, true).addItemStackList(suit);
        BodiesHelper.registerBody((CelestialBody)mirandaUranus, (BodiesHelper.BodiesData)data, (boolean)GSConfigDimensions.enableMiranda);
        BodiesHelper.BodiesData unreachableData = new BodiesHelper.BodiesData(null, 0.0f, 0, 0.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBody((CelestialBody)oberonUranus, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)proteusNeptune, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)tritonNeptune, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)mimasSaturn, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)tethysSaturn, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)dioneSaturn, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)rheyaSaturn, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)iapetusSaturn, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)arielUranus, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)umbrielUranus, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)titaniaUranus, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)charonPluto, (BodiesHelper.BodiesData)unreachableData, (boolean)GSConfigCore.enableUnreachable);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new TeleportTypeMercury());
        GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeCeres());
        GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new TeleportTypePluto());
        GalacticraftRegistry.registerTeleportType(WorldProviderKuiperBelt.class, (ITeleportType)new TeleportTypeKuiperBelt());
        GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new TeleportTypeIo());
        GalacticraftRegistry.registerTeleportType(WorldProviderEuropa.class, (ITeleportType)new TeleportTypeEuropa());
        GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new TeleportTypeGanymede());
        GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new TeleportTypeCallisto());
        GalacticraftRegistry.registerTeleportType(WorldProviderEnceladus.class, (ITeleportType)new TeleportTypeEnceladus());
        GalacticraftRegistry.registerTeleportType(WorldProviderTitan.class, (ITeleportType)new TeleportTypeTitan());
        GalacticraftRegistry.registerTeleportType(WorldProviderMiranda.class, (ITeleportType)new TeleportTypeMiranda());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ItemSchematics.registerSchematicItems();
        GSDimensions.MERCURY = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDMercury);
        GSDimensions.CERES = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDCeres);
        GSDimensions.PLUTO = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDPluto);
        GSDimensions.IO = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDIo);
        GSDimensions.EUROPA = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDEuropa);
        GSDimensions.GANYMEDE = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDGanymede);
        GSDimensions.CALLISTO = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDCallisto);
        GSDimensions.ENCELADUS = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDEnceladus);
        GSDimensions.TITAN = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDTitan);
        GSDimensions.MIRANDA = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDMiranda);
        GSDimensions.KUIPER_BELT = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDKuiperBelt);
    }

    private static void registerRecipesWorkBench() {
        SchematicConeRecipe.registerRecipeWorkBench();
        SchematicBodyRecipe.registerRecipeWorkBench();
        SchematicEngineRecipe.registerRecipeWorkBench();
        SchematicBoosterRecipe.registerRecipeWorkBench();
        SchematicFinsRecipe.registerRecipeWorkBench();
        SchematicOxTankRecipe.registerRecipeWorkBench();
        SchematicTier2Recipe.registerRecipeWorkBench();
    }

    @Override
    public void registerRender() {
    }

    @Override
    public void registerVariant() {
    }

    @Override
    public void registerRecipes() {
        CraftingRecipesMercury.loadRecipes();
        CraftingRecipesOverworld.loadRecipes();
        CraftingRecipesMars.loadRecipes();
        CraftingRecipesIo.loadRecipes();
        CraftingRecipesEuropa.loadRecipes();
        CraftingRecipesGanymede.loadRecipes();
        CraftingRecipesMiranda.loadRecipes();
        SolarSystemBodies.registerRecipesWorkBench();
    }

    @Override
    public boolean canRegister() {
        return true;
    }

    static {
        planetJupiter = GalacticraftCore.planetJupiter;
        planetSaturn = GalacticraftCore.planetSaturn;
        planetUranus = GalacticraftCore.planetUranus;
        planetNeptune = GalacticraftCore.planetNeptune;
    }
}

