/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockLiquidExtractor;
import java.util.HashMap;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityLiquidExtractor
extends TileBaseElectricBlockWithInventory
implements IFluidHandlerWrapper,
ISidedInventory,
IPacketReceiver {
    private int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank;
    private NonNullList<ItemStack> stacks;
    private static HashMap<Block, FluidStack> extractfluid = new HashMap();
    private int x;
    private int z;

    public TileEntityLiquidExtractor() {
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 50;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.waterTank = new FluidTank(this.tankCapacity);
        this.stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        this.x = -2;
        this.z = -2;
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
        this.setTierGC(1);
        extractfluid.put(Blocks.field_150432_aD, new FluidStack(FluidRegistry.WATER, 100));
    }

    public static void addBlockAndFluid(Block block, FluidStack fluidstack) {
        extractfluid.put(block, fluidstack);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            GSUtils.checkFluidTankTransfer(this.stacks, 1, this.waterTank);
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        return this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public void smeltItem() {
        if (this.canProcess()) {
            Fluid water;
            BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n() + this.x, this.func_174877_v().func_177956_o() - 1, this.func_174877_v().func_177952_p() + this.z);
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            int meta = state.func_177230_c().func_176201_c(state);
            FluidStack ext = extractfluid.get(this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c());
            if (ext != null) {
                water = ext.getFluid();
                this.waterTank.fill(new FluidStack(water, ext.amount), true);
            }
            if (meta == 0) {
                Fluid fluid;
                if (block == Blocks.field_150355_j) {
                    water = FluidRegistry.WATER;
                    this.waterTank.fill(new FluidStack(water, 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
                if (block == Blocks.field_150353_l) {
                    this.waterTank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
                if (block instanceof BlockFluidClassic) {
                    fluid = ((BlockFluidClassic)block).getFluid();
                    this.waterTank.fill(new FluidStack(fluid, 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
                if (block instanceof IFluidBlock) {
                    fluid = (IFluidBlock)block;
                    this.waterTank.fill(new FluidStack(fluid.getFluid(), 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
                if (this.x < 2) {
                    ++this.x;
                } else {
                    this.x = -2;
                    ++this.z;
                }
                if (this.z > 2) {
                    this.z = -2;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(par1NBTTagCompound);
        this.x = par1NBTTagCompound.func_74762_e("posX");
        this.z = par1NBTTagCompound.func_74762_e("posZ");
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound, this.stacks);
        par1NBTTagCompound.func_74768_a("posX", this.x);
        par1NBTTagCompound.func_74768_a("posZ", this.z);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockLiquidExtractor) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockLiquidExtractor.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.liquid_extractor.name");
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getPipe() && resource != null && resource.isFluidEqual(this.waterTank.getFluid())) {
            return this.waterTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getPipe()) {
            return this.waterTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe()) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176735_f();
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getPipe();
            return direction == pipeSide;
        }
        return false;
    }

    public int getScaledTankLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }
}

