/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockModernSolarPanel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityModernSolarPanel
extends TileBaseUniversalElectricalSource
implements IMultiBlock,
IDisableableMachine,
IInventoryDefaults,
ISidedInventory,
IConnector {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int solarStrength = 0;
    public double angle;
    public float targetAngle;
    public float currentAngle;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public static final int MAX_GENERATE_WATTS = 450;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int generateWatts = 0;
    private boolean initialised = false;
    private boolean initialisedMulti = false;
    private AxisAlignedBB renderAABB;

    public TileEntityModernSolarPanel() {
        this.storage.setMaxExtract(450.0f);
        this.storage.setMaxReceive(450.0f);
        this.storage.setCapacity(40000.0f);
        this.initialised = true;
        this.tierGC = 1;
    }

    public void func_73660_a() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            this.storage.setCapacity(40000.0f);
            this.initialised = true;
        }
        if (!this.initialisedMulti) {
            this.initialisedMulti = this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.receiveEnergyGC(null, this.generateWatts, false);
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.recharge((ItemStack)this.stacks.get(0));
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if (!this.getDisabled(0) && this.ticks % 20 == 0) {
                this.solarStrength = 0;
                if (this.field_145850_b.func_72935_r() && (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider || !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I())) {
                    double distance = 100.0;
                    double sinA = -Math.sin(((double)this.currentAngle - 77.5) * Math.PI / 180.0);
                    double cosA = Math.abs(Math.cos(((double)this.currentAngle - 77.5) * Math.PI / 180.0));
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockVec3 blockAt;
                            IBlockState state;
                            boolean valid = true;
                            BlockVec3 blockVec = new BlockVec3((TileEntity)this).translate(x, 3, z);
                            for (double d = 0.0; d < distance && (state = (blockAt = blockVec.clone().translate((int)(d * sinA), (int)(d * cosA), 0)).getBlockState(this.field_145850_b)) != null; d += 1.0) {
                                if (!state.func_177230_c().func_149662_c(state)) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            ++this.solarStrength;
                        }
                    }
                }
            }
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.7845194f < 0.0f ? 0.21548063f : -0.7845194f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        if ((celestialAngle %= 360.0f) > 30.0f && celestialAngle < 150.0f && !this.field_145850_b.func_72896_J()) {
            float difference = this.targetAngle - celestialAngle;
            this.targetAngle -= difference / 20.0f;
        } else if (!this.field_145850_b.func_72935_r() || this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I()) {
            this.targetAngle = 177.5f;
        } else if (celestialAngle < 50.0f) {
            this.targetAngle = 50.0f;
        } else if (celestialAngle > 150.0f) {
            this.targetAngle = 150.0f;
        }
        float difference = this.targetAngle - this.currentAngle;
        this.currentAngle += difference / 20.0f;
        if (!this.field_145850_b.field_72995_K) {
            this.generateWatts = (float)this.getGenerate() > 0.0f ? Math.min(Math.max(this.getGenerate(), 0), 450) : 0;
        }
        this.produce();
    }

    protected boolean initialiseMultiTiles(BlockPos pos, World world) {
        if (world.field_72995_K) {
            this.onCreate(world, pos);
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(pos, positions);
        boolean result = true;
        for (BlockPos vecToAdd : positions) {
            TileEntity tile = world.func_175625_s(vecToAdd);
            if (tile instanceof TileEntityMulti) {
                ((TileEntityMulti)tile).mainBlockPosition = pos;
                continue;
            }
            result = false;
        }
        return result;
    }

    public int getGenerate() {
        if (this.getDisabled(0)) {
            return 0;
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        float difference = (180.0f - Math.abs(this.currentAngle % 180.0f - (celestialAngle %= 360.0f))) / 180.0f;
        return MathHelper.func_76141_d((float)(0.01f * difference * difference * ((float)this.solarStrength * (Math.abs(difference) * 500.0f)) * this.getSolarBoost() * (2.0f * GSConfigEnergy.coefficientSolarPanel)));
    }

    public float getSolarBoost() {
        return (float)(this.field_145850_b.field_73011_w instanceof ISolarLevel ? ((ISolarLevel)this.field_145850_b.field_73011_w).getSolarEnergyMultiplier() : 1.0);
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    public void onCreate(World world, BlockPos placedPosition) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        if (positions.size() > 0) {
            ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, (BlockPos)positions.get(0), placedPosition, BlockMulti.EnumBlockMultiType.SOLAR_PANEL_0.getMeta());
            positions.remove(0);
        }
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, positions, placedPosition, this.getMultiType());
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        int y = placedPosition.func_177956_o() + 2;
        if (y > buildHeight) {
            return;
        }
        positions.add(new BlockPos(placedPosition.func_177958_n(), y, placedPosition.func_177952_p()));
        if (++y > buildHeight) {
            return;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            BlockMulti.EnumBlockMultiType type;
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GCBlocks.fakeBlock || (type = (BlockMulti.EnumBlockMultiType)stateAt.func_177229_b((IProperty)BlockMulti.MULTI_TYPE)) != BlockMulti.EnumBlockMultiType.SOLAR_PANEL_0 && type != BlockMulti.EnumBlockMultiType.SOLAR_PANEL_1) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, GCBlocks.solarPanel.func_176223_P());
            }
            this.field_145850_b.func_175698_g(pos);
        }
        this.field_145850_b.func_175655_b(this.func_174877_v(), true);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.currentAngle = nbt.func_74760_g("currentAngle");
        this.targetAngle = nbt.func_74760_g("targetAngle");
        this.setDisabled(0, nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        this.initialised = false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74776_a("currentAngle", this.currentAngle);
        nbt.func_74776_a("targetAngle", this.targetAngle);
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled(0));
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getFront());
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockModernSolarPanel) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockModernSolarPanel.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.renderAABB;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.modern_solarpanel.name");
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricOutputDirection();
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.SOLAR_PANEL_0;
    }
}

