/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class DoubleRotateMovement
implements IDoorMovement {
    boolean rightDirection = false;

    public DoubleRotateMovement(boolean right) {
        this.rightDirection = right;
    }

    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (tileEntity.isHingeLeft() == this.rightDirection) {
            return null;
        }
        return AABBUtils.rotate((AxisAlignedBB)IDoorMovement.getFullBoundingBox(topBlock, type), (int)(this.rightDirection ? 1 : -1));
    }

    private Animation<?> getAnimation(DoorTileEntity tileEntity, MalisisModel model) {
        boolean reversed = tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED;
        int ot = tileEntity.getDescriptor().getOpeningTime();
        float angle = 90.0f;
        float hingeX = 0.40625f;
        float hingeZ = -0.40625f;
        if (!tileEntity.isHingeLeft()) {
            hingeX = -hingeX;
            angle = -angle;
        }
        Rotation rotation = new Rotation(angle);
        rotation.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, hingeZ);
        rotation.reversed(reversed);
        rotation.forTicks(ot);
        if (tileEntity.isHingeLeft() == this.rightDirection) {
            float x = 1.8125f;
            if (this.rightDirection) {
                x *= -1.0f;
            }
            Translation translation = (Translation)((Translation)new Translation(0.0f, 0.0f, 0.0f, x, 0.0f, 0.0f).reversed(reversed)).forTicks(ot);
            return new Animation((ITransformable)model, new ParallelTransformation(new Transformation[]{translation, rotation}).forTicks(ot));
        }
        return new Animation((ITransformable)model, (Transformation)rotation);
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        Animation<?> animation = this.getAnimation(tileEntity, model);
        if (tileEntity.isHingeLeft() == this.rightDirection && tileEntity.getState() == DoorState.OPENED) {
            animation.setRender(true, false);
        }
        return new Animation[]{animation};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

