/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import com.google.common.base.MoreObjects;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.syncer.Sync;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.CarriageDoorMovement;
import net.malisis.doors.sound.BigDoorSound;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

@Syncable(value="TileEntity")
public class BigDoorTileEntity
extends DoorTileEntity {
    private IBlockState frameState;

    public BigDoorTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(CarriageDoorMovement.class));
        descriptor.setSound(DoorRegistry.getSound(BigDoorSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(20);
        this.setDescriptor(descriptor);
        this.frameState = Blocks.field_150371_ca.func_176223_P();
    }

    public IBlockState getFrameState() {
        return this.frameState;
    }

    public void setFrameState(IBlockState state) {
        if (state != null) {
            this.frameState = state;
        }
    }

    @Override
    public EnumFacing getDirection() {
        return DirectionalComponent.getDirection((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Override
    public IBlockState getBlockState() {
        return null;
    }

    @Override
    public boolean isOpened() {
        return this.state == DoorState.OPENED;
    }

    @Override
    public boolean isTopBlock(BlockPos pos) {
        return false;
    }

    @Override
    public boolean isHingeLeft() {
        return true;
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    @Override
    @Sync(value="state")
    public void setDoorState(DoorState newState) {
        boolean moving = this.moving;
        MBlockState state = null;
        if (this.func_145831_w() != null) {
            state = new MBlockState(this.field_174879_c, this.func_145838_q());
            ChunkCollision.get().updateBlocks(this.func_145831_w(), state);
        }
        super.setDoorState(newState);
        if (this.func_145831_w() != null && moving && !this.moving) {
            ChunkCollision.get().replaceBlocks(this.func_145831_w(), state);
        }
    }

    public ItemStack getDroppedItemStack() {
        ItemStack itemStack = new ItemStack(this.func_145838_q());
        NBTTagCompound nbt = new NBTTagCompound();
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)this.frameState);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return IBoundingBox.getRenderingBounds((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)this.frameState);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.frameState = (IBlockState)MoreObjects.firstNonNull((Object)MBlockState.fromNBT((NBTTagCompound)nbt), (Object)Blocks.field_150371_ca.func_176223_P());
    }
}

