/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.debugtools.DumpItemNBT;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOps;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class PacketDumpItemInfo
implements IMessage {
    private boolean verbose;

    public void fromBytes(ByteBuf buf) {
        this.verbose = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.verbose);
    }

    public PacketDumpItemInfo() {
    }

    public PacketDumpItemInfo(boolean verbose) {
        this.verbose = verbose;
    }

    public static class Handler
    implements IMessageHandler<PacketDumpItemInfo, IMessage> {
        public IMessage onMessage(PacketDumpItemInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketDumpItemInfo message, MessageContext ctx) {
            ItemStack item;
            int perm;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            MinecraftServer server = player.func_130014_f_().func_73046_m();
            UserListOps oppedPlayers = server.func_184103_al().func_152603_m();
            UserListOpsEntry entry = (UserListOpsEntry)oppedPlayers.func_152683_b((Object)player.func_146103_bH());
            int n = perm = entry == null ? server.func_110455_j() : entry.func_152644_a();
            if (perm >= 1 && !(item = player.func_184614_ca()).func_190926_b()) {
                String output = DumpItemNBT.dumpItemNBT(item, message.verbose);
                Logging.getLogger().log(Level.INFO, "### Server side ###");
                Logging.getLogger().log(Level.INFO, output);
            }
        }
    }
}

