/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public abstract class ItemHandlerFilterInsertion<T extends IItemHandlerModifiableCompat>
implements IItemHandlerModifiableCompat {
    public final T original;

    public ItemHandlerFilterInsertion(T original) {
        this.original = original;
    }

    public abstract boolean isValid(@Nonnull ItemStack var1);

    @Override
    public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
        this.original.setStackInSlot(slot, stack);
    }

    @Override
    public int getSlots() {
        return this.original.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.original.getStackInSlot(slot);
    }

    @Override
    @ItemStackNonNull
    public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
        if (StackHelper.isNull(stack) || !this.isValid(stack)) {
            return stack;
        }
        return this.original.insertItem(slot, stack, simulate);
    }

    @Override
    @ItemStackNonNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extractItem = this.original.extractItem(slot, amount, simulate);
        if (StackHelper.isNull(extractItem) || this.isValid(extractItem)) {
            return StackHelper.empty();
        }
        return extractItem;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.original.getSlotLimit(slot);
    }

    public IItemHandlerModifiableCompat getGUIVariant() {
        return new ItemHandlerFilterInsertion<T>((IItemHandlerModifiableCompat)this.original){

            @Override
            public boolean isValid(@Nonnull ItemStack stack) {
                return ItemHandlerFilterInsertion.this.isValid(stack);
            }

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return this.original.extractItem(slot, amount, simulate);
            }
        };
    }
}

