/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.recipes.SingleInputStackMatchRecipeBase;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EnergyBaseRecipe
extends SingleInputStackMatchRecipeBase {
    public EnergyBaseRecipe(MachineSlotItem inputSlot) {
        super(inputSlot);
    }

    public EnergyBaseRecipe() {
        this(XUMachineGenerators.INPUT_ITEM);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void tooltip(ItemTooltipEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (container instanceof TileMachine.ContainerMachine) {
            TileMachine machine = ((TileMachine.ContainerMachine)container).machine;
            if (machine == null || machine.machine == null) {
                return;
            }
            ItemStack itemStack = event.getItemStack();
            for (IMachineRecipe recipe : machine.machine.recipes_registry) {
                int energyOutput;
                if (!(recipe instanceof EnergyBaseRecipe) || (energyOutput = ((EnergyBaseRecipe)recipe).getEnergyOutput(itemStack)) <= 0) continue;
                float energyRate = ((EnergyBaseRecipe)recipe).getEnergyRate(itemStack);
                event.getToolTip().add(Lang.translateArgs("Generates %s RF at %s RF/Tick", StringHelper.format(energyOutput), StringHelper.format(energyRate)));
                break;
            }
        }
    }

    public static Collection<ItemStack> getCreativeStacks(@Nullable Predicate<ItemStack> predicateItemStack, @Nullable Predicate<Item> predicateItem) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Item item : Item.field_150901_e) {
            if (predicateItem != null && !predicateItem.test(item)) continue;
            for (ItemStack stack : ExtraUtils2.proxy.getSubItems(item)) {
                if (predicateItemStack != null && !predicateItemStack.test(stack)) continue;
                builder.add((Object)stack);
            }
        }
        return builder.build();
    }

    public static Collection<ItemStack> createItemList(Item ... items) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Item item : items) {
            builder.addAll(ExtraUtils2.proxy.getSubItems(item));
        }
        return builder.build();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return StackHelper.isNonNull(stack) && this.getEnergyOutput(stack) > 0;
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return ImmutableMap.of();
    }

    @Override
    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return ImmutableMap.of();
    }

    public abstract int getEnergyOutput(@Nonnull ItemStack var1);

    @Override
    public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack = inputItems.get(this.inputSlot);
        return StackHelper.isNonNull(stack) ? this.getEnergyOutput(stack) : 0;
    }

    @Override
    public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return Math.round((float)this.getEnergyOutput(inputItems, inputFluids) / this.getEnergyRate(inputItems, inputFluids));
    }

    @Override
    public float getEnergyRate(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack = inputItems.get(this.inputSlot);
        return StackHelper.isNonNull(stack) ? this.getEnergyRate(stack) : 0.0f;
    }

    protected abstract float getEnergyRate(@Nonnull ItemStack var1);

    @Override
    @Nullable
    public ItemStack getContainer(ItemStack stack) {
        return ForgeHooks.getContainerItem((ItemStack)stack);
    }

    static {
        MinecraftForge.EVENT_BUS.register(EnergyBaseRecipe.class);
    }

    public static class EnergyBaseItem
    extends EnergyBaseRecipe {
        final IMatcherMaker itemRef;
        final int energy;
        final int rate;

        public EnergyBaseItem(IMatcherMaker itemRef, int energy) {
            this.itemRef = itemRef;
            this.energy = energy;
            this.rate = energy / 400;
        }

        public EnergyBaseItem(IMatcherMaker itemRef, int energy, int rate) {
            this.itemRef = itemRef;
            this.energy = energy;
            this.rate = rate;
        }

        @Override
        @Nonnull
        public Collection<ItemStack> getInputValues() {
            return this.itemRef.getSubItems();
        }

        @Override
        public int getEnergyOutput(@Nonnull ItemStack stack) {
            return this.itemRef.matchesItemStack(stack) ? this.energy : 0;
        }

        @Override
        protected float getEnergyRate(@Nonnull ItemStack stack) {
            return this.rate;
        }
    }
}

