/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import erogenousbeef.bigreactors.common.compat.CompatManager;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockDevice;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineComputerPort;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.lib.compat.computer.Connector;
import it.zerono.mods.zerocore.lib.crafting.RecipeHelper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.registries.IForgeRegistry;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="computercraft")})
public class BlockMultiblockComputerPort
extends BlockMultiblockDevice
implements IPeripheralProvider {
    public BlockMultiblockComputerPort(PartType type, String blockName) {
        super(type, blockName);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this._type) {
            case ReactorComputerPort: {
                return new TileEntityReactorComputerPort();
            }
            case TurbineComputerPort: {
                return new TileEntityTurbineComputerPort();
            }
        }
        throw new IllegalArgumentException("Invalid part type");
    }

    public void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
        if (!CompatManager.isModLoaded("computercraft") && !CompatManager.isModLoaded("opencomputers")) {
            return;
        }
        if (PartType.ReactorComputerPort == this._type) {
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                RecipeHelper.addShapedOreDictRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"CRC", "GPG", "CRC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), "ingotGold", Character.valueOf('P'), Items.field_151107_aW});
            }
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                RecipeHelper.addShapedOreDictRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"CRC", "GPG", "CRC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), "ingotGold", Character.valueOf('P'), Items.field_151107_aW});
            }
        } else if (PartType.TurbineComputerPort == this._type) {
            if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
                RecipeHelper.addShapedOreDictRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"HRH", "GPG", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), "ingotGold", Character.valueOf('P'), Items.field_151107_aW});
            }
            if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
                RecipeHelper.addShapedOreDictRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"HRH", "GPG", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), "ingotGold", Character.valueOf('P'), Items.field_151107_aW});
            }
        }
    }

    @Optional.Method(modid="computercraft")
    public IPeripheral getPeripheral(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos);
        Connector computer = null;
        if (tileEntity instanceof TileEntityReactorComputerPort) {
            computer = ((TileEntityReactorComputerPort)tileEntity).getComputerCraftPeripheral();
        } else if (tileEntity instanceof TileEntityTurbineComputerPort) {
            computer = ((TileEntityTurbineComputerPort)tileEntity).getComputerCraftPeripheral();
        }
        return computer instanceof IPeripheral ? (IPeripheral)computer : null;
    }
}

