/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.proxy.ClientProxy;
import omtteam.omlib.tileentity.EnumMachineMode;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class MessageTurretBase
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int rfStorageCurrent;
    private int rfStorageMax;
    private int tier;
    private int camoBlockMeta;
    private int maxRange;
    private int kills;
    private int playerKills;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private boolean multiTargeting;
    private String owner;
    private String ownerName;
    private String camoBlockRegName;
    private List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    private EnumMachineMode mode;

    public MessageTurretBase() {
    }

    public MessageTurretBase(TileEntity tileEntity) {
        if (tileEntity instanceof TurretBase) {
            TurretBase base = (TurretBase)tileEntity;
            this.x = base.func_174877_v().func_177958_n();
            this.y = base.func_174877_v().func_177956_o();
            this.z = base.func_174877_v().func_177952_p();
            this.tier = base.getTier();
            this.owner = base.getOwner();
            this.ownerName = base.getOwnerName();
            this.rfStorageCurrent = base.getEnergyLevel(EnumFacing.DOWN);
            this.rfStorageMax = base.getMaxEnergyLevel(EnumFacing.DOWN);
            this.attacksMobs = base.isAttacksMobs();
            this.attacksNeutrals = base.isAttacksNeutrals();
            this.attacksPlayers = base.isAttacksPlayers();
            this.multiTargeting = base.isMultiTargeting();
            this.trustedPlayers = base.getTrustedPlayers();
            this.camoBlockRegName = base.getCamoState().func_177230_c().getRegistryName().toString();
            this.camoBlockMeta = base.getCamoState().func_177230_c().func_176201_c(base.getCamoState());
            this.maxRange = base.getCurrentMaxRange();
            this.mode = base.getMode();
            this.kills = base.getKills();
            this.playerKills = base.getPlayerKills();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.tier = buf.readInt();
        this.owner = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.rfStorageCurrent = buf.readInt();
        this.rfStorageMax = buf.readInt();
        this.maxRange = buf.readInt();
        this.kills = buf.readInt();
        this.playerKills = buf.readInt();
        this.mode = EnumMachineMode.values()[buf.readInt()];
        this.attacksMobs = buf.readBoolean();
        this.attacksNeutrals = buf.readBoolean();
        this.attacksPlayers = buf.readBoolean();
        this.multiTargeting = buf.readBoolean();
        this.camoBlockRegName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.camoBlockMeta = buf.readInt();
        int lengthOfTPList = buf.readInt();
        if (lengthOfTPList > 0) {
            for (int i = 0; i < lengthOfTPList; ++i) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                TrustedPlayer trustedPlayer = new TrustedPlayer(name);
                trustedPlayer.uuid = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
                trustedPlayer.canOpenGUI = buf.readBoolean();
                trustedPlayer.canChangeTargeting = buf.readBoolean();
                trustedPlayer.admin = buf.readBoolean();
                this.trustedPlayers.add(trustedPlayer);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.tier);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.owner);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerName);
        buf.writeInt(this.rfStorageCurrent);
        buf.writeInt(this.rfStorageMax);
        buf.writeInt(this.maxRange);
        buf.writeInt(this.kills);
        buf.writeInt(this.playerKills);
        buf.writeInt(this.mode.ordinal());
        buf.writeBoolean(this.attacksMobs);
        buf.writeBoolean(this.attacksNeutrals);
        buf.writeBoolean(this.attacksPlayers);
        buf.writeBoolean(this.multiTargeting);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.camoBlockRegName);
        buf.writeInt(this.camoBlockMeta);
        buf.writeInt(this.trustedPlayers.size());
        if (this.trustedPlayers.size() > 0) {
            for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)trustedPlayer.getName());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)trustedPlayer.uuid.toString());
                buf.writeBoolean(trustedPlayer.canOpenGUI);
                buf.writeBoolean(trustedPlayer.canChangeTargeting);
                buf.writeBoolean(trustedPlayer.admin);
            }
        }
    }

    public String toString() {
        return String.format("MessageTurretBase - x:%s, y:%s, z:%s, owner:%s, rfstorage:%s", this.x, this.y, this.z, this.owner, this.rfStorageCurrent);
    }

    public static class MessageHandlerTurretBase
    implements IMessageHandler<MessageTurretBase, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageTurretBase messageIn, MessageContext ctx) {
            MessageTurretBase message = messageIn;
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity tileEntity = ClientProxy.getWorld((Minecraft)FMLClientHandler.instance().getClient()).func_175625_s(new BlockPos(message.x, message.y, message.z));
                if (tileEntity instanceof TurretBase) {
                    TurretBase base = (TurretBase)tileEntity;
                    OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
                    base.setOwner(message.owner);
                    base.setOwnerName(message.ownerName);
                    if (storage != null) {
                        storage.setEnergyStored(message.rfStorageCurrent);
                        storage.setCapacity(message.rfStorageMax);
                    }
                    base.setAttacksMobs(message.attacksMobs);
                    base.setAttacksNeutrals(message.attacksNeutrals);
                    base.setAttacksPlayers(message.attacksPlayers);
                    base.setMultiTargeting(message.multiTargeting);
                    base.setTrustedPlayers(message.trustedPlayers);
                    base.setTier(message.tier);
                    base.setMode(message.mode);
                    base.setCamoState(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(message.camoBlockRegName))).func_176203_a(message.camoBlockMeta));
                    base.setCurrentMaxRange(message.maxRange);
                    base.setKills(message.kills);
                    base.setPlayerKills(message.playerKills);
                }
            });
            return null;
        }
    }
}

