/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.crafting.FluidIngredientFactory;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ReconfigurableHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.device.ItemBlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.block.device.TileDiffuser;
import cofh.thermalexpansion.block.device.TileFactorizer;
import cofh.thermalexpansion.block.device.TileFisher;
import cofh.thermalexpansion.block.device.TileFluidBuffer;
import cofh.thermalexpansion.block.device.TileHeatSink;
import cofh.thermalexpansion.block.device.TileItemBuffer;
import cofh.thermalexpansion.block.device.TileItemCollector;
import cofh.thermalexpansion.block.device.TileLexicon;
import cofh.thermalexpansion.block.device.TileMobCatcher;
import cofh.thermalexpansion.block.device.TileNullifier;
import cofh.thermalexpansion.block.device.TileTapper;
import cofh.thermalexpansion.block.device.TileWaterGen;
import cofh.thermalexpansion.block.device.TileXpCollector;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.item.ItemFrame;
import cofh.thermalexpansion.render.BakeryDevice;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.tome.ItemTomeExperience;
import cofh.thermalfoundation.item.tome.ItemTomeLexicon;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockDevice
extends BlockTEBase
implements IModelRegister,
IBakeryProvider,
IWorldBlockTextureProvider {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static boolean[] enable = new boolean[Type.values().length];
    public static ItemStack deviceWaterGen;
    public static ItemStack deviceNullifier;
    public static ItemStack deviceHeatSink;
    public static ItemStack deviceTapper;
    public static ItemStack deviceFisher;
    public static ItemStack deviceItemBuffer;
    public static ItemStack deviceFluidBuffer;
    public static ItemStack deviceLexicon;
    public static ItemStack deviceExpCollector;
    public static ItemStack deviceDiffuser;
    public static ItemStack deviceFactorizer;
    public static ItemStack deviceMobCatcher;
    public static ItemStack deviceItemCollector;
    public static ItemStack deviceChunkLoader;
    public static ItemBlockDevice itemBlock;

    public BlockDevice() {
        super(Material.field_151573_f);
        this.func_149663_c("device");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.WATER_GEN)));
        this.configGui = true;
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_DEVICE});
        builder.add(new IUnlistedProperty[]{TEProps.BAKERY_WORLD});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            if (!enable[i]) continue;
            items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta >= Type.values().length) {
            return null;
        }
        switch (Type.values()[meta]) {
            case WATER_GEN: {
                return new TileWaterGen();
            }
            case NULLIFIER: {
                return new TileNullifier();
            }
            case HEAT_SINK: {
                return new TileHeatSink();
            }
            case TAPPER: {
                return new TileTapper();
            }
            case FISHER: {
                return new TileFisher();
            }
            case ITEM_BUFFER: {
                return new TileItemBuffer();
            }
            case FLUID_BUFFER: {
                return new TileFluidBuffer();
            }
            case LEXICON: {
                return new TileLexicon();
            }
            case XP_COLLECTOR: {
                return new TileXpCollector();
            }
            case DIFFUSER: {
                return new TileDiffuser();
            }
            case FACTORIZER: {
                return new TileFactorizer();
            }
            case MOB_CATCHER: {
                return new TileMobCatcher();
            }
            case ITEM_COLLECTOR: {
                return new TileItemCollector();
            }
        }
        return null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileDeviceBase tile = (TileDeviceBase)world.func_175625_s(pos);
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing((ItemStack)stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache((ItemStack)stack, (byte[])tile.getDefaultSides());
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = sideCache[storedFacing];
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileDeviceBase tile = (TileDeviceBase)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return false;
        }
        if (ItemHelper.isPlayerHoldingNothing((EntityPlayer)player) && player.func_70093_af() && tile.hasConfigGui() && ServerHelper.isServerWorld((World)world)) {
            return tile.openConfigGui(player);
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            ItemStack heldItem = player.func_184586_b(hand);
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (FluidHelper.isFluidHandler((ItemStack)heldItem)) {
                FluidHelper.interactWithHandler((ItemStack)heldItem, (IFluidHandler)handler, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    public IBakery getBakery() {
        return BakeryDevice.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        if (side == EnumFacing.DOWN) {
            return TETextures.DEVICE_BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return TETextures.DEVICE_TOP;
        }
        return side != EnumFacing.NORTH ? TETextures.DEVICE_SIDE : TETextures.DEVICE_FACE[stack.func_77960_j() % Type.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileDeviceBase) {
            TileDeviceBase tile = (TileDeviceBase)tileEntity;
            return tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            TileDeviceBase tile = (TileDeviceBase)((Object)((Object)state.getValue(TEProps.TILE_DEVICE)));
            StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName().toString() + "|" + state.func_177230_c().func_176201_c((IBlockState)state));
            builder.append("facing=").append(tile.getFacing());
            builder.append(",active=").append(tile.isActive);
            builder.append(",side_config={");
            for (byte i : tile.sideCache) {
                builder.append(",").append(i);
            }
            builder.append("}");
            if (tile.hasFluidUnderlay() && tile.isActive) {
                FluidStack stack = tile.getRenderFluid();
                builder.append(",fluid=").append(stack != null ? Integer.valueOf(FluidHelper.getFluidHash((FluidStack)stack)) : tile.getTexture(tile.getFacing(), 0).func_94215_i());
            }
            return builder.toString();
        });
    }

    public boolean preInit() {
        this.setRegistryName("device");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockDevice((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileDeviceBase.config();
        TileWaterGen.initialize();
        TileNullifier.initialize();
        TileHeatSink.initialize();
        TileTapper.initialize();
        TileFisher.initialize();
        TileItemBuffer.initialize();
        TileFluidBuffer.initialize();
        TileLexicon.initialize();
        TileXpCollector.initialize();
        TileDiffuser.initialize();
        TileFactorizer.initialize();
        TileMobCatcher.initialize();
        TileItemCollector.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        deviceWaterGen = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.WATER_GEN.getMetadata()));
        deviceNullifier = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.NULLIFIER.getMetadata()));
        deviceHeatSink = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.HEAT_SINK.getMetadata()));
        deviceTapper = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.TAPPER.getMetadata()));
        deviceFisher = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.FISHER.getMetadata()));
        deviceItemBuffer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ITEM_BUFFER.getMetadata()));
        deviceFluidBuffer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.FLUID_BUFFER.getMetadata()));
        deviceLexicon = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.LEXICON.getMetadata()));
        deviceExpCollector = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.XP_COLLECTOR.getMetadata()));
        deviceDiffuser = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.DIFFUSER.getMetadata()));
        deviceFactorizer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.FACTORIZER.getMetadata()));
        deviceMobCatcher = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.MOB_CATCHER.getMetadata()));
        deviceItemCollector = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ITEM_COLLECTOR.getMetadata()));
        this.addRecipes();
        return true;
    }

    private void addRecipes() {
        String ironPart = "gearIron";
        if (enable[Type.WATER_GEN.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceWaterGen, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "blockGlass"});
        }
        if (enable[Type.NULLIFIER.getMetadata()]) {
            RecipeHelper.addShapedFluidRecipe((ItemStack)deviceNullifier, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), new FluidIngredientFactory.FluidIngredient("lava"), Character.valueOf('Y'), Blocks.field_150336_V});
        }
        if (enable[Type.HEAT_SINK.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceHeatSink, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), "ingotInvar"});
        }
        if (enable[Type.TAPPER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceTapper, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), "plankWood"});
        }
        if (enable[Type.FISHER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceFisher, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Items.field_151112_aM, Character.valueOf('Y'), Blocks.field_150411_aY});
        }
        if (enable[Type.ITEM_BUFFER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceItemBuffer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "chestWood", Character.valueOf('Y'), "ingotTin"});
        }
        if (enable[Type.FLUID_BUFFER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceFluidBuffer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "ingotCopper"});
        }
        if (enable[Type.LEXICON.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceLexicon, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), ItemTomeLexicon.tomeLexicon, Character.valueOf('Y'), "ingotLead"});
        }
        if (enable[Type.XP_COLLECTOR.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceExpCollector, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), ItemTomeExperience.tomeExperience, Character.valueOf('Y'), "ingotGold"});
        }
        if (enable[Type.DIFFUSER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceDiffuser, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "ingotSilver"});
        }
        if (enable[Type.FACTORIZER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceFactorizer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "workbench", Character.valueOf('Y'), "ingotLead"});
        }
        if (enable[Type.MOB_CATCHER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceMobCatcher, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Blocks.field_150367_z, Character.valueOf('Y'), "ingotConstantan"});
        }
        if (enable[Type.ITEM_COLLECTOR.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)deviceItemCollector, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), ironPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Blocks.field_150438_bZ, Character.valueOf('Y'), "ingotTin"});
        }
    }

    public static enum Type implements IStringSerializable
    {
        WATER_GEN(0, "water_gen"),
        NULLIFIER(1, "nullifier"),
        HEAT_SINK(2, "heat_sink"),
        TAPPER(3, "tapper"),
        FISHER(4, "fisher"),
        ITEM_BUFFER(5, "item_buffer"),
        FLUID_BUFFER(6, "fluid_buffer"),
        LEXICON(7, "lexicon"),
        XP_COLLECTOR(8, "xp_collector"),
        DIFFUSER(9, "diffuser"),
        FACTORIZER(10, "factorizer"),
        MOB_CATCHER(11, "mob_catcher"),
        ITEM_COLLECTOR(12, "item_collector"),
        CHUNK_LOADER(13, "chunk_loader");

        private final int metadata;
        private final String name;

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

