/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import cofh.core.block.BlockCore;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ReconfigurableHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockCell;
import cofh.thermalexpansion.block.storage.TileCell;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.item.ItemFrame;
import cofh.thermalexpansion.render.BakeryCell;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.ItemUpgrade;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockCell
extends BlockTEBase
implements IModelRegister,
IBakeryProvider {
    public static boolean enable = true;
    public static boolean enableCreative = true;
    public static boolean enableSecurity = true;
    public static boolean enableClassicRecipes = false;
    public static boolean enableUpgradeKitCrafting = false;
    public static ItemStack[] cell;
    public static ItemStack cellCreative;
    public static ItemBlockCell itemBlock;

    public BlockCell() {
        super(Material.field_151573_f);
        this.func_149663_c("cell");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_CELL});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            if (TEProps.creativeTabShowAllBlockLevels) {
                for (int j = 0; j <= 4; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this)));
            }
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCell();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileCell tile = (TileCell)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack), (int)0, (int)CoreEnchantments.holding.func_77325_b());
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            tile.amountRecv = stack.func_77978_p().func_74762_e("Recv");
            tile.amountSend = stack.func_77978_p().func_74762_e("Send");
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing((ItemStack)stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache((ItemStack)stack, (byte[])tile.getDefaultSides());
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = sideCache[storedFacing];
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileCell tile = (TileCell)world.func_175625_s(pos);
        if (tile != null) {
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            retTag.func_74768_a("Recv", tile.amountRecv);
            retTag.func_74768_a("Send", tile.amountSend);
        }
        return retTag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return BakeryCell.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper("thermalexpansion", "cell", "cell");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)mapper.location);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)mapper);
        ModelRegistryHelper.register((ModelResourceLocation)mapper.location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            TileCell cell = (TileCell)((Object)((Object)state.getValue(TEProps.TILE_CELL)));
            StringBuilder builder = new StringBuilder(ModelBakery.defaultBlockKeyGenerator.generateKey(state));
            builder.append(",creative=").append(cell.isCreative);
            builder.append(",level=").append(cell.getLevel());
            builder.append(",holding=").append(cell.enchantHolding);
            builder.append(",facing=").append(cell.getFacing());
            builder.append(",scale=").append(cell.getLightValue());
            builder.append(",side_config{");
            for (byte i : cell.sideCache) {
                builder.append(",").append(i);
            }
            builder.append("}");
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean preInit() {
        this.setRegistryName("cell");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockCell((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileCell.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        cell = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockCell.cell[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        cellCreative = itemBlock.setCreativeTag(new ItemStack((Block)this));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)cell[0], (Object[])new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), ItemFrame.frameCell0, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), Blocks.field_150451_bX});
        }
    }

    private void addUpgradeRecipes() {
        int j;
        if (!enableUpgradeKitCrafting || !enable) {
            return;
        }
        if (!enableClassicRecipes) {
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)cell[j + 1], (Object[])new Object[]{cell[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)cell[j + 1], (Object[])new Object[]{cell[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
        for (j = 0; j < 5; ++j) {
            RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)cellCreative, (Object[])new Object[]{cell[j], ItemUpgrade.upgradeCreative});
        }
    }

    private void addClassicRecipes() {
        if (!enableClassicRecipes || !enable) {
            return;
        }
        RecipeHelper.addShapedRecipe((ItemStack)cell[1], (Object[])new Object[]{"YXY", "ICI", "YPY", Character.valueOf('C'), ItemFrame.frameCell0, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), Blocks.field_150451_bX, Character.valueOf('Y'), "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)cell[1], (Object[])new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), ItemFrame.frameCell1, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), Blocks.field_150451_bX});
        RecipeHelper.addShapedRecipe((ItemStack)cell[2], (Object[])new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), ItemFrame.frameCell2Filled, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), "ingotSilver"});
        RecipeHelper.addShapedRecipe((ItemStack)cell[3], (Object[])new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), ItemFrame.frameCell3Filled, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), "ingotSilver"});
        RecipeHelper.addShapedRecipe((ItemStack)cell[4], (Object[])new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), ItemFrame.frameCell4Filled, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), "ingotSilver"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cell[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), cell[0], Character.valueOf('I'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cell[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), cell[2], Character.valueOf('I'), "ingotSignalum"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cell[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), cell[3], Character.valueOf('I'), "ingotEnderium"});
    }
}

