/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.dynamo.magmatic;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoMagmatic;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.magmatic.MagmaticFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.MagmaticManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MagmaticFuelCategory
extends BaseFuelCategory<MagmaticFuelWrapper> {
    public static boolean enable = true;
    IDrawableStatic tank;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Dynamo.Magmatic", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MagmaticFuelCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(MagmaticFuelCategory.getRecipes(registry, guiHelper), "thermalexpansion.magmatic");
        registry.addRecipeClickArea(GuiDynamoMagmatic.class, 115, 35, 16, 16, new String[]{"thermalexpansion.magmatic"});
        registry.addRecipeCatalyst((Object)BlockDynamo.dynamoMagmatic, new String[]{"thermalexpansion.magmatic"});
    }

    public static List<MagmaticFuelWrapper> getRecipes(IModRegistry registry, IGuiHelper guiHelper) {
        ArrayList<MagmaticFuelWrapper> recipes = new ArrayList<MagmaticFuelWrapper>();
        for (String fluidName : MagmaticManager.getFuels()) {
            FluidStack fuelStack = new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000);
            recipes.add(new MagmaticFuelWrapper(guiHelper, fuelStack, MagmaticManager.getFuelEnergy(fuelStack)));
        }
        return recipes;
    }

    public MagmaticFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiDynamoMagmatic.TEXTURE, 26, 11, 70, 62, 0, 0, 16, 78);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(4);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.dynamo.magmatic.name");
        this.tank = Drawables.getDrawables(guiHelper).getTank(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.magmatic";
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.tank.draw(minecraft, 33, 7);
    }

    public void setRecipe(IRecipeLayout recipeLayout, MagmaticFuelWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.init(0, true, 34, 8, 16, 30, 1000, false, null);
        guiFluidStacks.set(0, (List)inputs.get(0));
    }
}

