/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.integration;

import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.DefaultLightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.capabilities.CapabilityLightEmitter;

public class Albedo {
    public static boolean albedoCapCheck(Capability<?> capability) {
        return FMLCommonHandler.instance().getSide().isClient() && LibGlobals.Mods.ALBEDO.isLoaded() && Albedo.isAlbedoCap(capability);
    }

    private static boolean isAlbedoCap(Capability<?> capability) {
        return capability == elucent.albedo.Albedo.LIGHT_PROVIDER_CAPABILITY;
    }

    public static <T> T getVanillaStackCapability(final ItemStack stack) {
        if ((Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft() != 0) {
            return (T)elucent.albedo.Albedo.LIGHT_PROVIDER_CAPABILITY.cast((Object)new DefaultLightProvider(){

                public void gatherLights(GatherLightsEvent event, Entity entity) {
                    event.add(Light.builder().pos(entity.field_70165_t, entity.field_70163_u - 0.5, entity.field_70161_v).color(((Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft()).intValue(), true).radius(((Float)((Pair)CapabilityLightEmitter.getColorForStack(stack).getRight()).getRight()).floatValue()).build());
                }
            });
        }
        return null;
    }

    public static ICapabilityProvider getVanillaStackProvider(final ItemStack stack) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return Albedo.albedoCapCheck(capability) && (Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft() != 0;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return this.hasCapability(capability, null) ? (T)Albedo.getVanillaStackCapability(stack) : null;
            }
        };
    }

    public static ICapabilityProvider getEmptyProvider() {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return Albedo.albedoCapCheck(capability);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(this.hasCapability(capability, facing) ? Albedo.getEmptyCapability() : null);
            }
        };
    }

    public static <T> T getEmptyCapability() {
        return (T)elucent.albedo.Albedo.LIGHT_PROVIDER_CAPABILITY.cast((Object)new DefaultLightProvider());
    }
}

