/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiPowerCell
extends GenericGuiContainer<PowerCellTileEntity> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/powercell.png");

    public GuiPowerCell(PowerCellTileEntity te, PowerCellContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, RFTools.GUI_MANUAL_MAIN, "powercell");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(1000L).setLayoutHint(10, 7, 8, 54)).setShowText(false);
        this.energyBar.setValue(0L);
        Button allNone = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("allnone")).setText("None")).setTooltips(new String[]{"Set all sides to 'none'"})).setLayoutHint(140, 10, 32, 15);
        Button allInput = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("allinput")).setText("In")).setTooltips(new String[]{"Set all sides to", "accept energy"})).setLayoutHint(140, 27, 32, 15);
        Button allOutput = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("alloutput")).setText("Out")).setTooltips(new String[]{"Set all sides to", "send energy"})).setLayoutHint(140, 44, 32, 15);
        this.stats = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("clearstats")).setText("Stats")).setTooltips(new String[]{"Power statistics. Press to clear:"})).setLayoutHint(100, 10, 32, 15);
        Label label = new Label(this.field_146297_k, (Gui)this);
        ((Label)((Label)label.setText("Link:")).setTooltips(new String[]{"Link a powercard to card", "on the left"})).setLayoutHint(26, 30, 40, 18);
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.energyBar, allNone, allInput, allOutput, label, this.stats});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.action(RFToolsMessages.INSTANCE, "allnone", this.tileEntity, "setNone");
        this.window.action(RFToolsMessages.INSTANCE, "allinput", this.tileEntity, "setInput");
        this.window.action(RFToolsMessages.INSTANCE, "alloutput", this.tileEntity, "setOutput");
        this.window.action(RFToolsMessages.INSTANCE, "clearstats", this.tileEntity, "clearStats");
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            ((PowerCellTileEntity)this.tileEntity).requestDataFromServer("rftools", "getInfo", TypedMap.EMPTY);
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        this.requestRF();
        this.stats.setTooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + PowerCellTileEntity.tooltipInserted, "Extracted: " + PowerCellTileEntity.tooltipExtracted});
        int maxValue = (PowerCellTileEntity.tooltipBlocks - PowerCellTileEntity.tooltipAdvancedBlocks - PowerCellTileEntity.tooltipSimpleBlocks) * PowerCellConfiguration.rfPerNormalCell;
        maxValue += PowerCellTileEntity.tooltipAdvancedBlocks * PowerCellConfiguration.rfPerNormalCell * PowerCellConfiguration.advancedFactor;
        this.energyBar.setMaxValue((long)(maxValue += PowerCellTileEntity.tooltipSimpleBlocks * PowerCellConfiguration.rfPerNormalCell / PowerCellConfiguration.simpleFactor));
        this.energyBar.setValue((long)PowerCellTileEntity.tooltipEnergy);
    }
}

