/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.FieldDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$RenderDeclarationDescriptorVisitor$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.PropertyAccessorRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnresolvedType;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy functionTypeAnnotationsRenderer$delegate;
    private final Lazy functionTypeParameterTypesRenderer$delegate;
    @NotNull
    private final DescriptorRendererOptionsImpl options;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(DescriptorRendererImpl.class), "functionTypeAnnotationsRenderer", "getFunctionTypeAnnotationsRenderer()Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(DescriptorRendererImpl.class), "functionTypeParameterTypesRenderer", "getFunctionTypeParameterTypesRenderer()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;"))};
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        Lazy lazy = this.functionTypeAnnotationsRenderer$delegate;
        DescriptorRendererImpl descriptorRendererImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (DescriptorRendererImpl)lazy.getValue();
    }

    private final DescriptorRenderer getFunctionTypeParameterTypesRenderer() {
        Lazy lazy = this.functionTypeParameterTypesRenderer$delegate;
        DescriptorRendererImpl descriptorRendererImpl = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (DescriptorRenderer)lazy.getValue();
    }

    private final String renderKeyword(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return this.getBoldOnlyForNamesInHtml() ? keyword : "<b>" + keyword + "</b>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String renderError(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String escape(String string) {
        return this.getTextFormat().escape(string);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$2[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public String renderMessage(@NotNull String message) {
        String string;
        Intrinsics.checkParameterIsNotNull(message, "message");
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$3[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name, boolean rootRenderedElement) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String escaped = this.escape(RenderingUtilsKt.render(name));
        if (this.getBoldOnlyForNamesInHtml() && this.getTextFormat() == RenderingFormat.HTML && rootRenderedElement) {
            return "<b>" + escaped + "</b>";
        }
        return escaped;
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder, boolean rootRenderedElement) {
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        builder.append(this.renderName(name, rootRenderedElement));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "containingDeclaration.name");
                builder.append(this.renderName(name, false));
            }
        }
        if (this.getVerbose() || Intrinsics.areEqual(descriptor2.getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT) ^ true) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
            builder.append(this.renderName(name, true));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<Name> list = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, "fqName.pathSegments()");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        return this.getClassifierNamePolicy().renderClassifier(klass, this);
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType type2) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        this.renderNormalizedType($receiver, this.getTypeNormalizer().invoke(type2));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderNormalizedType(@NotNull StringBuilder $receiver, KotlinType type2) {
        AbbreviatedType abbreviated;
        UnwrappedType unwrappedType = type2.unwrap();
        if (!(unwrappedType instanceof AbbreviatedType)) {
            unwrappedType = null;
        }
        if ((abbreviated = (AbbreviatedType)unwrappedType) != null) {
            this.renderNormalizedTypeAsIs($receiver, abbreviated.getAbbreviation());
            if (this.getRenderUnabbreviatedType()) {
                this.renderAbbreviatedTypeExpansion($receiver, abbreviated);
            }
            return;
        }
        this.renderNormalizedTypeAsIs($receiver, type2);
    }

    private final void renderAbbreviatedTypeExpansion(@NotNull StringBuilder $receiver, AbbreviatedType abbreviated) {
        if (this.getTextFormat() == RenderingFormat.HTML) {
            $receiver.append("<font color=\"808080\"><i>");
        }
        $receiver.append(" /* = ");
        this.renderNormalizedTypeAsIs($receiver, abbreviated.getExpandedType());
        $receiver.append(" */");
        if (this.getTextFormat() == RenderingFormat.HTML) {
            $receiver.append("</i></font>");
        }
    }

    private final void renderNormalizedTypeAsIs(@NotNull StringBuilder $receiver, KotlinType type2) {
        if (type2 instanceof WrappedType && this.getDebugMode() && !((WrappedType)type2).isComputed()) {
            $receiver.append("<Not computed yet>");
            return;
        }
        UnwrappedType unwrappedType = type2.unwrap();
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 instanceof FlexibleType) {
            $receiver.append(((FlexibleType)unwrappedType).render(this, this));
        } else if (unwrappedType2 instanceof SimpleType) {
            this.renderSimpleType($receiver, (SimpleType)unwrappedType);
        }
    }

    private final void renderSimpleType(@NotNull StringBuilder $receiver, SimpleType type2) {
        if (Intrinsics.areEqual(type2, TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            $receiver.append("???");
            return;
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                if (typeConstructor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.ErrorUtils.UninferredParameterTypeConstructor");
                }
                TypeParameterDescriptor typeParameterDescriptor = ((ErrorUtils.UninferredParameterTypeConstructor)typeConstructor2).getTypeParameterDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "(type.constructor as Uni\u2026).typeParameterDescriptor");
                String string = typeParameterDescriptor.getName().toString();
                Intrinsics.checkExpressionValueIsNotNull(string, "(type.constructor as Uni\u2026escriptor.name.toString()");
                $receiver.append(this.renderError(string));
            } else {
                $receiver.append("???");
            }
            return;
        }
        if (KotlinTypeKt.isError(type2)) {
            this.renderDefaultType($receiver, type2);
            return;
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            this.renderFunctionType($receiver, type2);
        } else {
            this.renderDefaultType($receiver, type2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type2) {
        Object element$iv;
        TypeProjection it;
        if (!FunctionTypesKt.isBuiltinFunctionalType(type2)) return false;
        Iterable $receiver$iv = type2.getArguments();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!(it = (TypeProjection)(element$iv = iterator2.next())).isStarProjection());
        return false;
    }

    @Override
    @NotNull
    public String renderFlexibleType(@NotNull String lowerRendered, @NotNull String upperRendered, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(lowerRendered, "lowerRendered");
        Intrinsics.checkParameterIsNotNull(upperRendered, "upperRendered");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        if (this.differsOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default(upperRendered, "(", false, 2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + "!";
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor = builtIns.getCollection();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "builtIns.collection");
        String kotlinCollectionsPrefix = StringsKt.substringBefore$default(classifierNamePolicy.renderClassifier(classDescriptor, this), "Collection", null, 2, null);
        String mutablePrefix = "Mutable";
        String simpleCollection = this.replacePrefixes(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = this.replacePrefixes(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = builtIns.getArray();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "builtIns.array");
        String kotlinPrefix = StringsKt.substringBefore$default(classifierNamePolicy2.renderClassifier(classDescriptor2, this), "Array", null, 2, null);
        String array = this.replacePrefixes(lowerRendered, kotlinPrefix + this.escape("Array<"), upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return '(' + lowerRendered + ".." + upperRendered + ')';
    }

    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(typeArguments, "typeArguments");
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(this.lt());
        this.appendTypeProjections($receiver, typeArguments);
        $receiver.append(this.gt());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderDefaultType(@NotNull StringBuilder $receiver, KotlinType type2) {
        DescriptorRendererImpl.renderAnnotations$default(this, $receiver, type2, null, 2, null);
        if (KotlinTypeKt.isError(type2)) {
            if (type2 instanceof UnresolvedType && this.getPresentableUnresolvedTypes()) {
                $receiver.append(((UnresolvedType)type2).getPresentableName());
            } else {
                $receiver.append(type2.getConstructor().toString());
            }
            $receiver.append(this.renderTypeArguments(type2.getArguments()));
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, $receiver, type2, null, 2, null);
        }
        if (type2.isMarkedNullable()) {
            $receiver.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(type2)) {
            $receiver.append("!!");
        }
    }

    private final void renderTypeConstructorAndArguments(@NotNull StringBuilder $receiver, KotlinType type2, TypeConstructor typeConstructor2) {
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        if (possiblyInnerType == null) {
            $receiver.append(this.renderTypeConstructor(typeConstructor2));
            $receiver.append(this.renderTypeArguments(type2.getArguments()));
            return;
        }
        this.renderPossiblyInnerType($receiver, possiblyInnerType);
    }

    static /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    private final void renderPossiblyInnerType(@NotNull StringBuilder $receiver, PossiblyInnerType possiblyInnerType) {
        block3: {
            Object object;
            block2: {
                PossiblyInnerType possiblyInnerType2;
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType it = possiblyInnerType2 = object;
                this.renderPossiblyInnerType($receiver, it);
                $receiver.append('.');
                Name name = possiblyInnerType.getClassifierDescriptor().getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "possiblyInnerType.classifierDescriptor.name");
                object = $receiver.append(this.renderName(name, false));
                if (object != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "possiblyInnerType.classi\u2026escriptor.typeConstructor");
            object = $receiver.append(this.renderTypeConstructor(typeConstructor2));
        }
        $receiver.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
    }

    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        ClassifierDescriptor cd;
        Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
        ClassifierDescriptor classifierDescriptor = cd = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor || classifierDescriptor instanceof ClassDescriptor || classifierDescriptor instanceof TypeAliasDescriptor) {
            string = this.renderClassifierName(cd);
        } else if (classifierDescriptor == null) {
            string = typeConstructor2.toString();
        } else {
            String string2 = "Unexpected classifier: " + cd.getClass();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        this.appendTypeProjections($receiver, CollectionsKt.listOf(typeProjection));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void appendTypeProjections(@NotNull StringBuilder $receiver, List<? extends TypeProjection> typeProjections) {
        CollectionsKt.joinTo$default(typeProjections, $receiver, ", ", null, null, 0, null, new Function1<TypeProjection, CharSequence>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final CharSequence invoke(@NotNull TypeProjection it) {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (it.isStarProjection()) {
                    charSequence = "*";
                } else {
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                    String type2 = this.this$0.renderType(kotlinType);
                    charSequence = it.getProjectionKind() == Variance.INVARIANT ? type2 : (Object)((Object)it.getProjectionKind()) + ' ' + type2;
                }
                return charSequence;
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(1);
            }
        }, 60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderFunctionType(@NotNull StringBuilder $receiver, KotlinType type2) {
        boolean needParenthesis;
        DescriptorRendererImpl descriptorRendererImpl;
        int lengthBefore = $receiver.length();
        DescriptorRendererImpl $receiver2 = descriptorRendererImpl = this.getFunctionTypeAnnotationsRenderer();
        DescriptorRendererImpl.renderAnnotations$default($receiver2, $receiver, type2, null, 2, null);
        boolean hasAnnotations = $receiver.length() != lengthBefore;
        boolean isSuspend = FunctionTypesKt.isSuspendFunctionType(type2);
        boolean isNullable = type2.isMarkedNullable();
        KotlinType receiverType = FunctionTypesKt.getReceiverTypeFromFunctionType(type2);
        boolean bl = needParenthesis = isNullable || hasAnnotations && receiverType != null;
        if (needParenthesis) {
            if (isSuspend) {
                $receiver.insert(lengthBefore, '(');
            } else {
                if (hasAnnotations) {
                    boolean bl2;
                    boolean bl3 = bl2 = StringsKt.last($receiver) == ' ';
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    if ($receiver.charAt(StringsKt.getLastIndex($receiver) - 1) != ')') {
                        $receiver.insert(StringsKt.getLastIndex($receiver), "()");
                    }
                }
                $receiver.append("(");
            }
        }
        this.renderModifier($receiver, isSuspend, "suspend");
        if (receiverType != null) {
            boolean surroundReceiver;
            boolean bl4 = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable() || this.hasModifiersOrAnnotations(receiverType);
            if (surroundReceiver) {
                $receiver.append("(");
            }
            this.renderNormalizedType($receiver, receiverType);
            if (surroundReceiver) {
                $receiver.append(")");
            }
            $receiver.append(".");
        }
        $receiver.append("(");
        List<TypeProjection> parameterTypes = FunctionTypesKt.getValueParameterTypesFromFunctionType(type2);
        boolean bl5 = false;
        for (TypeProjection typeProjection : (Iterable)parameterTypes) {
            Name name;
            Name name2;
            void index;
            if (index > 0) {
                $receiver.append(", ");
            }
            if (this.getParameterNamesInFunctionalTypes()) {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeProjection.type");
                name2 = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType);
            } else {
                name2 = name = null;
            }
            if (name != null) {
                $receiver.append(this.renderName(name, false));
                $receiver.append(": ");
            }
            $receiver.append(this.getFunctionTypeParameterTypesRenderer().renderTypeProjection(typeProjection));
            ++index;
        }
        $receiver.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType($receiver, FunctionTypesKt.getReturnTypeFromFunctionType(type2));
        if (needParenthesis) {
            $receiver.append(")");
        }
        if (isNullable) {
            $receiver.append("?");
        }
    }

    private final boolean hasModifiersOrAnnotations(@NotNull KotlinType $receiver) {
        return FunctionTypesKt.isSuspendFunctionType($receiver) || !$receiver.getAnnotations().isEmpty();
    }

    private final void appendDefinedIn(@NotNull StringBuilder $receiver, DeclarationDescriptor descriptor2) {
        block4: {
            if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
                return;
            }
            if (descriptor2 instanceof ModuleDescriptor) {
                $receiver.append(" is a module");
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration == null || containingDeclaration instanceof ModuleDescriptor) break block4;
            $receiver.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(containingDeclaration);
            Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(containingDeclaration)");
            FqNameUnsafe fqName2 = fqNameUnsafe;
            $receiver.append(fqName2.isRoot() ? "root package" : this.renderFqName(fqName2));
            if (this.getWithSourceFileForTopLevel() && containingDeclaration instanceof PackageFragmentDescriptor && descriptor2 instanceof DeclarationDescriptorWithSource) {
                SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
                Intrinsics.checkExpressionValueIsNotNull(sourceElement, "descriptor.source");
                SourceFile sourceFile = sourceElement.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull(sourceFile, "descriptor.source.containingFile");
                String string = sourceFile.getName();
                if (string != null) {
                    String string2;
                    String sourceFileName = string2 = string;
                    $receiver.append(" ").append(this.renderMessage("in file")).append(" ").append(sourceFileName);
                }
            }
        }
    }

    private final void renderAnnotations(@NotNull StringBuilder $receiver, Annotated annotated, AnnotationUseSiteTarget target) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Function1<AnnotationDescriptor, Boolean> annotationFilter = this.getAnnotationFilter();
        for (AnnotationDescriptor annotation : annotated.getAnnotations()) {
            if (CollectionsKt.contains((Iterable)excluded, annotation.getFqName()) || annotationFilter != null && !annotationFilter.invoke(annotation).booleanValue()) continue;
            $receiver.append(this.renderAnnotation(annotation, target));
            if (this.getEachAnnotationOnNewLine()) {
                StringsKt.appendln($receiver);
                continue;
            }
            $receiver.append(" ");
        }
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        descriptorRendererImpl.renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
    }

    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation, @Nullable AnnotationUseSiteTarget target) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(annotation, "annotation");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append('@');
        if (target != null) {
            $receiver.append(target.getRenderName() + ":");
        }
        KotlinType annotationType = annotation.getType();
        $receiver.append(this.renderType(annotationType));
        if (this.getIncludeAnnotationArguments()) {
            Collection collection;
            List<String> arguments2 = this.renderAndSortAnnotationArguments(annotation);
            if (this.getIncludeEmptyAnnotationArguments() || !(collection = (Collection)arguments2).isEmpty()) {
                CollectionsKt.joinTo$default(arguments2, $receiver, ", ", "(", ")", 0, null, null, 112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError(annotationType) || annotationType.getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses.MockClassDescriptor)) {
            $receiver.append(" /* annotation class not found */");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        Name it;
        void $receiver$iv$iv22;
        Iterable $receiver$iv22;
        List list;
        List list2;
        Object object;
        Iterable iterable;
        List $receiver$iv3;
        Iterable destination$iv$iv;
        Map<Name, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass(descriptor2) : null;
        Object object2 = classDescriptor;
        if (object2 != null && (object2 = object2.getUnsubstitutedPrimaryConstructor()) != null && (object2 = object2.getValueParameters()) != null) {
            void $receiver$iv$iv3;
            ValueParameterDescriptor it2;
            List $receiver$iv$iv32;
            Iterable $receiver$iv4;
            Iterable iterable3 = (Iterable)object2;
            void list22 = $receiver$iv4;
            destination$iv$iv = new ArrayList();
            for (Object t : $receiver$iv$iv32) {
                it2 = (ValueParameterDescriptor)t;
                if (!it2.declaresDefaultValue()) continue;
                destination$iv$iv.add(t);
            }
            $receiver$iv4 = (List)destination$iv$iv;
            $receiver$iv$iv32 = $receiver$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
            for (Object t : $receiver$iv$iv3) {
                void it3;
                it2 = (ValueParameterDescriptor)t;
                iterable = destination$iv$iv;
                void v1 = it3;
                Intrinsics.checkExpressionValueIsNotNull(v1, "it");
                object = v1.getName();
                iterable.add(object);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        if ((list = ($receiver$iv3 = list2)) == null) {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        destination$iv$iv = $receiver$iv22 = (Iterable)parameterDescriptorsWithDefaultValue;
        Collection destination$iv$iv2 = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv22.iterator();
        while (iterator2.hasNext()) {
            Map<Name, ConstantValue<?>> $i$f$mapTo = allValueArguments2;
            Map<Name, ConstantValue<?>> $i$f$map = $i$f$mapTo;
            Object element$iv$iv = iterator2.next();
            it = (Name)element$iv$iv;
            if (!(!$i$f$map.containsKey(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv22 = (List)destination$iv$iv2;
        $receiver$iv$iv22 = $receiver$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv3 : $receiver$iv$iv2) {
            it = (Name)item$iv$iv3;
            iterable = destination$iv$iv3;
            object = it.asString() + " = ...";
            iterable.add(object);
        }
        List defaultList = (List)destination$iv$iv3;
        $receiver$iv$iv2 = allValueArguments2.entrySet();
        destination$iv$iv3 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv4 : $receiver$iv$iv) {
            void $name_value;
            Map.Entry $i$a$2$map = (Map.Entry)item$iv$iv4;
            iterable = collection;
            void var13_20 = $name_value;
            Name name = (Name)var13_20.getKey();
            var13_20 = $name_value;
            ConstantValue value = (ConstantValue)var13_20.getValue();
            object = name.asString() + " = " + (!parameterDescriptorsWithDefaultValue.contains(name) ? this.renderConstant(value) : "...");
            iterable.add(object);
        }
        List argumentList = (List)collection;
        return CollectionsKt.sorted(CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList));
    }

    private final String renderConstant(ConstantValue<?> value) {
        ConstantValue<?> constantValue = value;
        return constantValue instanceof ArrayValue ? CollectionsKt.joinToString$default((Iterable)((ArrayValue)value).getValue(), ", ", "{", "}", 0, null, new Function1<ConstantValue<?>, String>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final String invoke(@NotNull ConstantValue<?> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return DescriptorRendererImpl.access$renderConstant(this.this$0, it);
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(1);
            }
        }, 24, null) : (constantValue instanceof AnnotationValue ? StringsKt.removePrefix(DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value).getValue(), null, 2, null), (CharSequence)"@") : (constantValue instanceof KClassValue ? this.renderType(((KClassValue)value).getValue()) + "::class" : value.toString()));
    }

    private final void renderVisibility(Visibility visibility, StringBuilder builder) {
        Visibility visibility2 = visibility;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual(visibility2, Visibilities.DEFAULT_VISIBILITY)) {
            return;
        }
        builder.append(this.renderKeyword(visibility2.getDisplayName())).append(" ");
    }

    private final void renderModality(Modality modality, StringBuilder builder) {
        String string = modality.name();
        boolean bl = this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY);
        StringBuilder stringBuilder = builder;
        DescriptorRendererImpl descriptorRendererImpl = this;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        descriptorRendererImpl.renderModifier(stringBuilder, bl, string4);
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || callable.getModality() != Modality.FINAL) {
            if (this.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && callable.getModality() == Modality.OPEN && this.overridesSomething(callable)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)modality, "callable.modality");
            this.renderModality(modality, builder);
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMember) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            this.renderModifier(builder, true, "override");
            if (this.getVerbose()) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            String string = callableMember.getKind().name();
            StringBuilder stringBuilder = builder.append("/*");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            stringBuilder.append(string4).append("*/ ");
        }
    }

    private final void renderModifier(StringBuilder builder, boolean value, String modifier) {
        if (value) {
            builder.append(this.renderKeyword(modifier));
            builder.append(" ");
        }
    }

    private final void renderMemberModifiers(MemberDescriptor descriptor2, StringBuilder builder) {
        this.renderModifier(builder, descriptor2.isExternal(), "external");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && descriptor2.isExpect(), "expect");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && descriptor2.isActual(), "actual");
    }

    /*
     * Unable to fully structure code
     */
    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        block11: {
            block10: {
                if (!functionDescriptor.isOperator()) ** GOTO lbl-1000
                v0 = functionDescriptor.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(v0, "functionDescriptor.overriddenDescriptors");
                $receiver$iv = v0;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v1 = true;
                } else {
                    for (T element$iv : $receiver$iv) {
                        v2 = it = (FunctionDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                        if (!v2.isOperator()) continue;
                        v1 = false;
                        break block10;
                    }
                    v1 = true;
                }
            }
            if (v1 || this.getAlwaysRenderModifiers()) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = isOperator = false;
            }
            if (!functionDescriptor.isInfix()) ** GOTO lbl-1000
            v4 = functionDescriptor.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(v4, "functionDescriptor.overriddenDescriptors");
            $receiver$iv = v4;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v5 = true;
            } else {
                for (T element$iv : $receiver$iv) {
                    v6 = it = (FunctionDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(v6, "it");
                    if (!v6.isInfix()) continue;
                    v5 = false;
                    break block11;
                }
                v5 = true;
            }
        }
        if (v5 || this.getAlwaysRenderModifiers()) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = false;
        }
        isInfix = v7;
        this.renderModifier(builder, functionDescriptor.isTailrec(), "tailrec");
        this.renderSuspendModifier(functionDescriptor, builder);
        this.renderModifier(builder, functionDescriptor.isInline(), "inline");
        this.renderModifier(builder, isInfix, "infix");
        this.renderModifier(builder, isOperator, "operator");
    }

    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        this.renderModifier(builder, functionDescriptor.isSuspend(), "suspend");
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $receiver);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn($receiver, declarationDescriptor);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        this.renderModifier(builder, typeParameter.isReified(), "reified");
        String variance = typeParameter.getVariance().getLabel();
        CharSequence charSequence = variance;
        StringBuilder stringBuilder = builder;
        DescriptorRendererImpl descriptorRendererImpl = this;
        boolean bl = charSequence.length() > 0;
        descriptorRendererImpl.renderModifier(stringBuilder, bl, variance);
        DescriptorRendererImpl.renderAnnotations$default(this, builder, typeParameter, null, 2, null);
        this.renderName(typeParameter, builder, topLevel);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder2 = builder.append(" : ");
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                stringBuilder2.append(this.renderType(kotlinType));
            }
        } else if (topLevel) {
            boolean first2 = true;
            for (KotlinType upperBound : typeParameter.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first2) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                builder.append(this.renderType(kotlinType));
                first2 = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters2, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!typeParameters2.isEmpty()) {
            builder.append(this.lt());
            this.renderTypeParameterList(builder, typeParameters2);
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder builder, List<? extends TypeParameterDescriptor> typeParameters2) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters2.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter(typeParameterDescriptor, builder, false);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                DescriptorRendererImpl.renderAnnotations$default(this, builder, function, null, 2, null);
                Visibility visibility = function.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull(visibility, "function.visibility");
                this.renderVisibility(visibility, builder);
                this.renderModalityForCallable(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderMemberModifiers(function, builder);
                }
                this.renderOverride(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderAdditionalModifiers(function, builder);
                } else {
                    this.renderSuspendModifier(function, builder);
                }
                this.renderMemberKind(function, builder);
                if (this.getVerbose()) {
                    if (function.isHiddenToOvercomeSignatureClash()) {
                        builder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (function.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        builder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "function.typeParameters");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder, true);
        List<ValueParameterDescriptor> list = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "function.valueParameters");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType != null && KotlinBuiltIns.isUnit(returnType))) {
            builder.append(": ").append(returnType == null ? "[NULL]" : this.renderType(returnType));
        }
        List<TypeParameterDescriptor> list2 = function.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "function.typeParameters");
        this.renderWhereSuffix(list2, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.type");
            stringBuilder.append(this.renderType(kotlinType));
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            this.renderAnnotations(builder, receiver, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.type");
            KotlinType type2 = kotlinType;
            String result2 = this.renderType(type2);
            if (this.shouldRenderAsPrettyFunctionType(type2) && !TypeUtils.isNullableType(type2)) {
                result2 = '(' + result2 + ')';
            }
            builder.append(result2).append(".");
        }
    }

    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, builder, constructor, null, 2, null);
        Visibility visibility = constructor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "constructor.visibility");
        this.renderVisibility(visibility, builder);
        this.renderMemberKind(constructor, builder);
        if (this.getRenderConstructorKeyword()) {
            builder.append(this.renderKeyword("constructor"));
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = constructor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters, "constructor.containingDeclaration");
            ClassifierDescriptorWithTypeParameters classDescriptor = classifierDescriptorWithTypeParameters;
            if (this.getRenderConstructorKeyword()) {
                builder.append(" ");
            }
            this.renderName(classDescriptor, builder, true);
            List<TypeParameterDescriptor> list = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "constructor.typeParameters");
            this.renderTypeParameters(list, builder, false);
        }
        List<ValueParameterDescriptor> list = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "constructor.valueParameters");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getSecondaryConstructorsAsPrimary()) {
            List<TypeParameterDescriptor> list2 = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.typeParameters");
            this.renderWhereSuffix(list2, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters2, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters2) {
            void $receiver$iv;
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list, "typeParameter.upperBounds");
            Iterable iterable = CollectionsKt.drop((Iterable)list, 1);
            for (Object item$iv : $receiver$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "typeParameter.name");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name, false)).append(" : ");
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull(v4, "it");
                String string = stringBuilder2.append(this.renderType((KotlinType)v4)).toString();
                collection.add(string);
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default(upperBoundStrings, builder, ", ", null, null, 0, null, null, 124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        int parameterCount = parameters2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        boolean bl = false;
        for (ValueParameterDescriptor parameter : (Iterable)parameters2) {
            void index;
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, (int)index, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, (int)index, parameterCount, builder);
            ++index;
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$4[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !synthesizedParameterNames;
            }
            case 3: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, builder, valueParameter, null, 2, null);
        this.renderModifier(builder, valueParameter.isCrossinline(), "crossinline");
        this.renderModifier(builder, valueParameter.isNoinline(), "noinline");
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.getDefaultParameterValueRenderer() != null && (this.getDebugMode() ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameter)) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            StringBuilder stringBuilder = new StringBuilder().append(" = ");
            Function1<ValueParameterDescriptor, String> function1 = this.getDefaultParameterValueRenderer();
            if (function1 == null) {
                Intrinsics.throwNpe();
            }
            builder.append(stringBuilder.append(function1.invoke(valueParameter)).toString());
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder) {
        if (!(variable instanceof ValueParameterDescriptor)) {
            builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
        }
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel) {
        KotlinType kotlinType = variable.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "variable.type");
        KotlinType realType = kotlinType;
        VariableDescriptor variableDescriptor = variable;
        if (!(variableDescriptor instanceof ValueParameterDescriptor)) {
            variableDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)variableDescriptor;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType2 = varargElementType;
        if (kotlinType2 == null) {
            kotlinType2 = realType;
        }
        KotlinType typeToRender = kotlinType2;
        this.renderModifier(builder, varargElementType != null, "vararg");
        if (topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder, topLevel);
            builder.append(": ");
        }
        builder.append(this.renderType(typeToRender));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            builder.append(" /*").append(this.renderType(realType)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                this.renderPropertyAnnotations(property, builder);
                Visibility visibility = property.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull(visibility, "property.visibility");
                this.renderVisibility(visibility, builder);
                this.renderModifier(builder, property.isConst(), "const");
                this.renderMemberModifiers(property, builder);
                this.renderModalityForCallable(property, builder);
                this.renderOverride(property, builder);
                this.renderModifier(builder, property.isLateInit(), "lateinit");
                this.renderMemberKind(property, builder);
            }
            this.renderValVarPrefix(property, builder);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "property.typeParameters");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder, true);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "property.type");
        stringBuilder.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = property.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "property.typeParameters");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderPropertyAnnotations(PropertyDescriptor property, StringBuilder builder) {
        block3: {
            Object object;
            Object it;
            Object object2;
            if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
                return;
            }
            DescriptorRendererImpl.renderAnnotations$default(this, builder, property, null, 2, null);
            FieldDescriptor fieldDescriptor = property.getBackingField();
            if (fieldDescriptor != null) {
                it = object2 = fieldDescriptor;
                FieldDescriptor fieldDescriptor2 = it;
                Intrinsics.checkExpressionValueIsNotNull(fieldDescriptor2, "it");
                this.renderAnnotations(builder, fieldDescriptor2, AnnotationUseSiteTarget.FIELD);
            }
            FieldDescriptor fieldDescriptor3 = property.getDelegateField();
            if (fieldDescriptor3 != null) {
                it = object2 = fieldDescriptor3;
                FieldDescriptor fieldDescriptor4 = it;
                Intrinsics.checkExpressionValueIsNotNull(fieldDescriptor4, "it");
                this.renderAnnotations(builder, fieldDescriptor4, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            }
            if (this.getPropertyAccessorRenderingPolicy() != PropertyAccessorRenderingPolicy.NONE || (object = property.getSetter()) == null || (object = object.getValueParameters()) == null || (object = (ValueParameterDescriptor)CollectionsKt.single(object)) == null) break block3;
            it = object2 = object;
            this.renderAnnotations(builder, (Annotated)it, AnnotationUseSiteTarget.SETTER_PARAMETER);
        }
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        block1: {
            if (!this.getIncludePropertyConstant()) break block1;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> constantValue2;
                ConstantValue<?> constant = constantValue2 = constantValue;
                StringBuilder stringBuilder = builder.append(" = ");
                ConstantValue<?> constantValue3 = constant;
                Intrinsics.checkExpressionValueIsNotNull(constantValue3, "constant");
                stringBuilder.append(this.escape(this.renderConstant(constantValue3)));
            }
        }
    }

    private final void renderTypeAlias(TypeAliasDescriptor typeAlias, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, builder, typeAlias, null, 2, null);
        Visibility visibility = typeAlias.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "typeAlias.visibility");
        this.renderVisibility(visibility, builder);
        this.renderMemberModifiers(typeAlias, builder);
        builder.append(this.renderKeyword("typealias")).append(" ");
        this.renderName(typeAlias, builder, true);
        List<TypeParameterDescriptor> list = typeAlias.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "typeAlias.declaredTypeParameters");
        this.renderTypeParameters(list, builder, false);
        this.renderCapturedTypeParametersIfRequired(typeAlias, builder);
        builder.append(" = ").append(this.renderType(typeAlias.getUnderlyingType()));
    }

    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifier2, StringBuilder builder) {
        List<TypeParameterDescriptor> list = classifier2.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "classifier.declaredTypeParameters");
        List<TypeParameterDescriptor> typeParameters2 = list;
        TypeConstructor typeConstructor2 = classifier2.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "classifier.typeConstructor");
        List<TypeParameterDescriptor> list2 = typeConstructor2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "classifier.typeConstructor.parameters");
        List<TypeParameterDescriptor> typeConstructorParameters = list2;
        if (this.getVerbose() && classifier2.isInner() && typeConstructorParameters.size() > typeParameters2.size()) {
            builder.append(" /*captured type parameters: ");
            this.renderTypeParameterList(builder, typeConstructorParameters.subList(typeParameters2.size(), typeConstructorParameters.size()));
            builder.append("*/");
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ClassConstructorDescriptor primaryConstructor2;
        boolean isEnumEntry;
        boolean bl = isEnumEntry = klass.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, builder, klass, null, 2, null);
            if (!isEnumEntry) {
                Visibility visibility = klass.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull(visibility, "klass.visibility");
                this.renderVisibility(visibility, builder);
            }
            if (klass.getKind() != ClassKind.INTERFACE || klass.getModality() != Modality.ABSTRACT) {
                ClassKind classKind = klass.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)classKind, "klass.kind");
                if (!classKind.isSingleton() || klass.getModality() != Modality.FINAL) {
                    Modality modality = klass.getModality();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modality, "klass.modality");
                    this.renderModality(modality, builder);
                }
            }
            this.renderMemberModifiers(klass, builder);
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && klass.isInner(), "inner");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && klass.isData(), "data");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && klass.isInline(), "inline");
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder, true);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = klass.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "klass.declaredTypeParameters");
        List<TypeParameterDescriptor> typeParameters2 = list;
        this.renderTypeParameters(typeParameters2, builder, false);
        this.renderCapturedTypeParametersIfRequired(klass, builder);
        ClassKind classKind = klass.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)classKind, "klass.kind");
        if (!classKind.isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            DescriptorRendererImpl.renderAnnotations$default(this, builder, primaryConstructor2, null, 2, null);
            Visibility visibility = primaryConstructor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "primaryConstructor.visibility");
            this.renderVisibility(visibility, builder);
            builder.append(this.renderKeyword("constructor"));
            List<ValueParameterDescriptor> list2 = primaryConstructor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "primaryConstructor.valueParameters");
            this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list2, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        this.renderWhereSuffix(typeParameters2, builder);
    }

    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
            return;
        }
        TypeConstructor typeConstructor2 = klass.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "klass.typeConstructor");
        Collection<KotlinType> collection = typeConstructor2.getSupertypes();
        Intrinsics.checkExpressionValueIsNotNull(collection, "klass.typeConstructor.supertypes");
        Collection<KotlinType> supertypes2 = collection;
        if (supertypes2.isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        CollectionsKt.joinTo$default(supertypes2, builder, ", ", null, null, 0, null, new Function1<KotlinType, String>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final String invoke(KotlinType it) {
                KotlinType kotlinType = it;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it");
                return this.this$0.renderType(kotlinType);
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(1);
            }
        }, 60, null);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix(klass)));
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        this.renderPackageHeader(packageView.getFqName(), "package", builder);
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder, false);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        this.renderPackageHeader(fragment.getFqName(), "package-fragment", builder);
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder, false);
        }
    }

    private final void renderPackageHeader(FqName fqName2, String fragmentOrView, StringBuilder builder) {
        builder.append(this.renderKeyword(fragmentOrView));
        FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fqName.toUnsafe()");
        String fqNameString = this.renderFqName(fqNameUnsafe);
        CharSequence charSequence = fqNameString;
        if (charSequence.length() > 0) {
            builder.append(" ");
            builder.append(fqNameString);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        this.renderMemberModifiers(descriptor2, builder);
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default(lowerRendered, lowerPrefix, false, 2, null) && StringsKt.startsWith$default(upperRendered, upperPrefix, false, 2, null)) {
            String string = lowerRendered;
            int n = lowerPrefix.length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
            String lowerWithoutPrefix = string3;
            String string4 = upperRendered;
            int n2 = upperPrefix.length();
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).substring(startIndex)");
            String upperWithoutPrefix = string6;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + "!";
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String lower, String upper) {
        return Intrinsics.areEqual(lower, StringsKt.replace$default(upper, "?", "", false, 4, null)) || StringsKt.endsWith$default(upper, "?", false, 2, null) && Intrinsics.areEqual(lower + '?', upper) || Intrinsics.areEqual('(' + lower + ")?", upper);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Intrinsics.checkParameterIsNotNull(options, "options");
        this.options = options;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy((Function0)new Function0<DescriptorRendererImpl>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final DescriptorRendererImpl invoke() {
                DescriptorRenderer descriptorRenderer2 = this.this$0.withOptions(functionTypeAnnotationsRenderer.1.INSTANCE);
                if (descriptorRenderer2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.renderer.DescriptorRendererImpl");
                }
                return (DescriptorRendererImpl)descriptorRenderer2;
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(0);
            }
        });
        this.functionTypeParameterTypesRenderer$delegate = LazyKt.lazy((Function0)new Function0<DescriptorRenderer>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final DescriptorRenderer invoke() {
                return this.this$0.withOptions(functionTypeParameterTypesRenderer.1.INSTANCE);
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(0);
            }
        });
    }

    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    @NotNull
    public AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    @Override
    public void setAnnotationArgumentsRenderingPolicy(@NotNull AnnotationArgumentsRenderingPolicy annotationArgumentsRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)annotationArgumentsRenderingPolicy, "<set-?>");
        this.options.setAnnotationArgumentsRenderingPolicy(annotationArgumentsRenderingPolicy);
    }

    @Nullable
    public Function1<AnnotationDescriptor, Boolean> getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public boolean getBoldOnlyForNamesInHtml() {
        return this.options.getBoldOnlyForNamesInHtml();
    }

    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @NotNull
    public ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public void setClassifierNamePolicy(@NotNull ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkParameterIsNotNull(classifierNamePolicy, "<set-?>");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Nullable
    public Function1<ValueParameterDescriptor, String> getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    public boolean getEachAnnotationOnNewLine() {
        return this.options.getEachAnnotationOnNewLine();
    }

    @Override
    public boolean getEnhancedTypes() {
        return this.options.getEnhancedTypes();
    }

    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    public boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public boolean getIncludeAnnotationArguments() {
        return this.options.getIncludeAnnotationArguments();
    }

    public boolean getIncludeEmptyAnnotationArguments() {
        return this.options.getIncludeEmptyAnnotationArguments();
    }

    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setModifiers(set);
    }

    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)parameterNameRenderingPolicy, "<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    public boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public boolean getPresentableUnresolvedTypes() {
        return this.options.getPresentableUnresolvedTypes();
    }

    @NotNull
    public PropertyAccessorRenderingPolicy getPropertyAccessorRenderingPolicy() {
        return this.options.getPropertyAccessorRenderingPolicy();
    }

    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    public boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkParameterIsNotNull((Object)renderingFormat, "<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @NotNull
    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    public boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    @NotNull
    public static final /* synthetic */ String access$renderConstant(DescriptorRendererImpl $this, @NotNull ConstantValue value) {
        return $this.renderConstant(value);
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            this.visitPropertyAccessorDescriptor(descriptor2, builder, "getter");
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            this.visitPropertyAccessorDescriptor(descriptor2, builder, "setter");
        }

        private final void visitPropertyAccessorDescriptor(PropertyAccessorDescriptor descriptor2, StringBuilder builder, String kind) {
            switch (DescriptorRendererImpl$RenderDeclarationDescriptorVisitor$WhenMappings.$EnumSwitchMapping$0[DescriptorRendererImpl.this.getPropertyAccessorRenderingPolicy().ordinal()]) {
                case 1: {
                    DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                    builder.append(kind + " for ");
                    PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                    Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
                    DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
                    break;
                }
                case 2: {
                    this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
                }
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            builder.append(descriptor2.getName());
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(constructorDescriptor, "constructorDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderName(descriptor2, builder, true);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }

        @Override
        public void visitTypeAliasDescriptor(@NotNull TypeAliasDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderTypeAlias(descriptor2, builder);
        }
    }
}

