/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.CommandUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;

public class RegionCommandExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (RegionUtils.hasPendingRegion(src)) {
            if (args.hasAny("command") && args.hasAny("value")) {
                String command = (String)args.getOne("command").get();
                if (CommandUtils.isValid(command)) {
                    boolean value = Boolean.valueOf((String)args.getOne("value").get());
                    Region region = RegionUtils.getPendingRegion(src);
                    if (value) {
                        region.enableCommand(command);
                        MessageUtils.sendSuccessMessage(src, RegionText.REGION_COMMAND_ENABLED.getValue() + ": " + command);
                    } else {
                        region.disableCommand(command);
                        MessageUtils.sendSuccessMessage(src, RegionText.REGION_COMMAND_DISABLED.getValue() + ": " + command);
                    }
                    RegionUtils.updatePendingRegion(src, region);
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_COMMAND_NOT_FOUND.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, this.getCommandUsage());
            }
        } else {
            MessageUtils.sendErrorMessage(src, RegionText.NO_PENDING_REGION.getValue());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg command <value> <command>";
    }
}

