/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget;

import appeng.api.util.AEPartLocation;
import extracells.gui.widget.AbstractWidget;
import extracells.gui.widget.WidgetManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class WidgetFluidTank
extends AbstractWidget {
    public static final ResourceLocation TEXTURE_FILE = new ResourceLocation("extracells", "textures/gui/fluidtank.png");
    IFluidTank tank;
    AEPartLocation direction;

    public WidgetFluidTank(WidgetManager widgetManager, IFluidTank tank, int posX, int yPos) {
        this(widgetManager, tank, posX, yPos, AEPartLocation.INTERNAL);
    }

    public WidgetFluidTank(WidgetManager widgetManager, IFluidTank tank, int posX, int yPos, AEPartLocation location) {
        super(widgetManager, posX, yPos);
        this.width = 18;
        this.height = 73;
        this.tank = tank;
        this.direction = location;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.tank == null) {
            return;
        }
        TextureManager textureManager = this.manager.mc.func_110434_K();
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        textureManager.func_110577_a(TEXTURE_FILE);
        this.manager.gui.func_73729_b(this.xPos, this.yPos, 0, 0, 18, 73);
        int iconHeightRemainder = 5;
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null && fluid.amount > 0) {
            textureManager.func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
            if (iconHeightRemainder > 0) {
                this.manager.gui.func_175175_a(this.xPos + 1, this.yPos + 2, sprite, 16, iconHeightRemainder);
            }
            for (int i = 0; i < 4; ++i) {
                this.manager.gui.func_175175_a(this.xPos + 1, this.yPos + 2 + i * 16 + iconHeightRemainder, sprite, 16, 16);
            }
            textureManager.func_110577_a(TEXTURE_FILE);
            this.manager.gui.func_73729_b(this.xPos + 2, this.yPos + 1, 1, 1, 15, 72 - (int)(73.0f * ((float)fluid.amount / (float)this.tank.getCapacity())));
        }
        textureManager.func_110577_a(TEXTURE_FILE);
        this.manager.gui.func_73729_b(this.xPos + 1, this.yPos + 1, 19, 1, 16, 73);
        GlStateManager.func_179145_e();
    }

    @Override
    public List<String> getToolTip(int mouseX, int mouseY) {
        ArrayList<String> description = new ArrayList<String>();
        if (this.direction != AEPartLocation.INTERNAL) {
            description.add(I18n.func_74838_a((String)("extracells.tooltip.direction." + this.direction.ordinal())));
        }
        if (this.tank == null || this.tank.getFluid() == null) {
            description.add(I18n.func_74838_a((String)"extracells.tooltip.empty1"));
        } else if (this.tank.getFluid().amount > 0 && this.tank.getFluid().getFluid() != null) {
            String amountToText = this.tank.getFluid().amount + "mB";
            description.add(this.tank.getFluid().getFluid().getLocalizedName(this.tank.getFluid()));
            description.add(amountToText);
        }
        return description;
    }
}

