/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.config.FuzzyMode;
import extracells.api.IGasStorageCell;
import extracells.inventory.ECGasFilterInventory;
import extracells.inventory.InventoryPlain;
import extracells.item.ItemGas;
import extracells.item.storage.CellDefinition;
import extracells.item.storage.ItemStorageCell;
import extracells.item.storage.StorageType;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemStorageCellGas
extends ItemStorageCell
implements IGasStorageCell {
    public ItemStorageCellGas() {
        super(CellDefinition.GAS, StorageChannels.GAS());
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new InvWrapper((IInventory)new ECGasFilterInventory("configFluidCell", 63, is));
    }

    @Override
    public ArrayList<Object> getFilter(ItemStack stack) {
        if (this.channel != null) {
            return this.getFilterGas(stack);
        }
        return new ArrayList<Object>();
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public ArrayList<Object> getFilterGas(ItemStack stack) {
        ECGasFilterInventory inventory = new ECGasFilterInventory("", 63, stack);
        ItemStack[] itemStacks = inventory.slots;
        ArrayList<Object> filter = new ArrayList<Object>();
        if (itemStacks.length == 0) {
            return null;
        }
        for (ItemStack itemStack : itemStacks) {
            String gasName;
            Gas gas;
            if (itemStack == null || (gas = GasRegistry.getGas((String)(gasName = ItemGas.getGasName(itemStack)))) == null) continue;
            filter.add(gas);
        }
        return filter;
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    @Override
    public int getMaxBytes(ItemStack itemStack) {
        StorageType type = this.definition.cells.fromMeta(itemStack.func_77952_i());
        return type.getBytes();
    }

    @Override
    public int getMaxTypes(ItemStack unused) {
        return 5;
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new InvWrapper((IInventory)new InventoryPlain("configInventory", 0, 64));
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = is.func_77942_o() ? is.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a("fuzzyMode", fzMode.name());
        is.func_77982_d(tag);
    }
}

