/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.node.BinaryOpNode;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SquareBracketContainerNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.List;

public abstract class ScopeModifierNode
extends SymbolCallNode<TypedValue> {
    private final TypeDomain domain;
    private final String symbol;
    private final BinaryOperator<TypedValue> colonOperator;
    private final BinaryOperator<TypedValue> assignOperator;

    public ScopeModifierNode(TypeDomain domain, String symbol, BinaryOperator<TypedValue> colonOperator, BinaryOperator<TypedValue> assignOperator, List<IExprNode<TypedValue>> args) {
        super(symbol, args);
        this.domain = domain;
        this.symbol = symbol;
        this.colonOperator = colonOperator;
        this.assignOperator = assignOperator;
    }

    @Override
    public void flatten(List<IExecutable<TypedValue>> output) {
        ImmutableList args = ImmutableList.copyOf(this.getChildren());
        Preconditions.checkState((args.size() == 2 ? 1 : 0) != 0, (String)"Expected two args for '%s' expression", (Object)this.symbol);
        IExprNode argsNode = (IExprNode)args.get(0);
        IExprNode codeNode = (IExprNode)args.get(1);
        Preconditions.checkState((boolean)(argsNode instanceof SquareBracketContainerNode), (String)"Expected square brackets, got %s", (Object)argsNode);
        SquareBracketContainerNode bracketNode = (SquareBracketContainerNode)argsNode;
        int argumentCount = 0;
        for (IExprNode<TypedValue> iExprNode : bracketNode.getChildren()) {
            this.flattenArgNode(output, iExprNode);
            ++argumentCount;
        }
        Preconditions.checkState((argumentCount > 0 ? 1 : 0) != 0, (String)"'%s' expects at least one argument", (Object)this.symbol);
        output.add(new SymbolCall("list", argumentCount, 1));
        output.add(Value.create(Code.flattenAndWrap(this.domain, codeNode)));
        output.add(new SymbolCall(this.symbol, 2, 1));
    }

    private void flattenArgNode(List<IExecutable<TypedValue>> output, IExprNode<TypedValue> argNode) {
        Preconditions.checkState((boolean)(argNode instanceof BinaryOpNode), (Object)"Expected ':' or '=' as separator");
        BinaryOpNode opNode = (BinaryOpNode)argNode;
        if (opNode.operator == this.colonOperator || opNode.operator == this.assignOperator) {
            this.flattenNameAndValue(output, opNode.left, opNode.right);
        } else {
            this.handlePairOp(output, opNode);
        }
        output.add(this.colonOperator);
    }

    protected void handlePairOp(List<IExecutable<TypedValue>> output, BinaryOpNode<TypedValue> opNode) {
        throw new UnsupportedOperationException("Expected '=' or ':' as pair separators, got " + opNode.operator);
    }

    protected abstract void flattenNameAndValue(List<IExecutable<TypedValue>> var1, IExprNode<TypedValue> var2, IExprNode<TypedValue> var3);
}

