/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import omtteam.omlib.tileentity.ITrustedPlayersManager;
import omtteam.omlib.util.PlayerUtil;
import omtteam.openmodularturrets.blocks.turretheads.BlockTeleporterTurret;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.handler.OMTConfigHandler;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public class TeleporterTurretTileEntity
extends TurretHead {
    public TeleporterTurretTileEntity() {
        this.turretTier = 4;
    }

    @Override
    protected float getProjectileGravity() {
        return 0.0f;
    }

    @Override
    public void func_73660_a() {
        this.setSide();
        this.base = this.getBaseFromWorld();
        if (this.func_145831_w().field_72995_K) {
            if (this.rotationAnimation >= 360.0f) {
                this.rotationAnimation = 0.0f;
            }
            this.rotationAnimation += 0.03f;
            return;
        }
        ++this.ticks;
        if (this.base == null || this.base.getTier() < this.turretTier) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
        } else {
            EntityPlayerMP entity;
            this.concealmentChecks();
            TurretHeadUtil.updateSolarPanelAddon(this.base);
            if (this.target == null && this.targetingTicks < OMTConfigHandler.getTurretTargetSearchTicks()) {
                ++this.targetingTicks;
                return;
            }
            this.targetingTicks = 0;
            int power_required = Math.round((float)this.getTurretPowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
            if (this.base.getEnergyLevel(EnumFacing.DOWN) < power_required || !this.base.isActive()) {
                return;
            }
            if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || ((EntityLivingBase)this.target).func_110143_aJ() <= 0.0f) {
                this.target = this.getTargetWithMinRange();
            }
            if (this.target == null) {
                return;
            }
            this.yaw = TurretHeadUtil.getAimYaw(this.target, this.field_174879_c) + 3.2f;
            this.pitch = TurretHeadUtil.getAimPitch(this.target, this.field_174879_c);
            if ((float)this.ticks < (float)this.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base))) {
                return;
            }
            if (this.target != null && !TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target)) {
                this.target = null;
                return;
            }
            if (this.target instanceof EntityPlayerMP && PlayerUtil.isPlayerTrusted((EntityPlayer)(entity = (EntityPlayerMP)this.target), (ITrustedPlayersManager)this.base)) {
                this.target = null;
                return;
            }
            if (this.target != null && this.chebyshevDistance(this.target, this.base)) {
                this.target = null;
                return;
            }
            this.base.setEnergyStored(this.base.getEnergyLevel(EnumFacing.DOWN) - power_required);
            EntityLivingBase base = (EntityLivingBase)this.target;
            Vec3d basePositionToSet = new Vec3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.0f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
            base.func_70634_a(basePositionToSet.field_72450_a, basePositionToSet.field_72448_b, basePositionToSet.field_72449_c);
            ((BlockTeleporterTurret)this.func_145831_w().func_180495_p((BlockPos)this.field_174879_c).func_177230_c()).shouldAnimate = true;
            this.target = null;
        }
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), this.getLaunchSoundEffect(), SoundCategory.BLOCKS, 0.6f, 1.0f);
        this.ticks = 0;
    }

    @Override
    public int getTurretRange() {
        return OMTConfigHandler.getTeleporterTurretSettings().getRange();
    }

    @Override
    public int getTurretPowerUsage() {
        return OMTConfigHandler.getTeleporterTurretSettings().getPowerUsage();
    }

    @Override
    public int getTurretFireRate() {
        return OMTConfigHandler.getTeleporterTurretSettings().getFireRate();
    }

    @Override
    public double getTurretAccuracy() {
        return OMTConfigHandler.getTeleporterTurretSettings().getAccuracy();
    }

    @Override
    public double getTurretDamageAmpBonus() {
        return OMTConfigHandler.getTeleporterTurretSettings().getDamageAmp();
    }

    @Override
    public boolean requiresAmmo() {
        return false;
    }

    @Override
    public boolean requiresSpecificAmmo() {
        return false;
    }

    @Override
    public ItemStack getAmmo() {
        return null;
    }

    @Override
    public TurretProjectile createProjectile(World world, Entity target, ItemStack ammo) {
        return null;
    }

    @Override
    protected SoundEvent getLaunchSoundEffect() {
        return ModSounds.teleportLaunchSound;
    }
}

