/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.moddedminecraft.mmcrestrict.Main;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class Messages {
    private static Main plugin;
    public Path defaultMessage;
    private static final Pattern URL_PATTERN;
    public static ConfigurationLoader<CommentedConfigurationNode> messageLoader;
    public static CommentedConfigurationNode messages;
    public static boolean logToFile;
    public static List<String> sendToChestWhitelist;
    public static String bannedItemHover;
    public static String bannedItemExtraInfo;
    public static String bannedItemEdit;
    public static String bannedItemReason;
    public static String bannedItem;
    public static String bannedItemNonSet;
    public static String bannedListTitle;
    public static String bannedListPadding;
    public static String checkStarted;

    public Messages(Main main) throws IOException, ObjectMappingException {
        plugin = main;
        this.defaultMessage = Messages.plugin.ConfigDir.resolve("messages.conf");
        messageLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.defaultMessage)).build();
        messages = (CommentedConfigurationNode)messageLoader.load();
        this.messageCheck();
    }

    public void messageCheck() throws IOException, ObjectMappingException {
        if (!Files.exists(this.defaultMessage, new LinkOption[0])) {
            Files.createFile(this.defaultMessage, new FileAttribute[0]);
        }
        bannedListTitle = this.check(messages.getNode(new Object[]{"list", "title"}), bannedListTitle).getString();
        bannedListPadding = this.check(messages.getNode(new Object[]{"list", "padding"}), bannedListPadding).getString();
        bannedItemNonSet = this.check(messages.getNode(new Object[]{"list", "error", "non-set"}), bannedItemNonSet).getString();
        bannedItem = this.check(messages.getNode(new Object[]{"list", "formatting", "name"}), bannedItem).getString();
        bannedItemReason = this.check(messages.getNode(new Object[]{"list", "formatting", "reason"}), bannedItemReason).getString();
        bannedItemHover = this.check(messages.getNode(new Object[]{"list", "hover", "info"}), bannedItemHover).getString();
        bannedItemEdit = this.check(messages.getNode(new Object[]{"list", "hover", "edit"}), bannedItemEdit).getString();
        bannedItemExtraInfo = this.check(messages.getNode(new Object[]{"list", "hover", "extra"}), bannedItemExtraInfo).getString();
        checkStarted = this.check(messages.getNode(new Object[]{"commands", "checkchunks", "check-started"}), checkStarted).getString();
        messageLoader.save((ConfigurationNode)messages);
    }

    private CommentedConfigurationNode check(CommentedConfigurationNode node, Object defaultValue) {
        if (node.isVirtual()) {
            node.setValue(defaultValue);
        }
        return node;
    }

    public static Text parseMessage(String message, HashMap<String, String> args) {
        for (Map.Entry<String, String> arg : args.entrySet()) {
            message = message.replace("{" + arg.getKey() + "}", arg.getValue());
        }
        Text textMessage = TextSerializers.FORMATTING_CODE.deserialize(message);
        return textMessage;
    }

    static {
        URL_PATTERN = Pattern.compile("((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)", 2);
        bannedItemHover = "&cBanned methods &7- &6Use&7: {usebanned} &6Break&7: {breakbanned} &6Place&7: {placebanned} &6Own&7: {ownbanned} &6Craft&7: {craftbanned} &6World&7: {worldbanned}";
        bannedItemExtraInfo = "&7Id: {itemid}";
        bannedItemEdit = "&3Click to edit this item";
        bannedItemReason = " &3- &7{banreason}";
        bannedItem = "&3- &6{itemname}";
        bannedItemNonSet = "&eNo banned items have been set";
        bannedListTitle = "&6Banned List";
        bannedListPadding = "-";
        checkStarted = "Chunk searching has been initiated. All world banned items will be removed if found.";
    }
}

