/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.moddedminecraft.mmcrestrict.Commands.BanList;
import net.moddedminecraft.mmcrestrict.Commands.CheckChunks;
import net.moddedminecraft.mmcrestrict.Commands.Edit;
import net.moddedminecraft.mmcrestrict.Commands.Hand;
import net.moddedminecraft.mmcrestrict.Commands.Help;
import net.moddedminecraft.mmcrestrict.Commands.Remove;
import net.moddedminecraft.mmcrestrict.Commands.Search;
import net.moddedminecraft.mmcrestrict.Commands.Sendtochest;
import net.moddedminecraft.mmcrestrict.Commands.Whatsthis;
import net.moddedminecraft.mmcrestrict.Config.Config;
import net.moddedminecraft.mmcrestrict.Data.ItemData;
import net.moddedminecraft.mmcrestrict.EventListener;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.bstats.sponge.Metrics2;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;

@Plugin(id="mmcrestrict", name="MMCRestrict", version="1.6.3", description="A simple item restriction plugin", authors={"Leelawd93"})
public class Main {
    private static Main instance;
    private Game game;
    @Inject
    private Logger logger;
    @Inject
    private Metrics2 metrics;
    @Inject
    @DefaultConfig(sharedRoot=false)
    public Path defaultConf;
    @Inject
    @ConfigDir(sharedRoot=false)
    public Path ConfigDir;
    private CommandManager cmdManager = Sponge.getCommandManager();
    private Map<String, ItemData> items;
    private Config config;
    private Task autoPurgeTask = null;

    @Listener
    public void Init(GameInitializationEvent event) throws IOException, ObjectMappingException {
        instance = this;
        this.config = new Config(this);
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventListener(this));
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(ItemData.class), (TypeSerializer)new ItemData.ItemDataSerializer());
        this.loadCommands();
        this.loadData();
        this.startAutoPurge();
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.logger.info("Banned items loaded: " + this.items.size());
        this.logger.info("MMCRestrict Loaded");
    }

    public void startAutoPurge() {
        if (this.autoPurgeTask != null) {
            this.autoPurgeTask.cancel();
        }
        if (!Config.defaultAutoPurge.booleanValue()) {
            return;
        }
        this.autoPurgeTask = Task.builder().execute(new Runnable(){

            @Override
            public void run() {
                Main.this.checkLoadedChunks();
            }
        }).interval((long)Config.defaultAutoPurgeInterval.intValue(), TimeUnit.MINUTES).delay(5L, TimeUnit.MINUTES).async().name("mmcrestrict-a-bannedItemsAutoPurge").submit((Object)this);
        this.logger.info("MMCRestrict World AutoPurge Started (check chunks every " + Config.defaultAutoPurgeInterval + " minutes )");
    }

    @Listener
    public void onPluginReload(GameReloadEvent event) throws IOException, ObjectMappingException {
        this.config = new Config(this);
        this.loadData();
        this.startAutoPurge();
    }

    private void loadCommands() {
        CommandSpec itemAddHand = CommandSpec.builder().description((Text)Text.of((String)"Add item in hand to the banned items list")).executor((CommandExecutor)new Hand(this)).permission("mmcrestrict.commands.add").build();
        CommandSpec itemRemove = CommandSpec.builder().description((Text)Text.of((String)"Remove item manually from the banned items list")).executor((CommandExecutor)new Remove(this)).arguments(GenericArguments.string((Text)Text.of((String)"ItemID"))).permission("mmcrestrict.commands.remove").build();
        CommandSpec itemSearch = CommandSpec.builder().description((Text)Text.of((String)"Search for an item from the banned items list within the world")).executor((CommandExecutor)new Search(this)).arguments(GenericArguments.catalogedElement((Text)Text.of((String)"ItemID"), ItemType.class)).permission("mmcrestrict.commands.search").build();
        HashMap<String, String> choices = new HashMap<String, String>(){
            {
                this.put("reason", "reason");
                this.put("use", "use");
                this.put("break", "break");
                this.put("place", "place");
                this.put("own", "own");
                this.put("drop", "drop");
                this.put("craft", "craft");
                this.put("name", "name");
                this.put("world", "world");
            }
        };
        CommandSpec itemEdit = CommandSpec.builder().description((Text)Text.of((String)"Edit values on a banned item")).executor((CommandExecutor)new Edit(this)).arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"ItemID"))), GenericArguments.optional((CommandElement)GenericArguments.choices((Text)Text.of((String)"Option"), (Map)choices)), GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"True/False/Message")))}).permission("mmcrestrict.commands.edit").build();
        CommandSpec bannedList = CommandSpec.builder().description((Text)Text.of((String)"List the banned items")).executor((CommandExecutor)new BanList(this)).permission("mmcrestrict.commands.list").build();
        CommandSpec whatsThis = CommandSpec.builder().description((Text)Text.of((String)"Get the id of an item in hand")).executor((CommandExecutor)new Whatsthis(this)).permission("mmcrestrict.commands.whatsthis").build();
        CommandSpec checkChunks = CommandSpec.builder().description((Text)Text.of((String)"Search loaded chunks for banned blocks")).executor((CommandExecutor)new CheckChunks(this)).permission("mmcrestrict.commands.checkchunks").build();
        CommandSpec sendToChest = CommandSpec.builder().description((Text)Text.of((String)"Search loaded chunks for a block and put it in a chest")).executor((CommandExecutor)new Sendtochest(this)).arguments(GenericArguments.catalogedElement((Text)Text.of((String)"ItemID"), ItemType.class)).permission("mmcrestrict.commands.sendtochest").build();
        CommandSpec restrict = CommandSpec.builder().description((Text)Text.of((String)"Base restrict command")).executor((CommandExecutor)new Help(this)).child((CommandCallable)itemAddHand, new String[]{"add"}).child((CommandCallable)itemRemove, new String[]{"remove"}).child((CommandCallable)itemEdit, new String[]{"edit"}).child((CommandCallable)bannedList, new String[]{"list"}).child((CommandCallable)itemSearch, new String[]{"search"}).child((CommandCallable)whatsThis, new String[]{"whatsthis"}).child((CommandCallable)checkChunks, new String[]{"checkchunks"}).child((CommandCallable)sendToChest, new String[]{"sendtochest"}).build();
        this.cmdManager.register((Object)this, (CommandCallable)bannedList, new String[]{"banneditems"});
        this.cmdManager.register((Object)this, (CommandCallable)whatsThis, new String[]{"whatsthis"});
        this.cmdManager.register((Object)this, (CommandCallable)restrict, new String[]{"restrict"});
    }

    public HoconConfigurationLoader getItemDataLoader() {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.ConfigDir.resolve("Banneditems.conf"))).build();
    }

    private void loadData() throws IOException, ObjectMappingException {
        HoconConfigurationLoader loader = this.getItemDataLoader();
        ConfigurationNode rootNode = loader.load();
        List itemList = rootNode.getNode(new Object[]{"Items"}).getList(TypeToken.of(ItemData.class));
        this.items = new HashMap<String, ItemData>();
        for (ItemData item : itemList) {
            this.items.put(item.getItemid(), item);
        }
    }

    public void saveData() throws IOException, ObjectMappingException {
        HoconConfigurationLoader loader = this.getItemDataLoader();
        ConfigurationNode rootNode = loader.load();
        rootNode.getNode(new Object[]{"Items"}).setValue(ItemData.ItemDataSerializer.token, new ArrayList<ItemData>(this.items.values()));
        loader.save(rootNode);
    }

    public void checkChestItem(String itemID, String itemName, String playerName) {
        boolean itemExist = false;
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.getItemData());
        for (ItemData item : items) {
            if (!item.getItemid().equals(itemID)) continue;
            itemExist = true;
        }
        if (!itemExist) {
            this.addItem(new ItemData(itemID, itemName, Config.defaultReason, Config.defaultUsage, Config.defaultBreaking, Config.defaultPlacing, Config.defaultOwnership, Config.defaultDrop, Config.defaultCraft, Config.defaultWorld));
            this.logToFile("ban-list", playerName + " added " + itemName + " to the ban list");
        }
    }

    public void checkLoadedChunks() {
        final Collection loadedWorlds = Sponge.getServer().getWorlds();
        final ArrayList<ItemData> items = new ArrayList<ItemData>(this.getItemData());
        Sponge.getScheduler().createAsyncExecutor((Object)this).execute(new Runnable(){

            @Override
            public void run() {
                loadedWorlds.forEach(world -> {
                    Iterable loadedChunks = world.getLoadedChunks();
                    loadedChunks.forEach(chunk -> {
                        Vector3i min = chunk.getBlockMin();
                        Vector3i max = chunk.getBlockMax();
                        for (int x = min.getX(); x <= max.getX(); ++x) {
                            for (int y = min.getY(); y <= max.getY(); ++y) {
                                for (int z = min.getZ(); z <= max.getZ(); ++z) {
                                    BlockState block = chunk.getBlock(x, y, z);
                                    Location blockLoc = chunk.getLocation(x, y, z);
                                    for (ItemData item : items) {
                                        if (!item.getItemid().equals(block.getType().getId()) || !item.getWorldbanned().booleanValue()) continue;
                                        int finalX = x;
                                        int finalY = y;
                                        int finalZ = z;
                                        Sponge.getScheduler().createTaskBuilder().execute(() -> {
                                            blockLoc.setBlock(BlockTypes.AIR.getDefaultState());
                                            Main.this.logToFile("action-log", "Removed banned block:" + item.getItemname() + " at x:" + finalX + " y:" + finalY + " z:" + finalZ);
                                        }).submit(((PluginContainer)Sponge.getPluginManager().getPlugin("mmcrestrict").get()).getInstance().get());
                                    }
                                }
                            }
                        }
                    });
                });
            }
        });
    }

    public Collection<ItemData> getItemData() {
        return Collections.unmodifiableCollection(this.items.values());
    }

    public ItemData addItem(ItemData item) {
        return this.items.put(item.getItemid(), item);
    }

    public ItemData removeItem(String item) {
        return this.items.remove(item);
    }

    public Text fromLegacy(String legacy) {
        return TextSerializers.FORMATTING_CODE.deserializeUnchecked(legacy);
    }

    public boolean checkPerm(CommandSource src, String banType, String itemID) {
        return !src.hasPermission("mmcrestrict.bypass." + banType + "." + itemID.replace(":", "."));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void logToFile(String filename, String message) {
        if (Config.logToFile) {
            try {
                Path saveTo;
                if (!Files.exists(this.ConfigDir.resolve("logs"), new LinkOption[0])) {
                    Files.createDirectory(this.ConfigDir.resolve("logs"), new FileAttribute[0]);
                }
                if (!Files.exists(saveTo = this.ConfigDir.resolve("logs/" + filename + ".txt"), new LinkOption[0])) {
                    Files.createFile(saveTo, new FileAttribute[0]);
                }
                FileWriter fw = new FileWriter(saveTo.toFile(), true);
                PrintWriter pw = new PrintWriter(fw);
                pw.println(message);
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyOnlineStaff(Text message) {
        if (Config.notifyStaff.booleanValue()) {
            for (Player player : Sponge.getServer().getOnlinePlayers()) {
                if (!player.hasPermission("mmcrestrict.notify")) continue;
                Text.Builder send = Text.builder();
                send.append(new Text[]{message});
                player.sendMessage(send.build());
            }
        }
    }
}

