/*
 * Decompiled with CFR 0.152.
 */
package org.bstats.sponge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.apache.commons.lang3.Validate;
import org.bstats.sponge.Metrics;
import org.slf4j.Logger;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;

public class Metrics2
implements Metrics {
    public static final int B_STATS_VERSION = 1;
    public static final int B_STATS_CLASS_REVISION = 2;
    private static final String URL = "https://bStats.org/submitData/sponge";
    private Logger logger;
    private final PluginContainer plugin;
    private String serverUUID;
    private boolean logFailedRequests = false;
    private static boolean logSentData;
    private static boolean logResponseStatusText;
    private final List<Metrics> knownMetricsInstances = new CopyOnWriteArrayList<Metrics>();
    private final List<CustomChart> charts = new ArrayList<CustomChart>();
    private Path configDir;
    private List<Object> oldInstances = new ArrayList<Object>();
    private TimerTask timerTask;

    @Inject
    private Metrics2(PluginContainer plugin, Logger logger, @ConfigDir(sharedRoot=true) Path configDir) {
        this.plugin = plugin;
        this.logger = logger;
        this.configDir = configDir;
        Sponge.getEventManager().registerListeners((Object)plugin, (Object)this);
    }

    @Listener
    public void startup(GamePreInitializationEvent event) {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.logger.warn("Failed to load bStats config!", (Throwable)e);
            return;
        }
        if (Sponge.getServiceManager().isRegistered(Metrics.class)) {
            Metrics provider = (Metrics)Sponge.getServiceManager().provideUnchecked(Metrics.class);
            provider.linkMetrics(this);
        } else {
            Sponge.getServiceManager().setProvider(this.plugin.getInstance().get(), Metrics.class, (Object)this);
            this.linkMetrics(this);
            this.startSubmitting();
        }
    }

    @Override
    public void cancel() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    @Override
    public List<Metrics> getKnownMetricsInstances() {
        return this.knownMetricsInstances;
    }

    @Override
    public PluginContainer getPluginContainer() {
        return this.plugin;
    }

    @Override
    public int getRevision() {
        return 2;
    }

    private void linkOldMetrics(Object metrics) {
        try {
            Field field = metrics.getClass().getDeclaredField("plugin");
            field.setAccessible(true);
            PluginContainer plugin = (PluginContainer)field.get(metrics);
            Method method = metrics.getClass().getMethod("getPluginData", new Class[0]);
            this.linkMetrics(new OutdatedInstance(metrics, method, plugin));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public void linkMetrics(Metrics metrics) {
        this.knownMetricsInstances.add(metrics);
    }

    public void addCustomChart(CustomChart chart) {
        Validate.notNull((Object)chart, (String)"Chart cannot be null", (Object[])new Object[0]);
        this.charts.add(chart);
    }

    @Override
    public JsonObject getPluginData() {
        JsonObject data = new JsonObject();
        String pluginName = this.plugin.getName();
        String pluginVersion = this.plugin.getVersion().orElse("unknown");
        int revision = this.getRevision();
        data.addProperty("pluginName", pluginName);
        data.addProperty("pluginVersion", pluginVersion);
        data.addProperty("metricsRevision", (Number)revision);
        JsonArray customCharts = new JsonArray();
        for (CustomChart customChart : this.charts) {
            JsonObject chart = customChart.getRequestJsonObject(this.logger, this.logFailedRequests);
            if (chart == null) continue;
            customCharts.add((JsonElement)chart);
        }
        data.add("customCharts", (JsonElement)customCharts);
        return data;
    }

    private void startSubmitting() {
        block15: {
            try {
                Path configPath = this.configDir.resolve("bStats");
                configPath.toFile().mkdirs();
                String className = this.readFile(new File(configPath.toFile(), "temp.txt"));
                if (className == null) break block15;
                try {
                    Class<?> clazz = Class.forName(className);
                    Field instancesField = clazz.getDeclaredField("knownMetricsInstances");
                    instancesField.setAccessible(true);
                    this.oldInstances = (List)instancesField.get(null);
                    for (Object instance : this.oldInstances) {
                        this.linkOldMetrics(instance);
                    }
                    this.oldInstances.clear();
                    Map<Thread, StackTraceElement[]> threadSet = Thread.getAllStackTraces();
                    for (Map.Entry<Thread, StackTraceElement[]> entry : threadSet.entrySet()) {
                        try {
                            Object[] tasks;
                            if (!entry.getKey().getName().startsWith("Timer")) continue;
                            Field timerThreadField = entry.getKey().getClass().getDeclaredField("queue");
                            timerThreadField.setAccessible(true);
                            Object taskQueue = timerThreadField.get(entry.getKey());
                            Field taskQueueField = taskQueue.getClass().getDeclaredField("queue");
                            taskQueueField.setAccessible(true);
                            for (Object task : tasks = (Object[])taskQueueField.get(taskQueue)) {
                                if (task == null || !task.getClass().getName().startsWith(clazz.getName())) continue;
                                ((TimerTask)task).cancel();
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                catch (ReflectiveOperationException clazz) {
                }
            }
            catch (IOException configPath) {
                // empty catch block
            }
        }
        Timer timer = new Timer(true);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                for (Object instance : Metrics2.this.oldInstances) {
                    Metrics2.this.linkOldMetrics(instance);
                }
                Metrics2.this.oldInstances.clear();
                Scheduler scheduler = Sponge.getScheduler();
                Task.Builder taskBuilder = scheduler.createTaskBuilder();
                taskBuilder.execute(() -> Metrics2.this.submitData()).submit((Object)Metrics2.this.plugin);
            }
        };
        timer.scheduleAtFixedRate(this.timerTask, 300000L, 1800000L);
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        for (Metrics metrics : this.knownMetricsInstances) {
            if (Sponge.getMetricsConfigManager().areMetricsEnabled(metrics.getPluginContainer())) {
                enabled.add(metrics.getPluginContainer().getName());
                continue;
            }
            disabled.add(metrics.getPluginContainer().getName());
        }
        StringBuilder builder = new StringBuilder().append(System.lineSeparator());
        builder.append("bStats metrics is present in ").append(enabled.size() + disabled.size()).append(" plugins on this server.");
        builder.append(System.lineSeparator());
        if (enabled.isEmpty()) {
            builder.append("Presently, none of them are allowed to send data.").append(System.lineSeparator());
        } else {
            builder.append("Presently, the following ").append(enabled.size()).append(" plugins are allowed to send data:").append(System.lineSeparator());
            builder.append(((Object)enabled).toString()).append(System.lineSeparator());
        }
        if (disabled.isEmpty()) {
            builder.append("None of them have data sending disabled.");
            builder.append(System.lineSeparator());
        } else {
            builder.append("Presently, the following ").append(disabled.size()).append(" plugins are not allowed to send data:").append(System.lineSeparator());
            builder.append(((Object)disabled).toString()).append(System.lineSeparator());
        }
        builder.append("To change the enabled/disabled state of any bStats use in a plugin, visit the Sponge config!");
        this.logger.info(builder.toString());
    }

    private JsonObject getServerData() {
        int playerAmount = Sponge.getServer().getOnlinePlayers().size();
        playerAmount = playerAmount > 200 ? 200 : playerAmount;
        int onlineMode = Sponge.getServer().getOnlineMode() ? 1 : 0;
        String minecraftVersion = Sponge.getGame().getPlatform().getMinecraftVersion().getName();
        String spongeImplementation = Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName();
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        JsonObject data = new JsonObject();
        data.addProperty("serverUUID", this.serverUUID);
        data.addProperty("playerAmount", (Number)playerAmount);
        data.addProperty("onlineMode", (Number)onlineMode);
        data.addProperty("minecraftVersion", minecraftVersion);
        data.addProperty("spongeImplementation", spongeImplementation);
        data.addProperty("javaVersion", javaVersion);
        data.addProperty("osName", osName);
        data.addProperty("osArch", osArch);
        data.addProperty("osVersion", osVersion);
        data.addProperty("coreCount", (Number)coreCount);
        return data;
    }

    private void submitData() {
        JsonObject data = this.getServerData();
        JsonArray pluginData = new JsonArray();
        for (Metrics metrics : this.knownMetricsInstances) {
            JsonObject plugin;
            if (!Sponge.getMetricsConfigManager().areMetricsEnabled(metrics.getPluginContainer()) || (plugin = metrics.getPluginData()) == null) continue;
            pluginData.add((JsonElement)plugin);
        }
        if (pluginData.size() == 0) {
            return;
        }
        data.add("plugins", (JsonElement)pluginData);
        new Thread(() -> {
            block2: {
                try {
                    Metrics2.sendData(this.logger, data);
                }
                catch (Exception e) {
                    if (!this.logFailedRequests) break block2;
                    this.logger.warn("Could not submit plugin stats!", (Throwable)e);
                }
            }
        }).start();
    }

    private void loadConfig() throws IOException {
        CommentedConfigurationNode node;
        Path configPath = this.configDir.resolve("bStats");
        configPath.toFile().mkdirs();
        File configFile = new File(configPath.toFile(), "config.conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
        if (!configFile.exists()) {
            configFile.createNewFile();
            node = (CommentedConfigurationNode)configurationLoader.load();
            node.getNode(new Object[]{"enabled"}).setValue((Object)false);
            node.getNode(new Object[]{"serverUuid"}).setValue((Object)UUID.randomUUID().toString());
            node.getNode(new Object[]{"logFailedRequests"}).setValue((Object)false);
            node.getNode(new Object[]{"logSentData"}).setValue((Object)false);
            node.getNode(new Object[]{"logResponseStatusText"}).setValue((Object)false);
            node.getNode(new Object[]{"enabled"}).setComment("Enabling bStats in this file is deprecated. At least one of your plugins now uses the\nSponge config to control bStats. Leave this value as you want it to be for outdated plugins,\nbut look there for further control");
            node.getNode(new Object[]{"serverUuid"}).setComment("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo control whether this is enabled or disabled, see the Sponge configuration file.\nCheck out https://bStats.org/ to learn more :)");
            node.getNode(new Object[]{"configVersion"}).setValue((Object)2);
            configurationLoader.save((ConfigurationNode)node);
        } else {
            node = (CommentedConfigurationNode)configurationLoader.load();
            if (!node.getNode(new Object[]{"configVersion"}).isVirtual()) {
                node.getNode(new Object[]{"configVersion"}).setValue((Object)2);
                node.getNode(new Object[]{"enabled"}).setComment("Enabling bStats in this file is deprecated. At least one of your plugins now uses the\nSponge config to control bStats. Leave this value as you want it to be for outdated plugins,\nbut look there for further control");
                node.getNode(new Object[]{"serverUuid"}).setComment("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo control whether this is enabled or disabled, see the Sponge configuration file.\nCheck out https://bStats.org/ to learn more :)");
                configurationLoader.save((ConfigurationNode)node);
            }
        }
        this.serverUUID = node.getNode(new Object[]{"serverUuid"}).getString();
        this.logFailedRequests = node.getNode(new Object[]{"logFailedRequests"}).getBoolean(false);
        logSentData = node.getNode(new Object[]{"logSentData"}).getBoolean(false);
        logResponseStatusText = node.getNode(new Object[]{"logResponseStatusText"}).getBoolean(false);
    }

    /*
     * Exception decompiling
     */
    private String readFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void sendData(Logger logger, JsonObject data) throws Exception {
        String line;
        Validate.notNull((Object)data, (String)"Data cannot be null", (Object[])new Object[0]);
        if (logSentData) {
            logger.info("Sending data to bStats: {}", (Object)data.toString());
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = Metrics2.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        InputStream inputStream = connection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder builder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            builder.append(line);
        }
        bufferedReader.close();
        if (logResponseStatusText) {
            logger.info("Sent data to bStats and received response: {}", (Object)builder.toString());
        }
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.close();
        return outputStream.toByteArray();
    }

    static {
        String defaultName = "org:bstats:sponge:Metrics".replace(":", ".");
        if (!Metrics.class.getName().equals(defaultName)) {
            throw new IllegalStateException("bStats Metrics interface has been relocated or renamed and will not be run!");
        }
        if (!Metrics2.class.getName().equals(defaultName + "2")) {
            throw new IllegalStateException("bStats Metrics2 class has been relocated or renamed and will not be run!");
        }
    }

    public static class AdvancedBarChart
    extends CustomChart {
        private final Callable<Map<String, int[]>> callable;

        public AdvancedBarChart(String chartId, Callable<Map<String, int[]>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                allSkipped = false;
                JsonArray categoryValues = new JsonArray();
                for (int categoryValue : entry.getValue()) {
                    categoryValues.add((JsonElement)new JsonPrimitive((Number)categoryValue));
                }
                values.add(entry.getKey(), (JsonElement)categoryValues);
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static class SimpleBarChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public SimpleBarChart(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                JsonArray categoryValues = new JsonArray();
                categoryValues.add((JsonElement)new JsonPrimitive((Number)entry.getValue()));
                values.add(entry.getKey(), (JsonElement)categoryValues);
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String chartId, Callable<Integer> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            int value = this.callable.call();
            if (value == 0) {
                return null;
            }
            data.addProperty("value", (Number)value);
            return data;
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String chartId, Callable<Map<String, Map<String, Integer>>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        public JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean reallyAllSkipped = true;
            for (Map.Entry<String, Map<String, Integer>> entryValues : map.entrySet()) {
                JsonObject value = new JsonObject();
                boolean allSkipped = true;
                for (Map.Entry<String, Integer> valueEntry : map.get(entryValues.getKey()).entrySet()) {
                    value.addProperty(valueEntry.getKey(), (Number)valueEntry.getValue());
                    allSkipped = false;
                }
                if (allSkipped) continue;
                reallyAllSkipped = false;
                values.add(entryValues.getKey(), (JsonElement)value);
            }
            if (reallyAllSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String chartId, Callable<String> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() throws Exception {
            JsonObject data = new JsonObject();
            String value = this.callable.call();
            if (value == null || value.isEmpty()) {
                return null;
            }
            data.addProperty("value", value);
            return data;
        }
    }

    public static abstract class CustomChart {
        private final String chartId;

        CustomChart(String chartId) {
            if (chartId == null || chartId.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = chartId;
        }

        private JsonObject getRequestJsonObject(Logger logger, boolean logFailedRequests) {
            JsonObject chart = new JsonObject();
            chart.addProperty("chartId", this.chartId);
            try {
                JsonObject data = this.getChartData();
                if (data == null) {
                    return null;
                }
                chart.add("data", (JsonElement)data);
            }
            catch (Throwable t) {
                if (logFailedRequests) {
                    logger.warn("Failed to get data for custom chart with id {}", (Object)this.chartId, (Object)t);
                }
                return null;
            }
            return chart;
        }

        protected abstract JsonObject getChartData() throws Exception;
    }

    private static class OutdatedInstance
    implements Metrics {
        private Object instance;
        private Method method;
        private PluginContainer plugin;

        private OutdatedInstance(Object instance, Method method, PluginContainer plugin) {
            this.instance = instance;
            this.method = method;
            this.plugin = plugin;
        }

        @Override
        public void cancel() {
        }

        @Override
        public List<Metrics> getKnownMetricsInstances() {
            return new ArrayList<Metrics>();
        }

        @Override
        public JsonObject getPluginData() {
            try {
                return (JsonObject)this.method.invoke(this.instance, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException exception) {
                return null;
            }
        }

        @Override
        public PluginContainer getPluginContainer() {
            return this.plugin;
        }

        @Override
        public int getRevision() {
            return 0;
        }

        @Override
        public void linkMetrics(Metrics metrics) {
        }
    }
}

