/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.dimension.IProviderFreeze;
import asmodeuscore.api.item.IItemPressurized;
import asmodeuscore.api.item.IItemSpaceFood;
import asmodeuscore.core.event.PressureEvent;
import asmodeuscore.core.event.RadiationEvent;
import asmodeuscore.core.handler.LightningStormHandler;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.SetBlockEvent;
import galaxyspace.core.prefab.items.rockets.ItemTier4Rocket;
import galaxyspace.core.prefab.items.rockets.ItemTier5Rocket;
import galaxyspace.core.prefab.items.rockets.ItemTier6Rocket;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSDamageSource;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPlanetShield;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.api.inventory.AccessInventoryGC;
import micdoodle8.mods.galacticraft.api.inventory.IInventoryGC;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemTier1Rocket;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.items.ItemTier2Rocket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class GSEventHandler {
    private static List<BlockToChange> block_to_change = new ArrayList<BlockToChange>();
    private static List<ItemsToChange> items_to_change = new ArrayList<ItemsToChange>();

    @SubscribeEvent
    public void onFall(LivingFallEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            ItemStack chest = ((EntityPlayer)e.getEntityLiving()).func_184582_a(EntityEquipmentSlot.CHEST);
            e.setCanceled(chest != null && chest.func_77973_b() instanceof IJetpackArmor && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, (EntityPlayer)e.getEntityLiving()) && ((IJetpackArmor)chest.func_77973_b()).isActivated(chest));
        }
    }

    @SubscribeEvent
    public void onSetBlock(SetBlockEvent e) {
        if (!e.world.field_72995_K && e.world.field_73011_w instanceof IGalacticraftWorldProvider) {
            float thermal = ((IGalacticraftWorldProvider)e.world.field_73011_w).getThermalLevelModifier();
            AxisAlignedBB bb = new AxisAlignedBB((double)(e.pos.func_177958_n() - 1), (double)(e.pos.func_177956_o() - 1), (double)(e.pos.func_177952_p() - 1), (double)(e.pos.func_177958_n() + 1), (double)(e.pos.func_177956_o() + 2), (double)(e.pos.func_177952_p() + 1));
            for (BlockToChange block : block_to_change) {
                if (block.only_gs_dim && !(e.world.field_73011_w instanceof IProviderFreeze)) continue;
                if (block.need_check_temp) {
                    if (e.block != block.state && e.block.func_185904_a() != block.state.func_185904_a() || OxygenUtil.isAABBInBreathableAirBlock((World)e.world, (AxisAlignedBB)bb, (boolean)true)) continue;
                    if (thermal <= -1.0f) {
                        e.world.func_175656_a(e.pos, block.cold_replaced);
                        e.setCanceled(true);
                        continue;
                    }
                    if (!(thermal >= 1.5f)) continue;
                    e.world.func_175656_a(e.pos, block.hot_replaced);
                    block.spawnParticleHotTemp(e.world, e.pos);
                    e.setCanceled(true);
                    continue;
                }
                e.world.func_175656_a(e.pos, block.cold_replaced);
                block.spawnParticleHotTemp(e.world, e.pos);
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_71071_by == null || event.getPos() == null || event.getPos().func_177958_n() == 0 && event.getPos().func_177956_o() == 0 && event.getPos().func_177952_p() == 0) {
            return;
        }
        World world = event.getEntityPlayer().field_70170_p;
        if (world == null) {
            return;
        }
        Block block = world.func_180495_p(event.getPos()).func_177230_c();
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (!world.field_72995_K && GSConfigCore.enableHardMode) {
            if (block == Blocks.field_150432_aD && stack.func_77973_b() instanceof ItemBucket) {
                stack.func_190918_g(1);
                player.field_71071_by.func_70441_a(new ItemStack(GSItems.BASIC, 1, 17));
                world.func_175698_g(event.getPos());
            }
            if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
                AxisAlignedBB bb = new AxisAlignedBB(event.getPos().func_177984_a());
                float thermal = ((IGalacticraftWorldProvider)world.field_73011_w).getThermalLevelModifier();
                for (ItemsToChange ore : items_to_change) {
                    if (!stack.func_77973_b().equals(ore.itemstack.func_77973_b())) continue;
                    if (ore.need_check_temp) {
                        if (thermal < -1.0f || thermal >= 1.5f && !OxygenUtil.isAABBInBreathableAirBlock((World)world, (AxisAlignedBB)bb, (boolean)true)) {
                            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needoxygenthermal")));
                            event.setCanceled(true);
                        }
                    } else if (!OxygenUtil.isAABBInBreathableAirBlock((World)world, (AxisAlignedBB)bb, (boolean)false)) {
                        player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needoxygen")));
                        event.setCanceled(true);
                    }
                    if (ore.replaced == Blocks.field_150350_a.func_176223_P()) break;
                    if (world.func_180495_p(event.getPos()).func_177230_c().func_176200_f((IBlockAccess)world, event.getPos())) {
                        world.func_175656_a(event.getPos(), ore.replaced);
                        break;
                    }
                    world.func_175656_a(event.getPos().func_177984_a(), ore.replaced);
                    break;
                }
                if (stack.func_77973_b() instanceof ItemSeeds && world.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150458_ak && !OxygenUtil.isAABBInBreathableAirBlock((World)world, (AxisAlignedBB)bb, (boolean)true)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needoxygenthermal")));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent event) {
        World world = event.getWorld();
        if (world == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack i = event.getItemStack();
        if (!world.field_72995_K && GalaxySpace.debug) {
            GalaxySpace.debug(Item.field_150901_e.func_177774_c((Object)i.func_77973_b()) + "");
        }
        if (!world.field_72995_K && GSConfigCore.enableHardMode && !player.field_71075_bZ.field_75098_d && world.field_73011_w instanceof IGalacticraftWorldProvider && !((IGalacticraftWorldProvider)world.field_73011_w).hasBreathableAtmosphere() && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player, (boolean)false) && this.checkFood(i)) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.needoxygen.food")));
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setCanceled(true);
        }
    }

    private boolean checkFood(ItemStack s) {
        return !s.func_190926_b() && s.func_77973_b() instanceof ItemFood && !(s.func_77973_b() instanceof micdoodle8.mods.galacticraft.core.items.ItemFood) && !(s.func_77973_b() instanceof IItemSpaceFood);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        EntityLivingBase living = event.getEntityLiving();
        World world = living.field_70170_p;
        if (living instanceof EntityPlayer) {
            Object held;
            player = (EntityPlayer)living;
            ItemStack chest = ((EntityPlayer)living).func_184582_a(EntityEquipmentSlot.CHEST);
            if (chest != null && chest.func_77973_b() instanceof IJetpackArmor && !((EntityPlayer)living).field_70122_E && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, (EntityPlayer)living) && ((IJetpackArmor)chest.func_77973_b()).isActivated(chest) && ((EntityPlayer)living).field_70163_u < 256.0) {
                ((EntityPlayer)living).field_70143_R = 0.0f;
                ((EntityPlayer)living).field_70140_Q = 0.6f;
                GalaxySpace.proxy.resetPlayerInAirTime((EntityPlayer)living);
                ((IJetpackArmor)chest.func_77973_b()).decrementFuel(chest);
            }
            if (!player.field_71075_bZ.field_75098_d && ((held = player.func_184614_ca()).func_77973_b() instanceof ItemTier1Rocket || held.func_77973_b() instanceof ItemTier2Rocket || held.func_77973_b() instanceof ItemTier3Rocket || held.func_77973_b() instanceof ItemTier4Rocket || held.func_77973_b() instanceof ItemTier5Rocket || held.func_77973_b() instanceof ItemTier6Rocket)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 4));
            }
        }
        if (living instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)living;
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            LightningStormHandler.spawnLightning((EntityPlayerMP)player);
            this.updateSchematics((EntityPlayerMP)player, stats);
            if (world.field_73012_v.nextInt(50) <= 10) {
                if (!GSEventHandler.getProtectArmor((EntityPlayerMP)player) && world.field_73011_w instanceof WorldProviderTitan && world.func_72896_J() && world.func_175710_j(player.func_180425_c())) {
                    player.func_70097_a((DamageSource)GSDamageSource.acid, 1.5f);
                }
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderKuiperBelt && player.field_70163_u <= -20.0) {
                player.field_71135_a.func_147364_a(player.field_70165_t, 188.0, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            }
            if (!player.field_71075_bZ.field_75098_d && player.func_110143_aJ() <= 5.0f) {
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    int[] pos;
                    if (stack.func_77973_b() != GSItems.BASIC || stack.func_77952_i() != 18) continue;
                    if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("turnonoff") || (pos = stack.func_77978_p().func_74759_k("position")) == null || pos.length < 3 || player.field_70170_p.field_73011_w.getDimension() != pos[3]) break;
                    player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.AQUA + GCCoreUtil.translateWithFormat((String)"gui.message.emergency_teleport", (Object[])new Object[0]) + " x:" + pos[0] + " y:" + pos[1] + " z:" + pos[2]));
                    player.field_71135_a.func_147364_a((double)pos[0], (double)pos[1], (double)pos[2], player.field_70177_z, player.field_70125_A);
                    stack.func_190918_g(1);
                    break;
                }
            }
            if (stats.getShieldControllerInSlot().func_77969_a(new ItemStack(GSItems.BASIC, 1, 16))) {
                ItemStack shield = stats.getShieldControllerInSlot();
                if (shield.func_77942_o()) {
                    int shieldtime = shield.func_77978_p().func_74762_e("shieldtime");
                    if (!player.field_71075_bZ.field_75098_d && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getCelestialBody().atmosphere.isCorrosive()) {
                        if (shieldtime >= 1) {
                            if (player.field_70173_aa % 20 == 0) {
                                shield.func_77978_p().func_74768_a("shieldtime", --shieldtime);
                            }
                        } else {
                            shield.func_190918_g(1);
                            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translateWithFormat((String)"gui.message.now_noshield", (Object[])new Object[0])));
                        }
                    }
                } else {
                    shield.func_77982_d(new NBTTagCompound());
                    shield.func_77978_p().func_74768_a("shieldtime", ItemBasicGS.SHIELD_TIME);
                }
                int gearID = GalacticraftRegistry.findMatchingGearID((ItemStack)stats.getShieldControllerInSlot(), (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER);
                if (gearID >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket((EntityPlayerMP)player, (GCPlayerHandler.EnumModelPacketType)GCPlayerHandler.EnumModelPacketType.ADD, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER, (int)gearID);
                }
            }
            stats.setLastShieldControllerInSlot(stats.getShieldControllerInSlot());
            ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
            IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
            if (!stack.func_190926_b() && stack.func_77973_b() == GSItems.SPACE_SUIT_HELMET && player.func_70090_H()) {
                int count = 150;
                int air = player.func_70086_ai();
                for (int i = 2; i <= 3; ++i) {
                    if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77952_i() == inv.func_70301_a(i).func_77958_k()) continue;
                    if (air >= count) break;
                    player.func_70050_g(air + count);
                    inv.func_70301_a(i).func_77964_b(inv.func_70301_a(i).func_77952_i() + 1);
                    break;
                }
            }
            if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player)) {
                for (int i = 2; i <= 3; ++i) {
                    ItemStack tank;
                    if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77973_b() != GSItems.OXYGENTANK_TIER_EPP && (!inv.func_70301_a(i).func_77942_o() || !inv.func_70301_a(i).func_77978_p().func_74764_b("epp")) || (tank = inv.func_70301_a(i)).func_77952_i() == 0 || player.field_70173_aa % 10 != 0) continue;
                    tank.func_77964_b(tank.func_77952_i() - 2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlanetDecorated(GCCoreEventPopulate.Post event) {
        if (event.world.field_73011_w instanceof WorldProviderMars) {
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 4, 0, true, MarsBlocks.marsBlock, 9), 6, 4, 18);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 6, 1, true, MarsBlocks.marsBlock, 9), 10, 6, 30);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 16, 2, true, MarsBlocks.marsBlock, 9), 15, 6, 70);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 10, 3, true, MarsBlocks.marsBlock, 9), 10, 6, 20);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 8, 4, true, MarsBlocks.marsBlock, 9), 4, 6, 20);
            this.genOre(event.world, event.pos, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MARS_ORES, 6, 5, true, MarsBlocks.marsBlock, 9), 16, 6, 45);
        }
    }

    void genOre(World world, BlockPos pos, WorldGenerator wg, int amountPerChunk, int minY, int maxY) {
        BlockPos pos1 = pos.func_177982_a(world.field_73012_v.nextInt(16), world.field_73012_v.nextInt(maxY - minY) + minY, world.field_73012_v.nextInt(16));
        for (int i = 0; i < amountPerChunk; ++i) {
            wg.func_180709_b(world, world.field_73012_v, pos1);
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public void onRadiation(RadiationEvent event) {
        block2: {
            living = (EntityLivingBase)event.getEntity();
            if (!(living instanceof EntityPlayerMP)) break block2;
            player = (EntityPlayerMP)living;
            if (!GSConfigCore.enableRadiationSystem) ** GOTO lbl-1000
            if (GSEventHandler.getProtectArmor(player) || player.func_184187_bx() instanceof EntityLanderBase || player.func_184187_bx() instanceof EntityTieredRocket) ** GOTO lbl-1000
            if (GSEventHandler.inRadiationBubble(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v)) lbl-1000:
            // 3 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            event.setCanceled(v0);
        }
    }

    @SubscribeEvent
    public void onPressure(PressureEvent event) {
        EntityLivingBase living = (EntityLivingBase)event.getEntity();
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            World world = player.func_130014_f_();
            int level = event.getPressureLevel();
            if (!player.field_71075_bZ.field_75098_d && GSConfigCore.enablePressureSystem) {
                if (!GSEventHandler.getPressureArmor(player)) {
                    if (!GSEventHandler.getProtectArmor(player)) {
                        if (!GSEventHandler.inGravityZone(world, (EntityPlayer)player, true) && player.field_70173_aa % 50 == 0) {
                            if (level > 10) {
                                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200));
                            }
                            if (level > 35) {
                                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
                            }
                            if (level > 25) {
                                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 280, 4));
                            }
                            if (level > 45) {
                                player.func_70097_a((DamageSource)GSDamageSource.pressure, 2.5f);
                            }
                        }
                    }
                }
            }
        }
    }

    public static boolean getProtectArmor(EntityPlayerMP player) {
        boolean[] check = new boolean[4];
        boolean flag = false;
        for (String string : GSConfigCore.radiation_armor) {
            int i;
            String[] meta = string.split(":");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (meta.length > 2) {
                for (i = 0; i <= 3; ++i) {
                    ItemStack itemstack = new ItemStack(item, 1, Integer.parseInt(meta[2]));
                    boolean bl = check[i] = !((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() && player.field_71071_by.field_70460_b.get(i) == itemstack;
                    if (!check[i]) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i <= 3; ++i) {
                    boolean bl = check[i] = !((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() == item;
                    if (!check[i]) {
                        continue;
                    }
                    break;
                }
            }
            if (check[0] && check[1] && check[2] && check[3]) break;
        }
        return check[0] && check[1] && check[2] && check[3];
    }

    public static boolean getPressureArmor(EntityPlayerMP player) {
        boolean armor1 = !((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77973_b() instanceof IItemPressurized;
        boolean armor2 = !((ItemStack)player.field_71071_by.field_70460_b.get(1)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(1)).func_77973_b() instanceof IItemPressurized;
        boolean armor3 = !((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b() instanceof IItemPressurized;
        boolean armor4 = !((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b() instanceof IItemPressurized;
        return armor1 && armor2 && armor3 && armor4;
    }

    public static boolean inGravityZone(World world, EntityPlayer player, boolean checkStabilisationModule) {
        for (BlockVec3Dim blockVec : TileEntityGravitationModule.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.getDimension() || !((tile = world.func_175625_s(blockVec.toBlockPos())) instanceof TileEntityGravitationModule)) continue;
            TileEntityGravitationModule gravity = (TileEntityGravitationModule)tile;
            if (gravity.disabled || !gravity.hasEnoughEnergyToRun || !gravity.inGravityZone(world, player)) continue;
            if (!checkStabilisationModule) {
                return true;
            }
            if (!checkStabilisationModule) continue;
            boolean check = false;
            for (int i = 0; i < 4; ++i) {
                if (!gravity.func_70301_a(i + 1).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 1))) continue;
                check = true;
                break;
            }
            return check;
        }
        return false;
    }

    public static boolean inRadiationBubble(World world, double avgX, double avgY, double avgZ) {
        for (BlockVec3Dim blockVec : TileEntityRadiationStabiliser.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.getDimension() || !((tile = world.func_175625_s(blockVec.toBlockPos())) instanceof TileEntityRadiationStabiliser) || !((TileEntityRadiationStabiliser)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }

    public static boolean inShieldBubble(World world, double avgX, double avgY, double avgZ) {
        for (BlockVec3Dim blockVec : TileEntityPlanetShield.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.getDimension() || !((tile = world.func_175625_s(blockVec.toBlockPos())) instanceof TileEntityPlanetShield) || !((TileEntityPlanetShield)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeItemStack(IInventory inventory, ItemStack stack) {
        if (GSEventHandler.getAmount(inventory, stack) >= stack.func_190916_E()) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!GSEventHandler.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
                int amount = Math.min(stack.func_190916_E(), inventory.func_70301_a(i).func_190916_E());
                if (amount > 0) {
                    inventory.func_70301_a(i).func_190918_g(amount);
                    if (inventory.func_70301_a(i).func_190916_E() <= 0) {
                        inventory.func_70299_a(i, ItemStack.field_190927_a);
                    }
                    stack.func_190918_g(amount);
                }
                if (stack.func_190916_E() > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getAmount(IInventory inventory, ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!GSEventHandler.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
            amount += inventory.func_70301_a(i).func_190916_E();
        }
        return amount;
    }

    public static boolean isItemStackEqual(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i();
    }

    protected void updateSchematics(EntityPlayerMP player, GCPlayerStats playerStats) {
    }

    public static void enableFlight(EntityPlayer player, boolean state) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chest != null && chest.func_77973_b() instanceof IJetpackArmor) {
            ((IJetpackArmor)chest.func_77973_b()).switchState(chest, state);
        }
    }

    protected void throwMeteors(EntityPlayerMP player) {
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof IAdvancedSpace && !world.field_72995_K && ((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() > 0.0 && ConfigManagerCore.meteorSpawnMod > 0.0) {
            EntityPlayer closestPlayer;
            boolean f = true;
            if (world.field_73012_v.nextInt(1) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                int x = world.field_73012_v.nextInt(1) - 8;
                int y = world.field_73012_v.nextInt(20) + 200;
                int z = world.field_73012_v.nextInt(1) - 8;
                double motX = world.field_73012_v.nextDouble() * 1.0;
                double motZ = world.field_73012_v.nextDouble() * 1.0;
                EntityMeteor meteor = new EntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 0.5, 0.0, motZ - 0.5, 1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
        }
    }

    static {
        OreDictionary.getOres((String)"treeLeaves").forEach(stack -> items_to_change.add(new ItemsToChange((ItemStack)stack, Blocks.field_150350_a.func_176223_P(), true)));
        OreDictionary.getOres((String)"treeSapling").forEach(stack -> items_to_change.add(new ItemsToChange((ItemStack)stack, Blocks.field_150330_I.func_176223_P(), true)));
        items_to_change.add(new ItemsToChange(new ItemStack(Items.field_151131_as), Blocks.field_150350_a.func_176223_P(), true));
        block_to_change.add(new BlockToChange(Blocks.field_150355_j.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), 0.0f, true).setParticle("waterbubbles"));
    }

    private static class ItemsToChange {
        private ItemStack itemstack = ItemStack.field_190927_a;
        private IBlockState replaced;
        private boolean need_check_temp;
        private boolean only_gs_dim = false;

        ItemsToChange(ItemStack stack, IBlockState placed, boolean need_check_temp) {
            this.itemstack = stack;
            this.replaced = placed;
            this.need_check_temp = need_check_temp;
        }

        public ItemsToChange setOnlyGSDim() {
            this.only_gs_dim = true;
            return this;
        }
    }

    private static class BlockToChange {
        private IBlockState state;
        private IBlockState hot_replaced;
        private IBlockState cold_replaced;
        private float temp;
        private boolean need_check_temp;
        private boolean only_gs_dim = false;
        private String particle_name = "";

        BlockToChange(IBlockState state, IBlockState hot_replaced, IBlockState cold_replaced, float temp, boolean need_check_temp) {
            this.state = state;
            this.hot_replaced = hot_replaced;
            this.cold_replaced = cold_replaced;
            this.temp = temp;
            this.need_check_temp = need_check_temp;
        }

        public BlockToChange setParticle(String s) {
            this.particle_name = s;
            return this;
        }

        public BlockToChange setOnlyGSDim() {
            this.only_gs_dim = true;
            return this;
        }

        void spawnParticleHotTemp(World world, BlockPos pos) {
            if (!this.particle_name.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    GalaxySpace.proxy.spawnParticle(this.particle_name, new Vector3((double)pos.func_177958_n() + world.field_73012_v.nextDouble(), (double)pos.func_177956_o() + 0.4 + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + world.field_73012_v.nextDouble()), new Vector3(0.0, 0.001, 0.0), new Object[]{10, 5, false, new Vector3(1.0, 1.0, 1.0), 1.0});
                }
            }
        }
    }
}

