/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.items.rockets;

import asmodeuscore.core.astronomy.SpaceData;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.core.prefab.entities.EntityTier6Rocket;
import galaxyspace.core.prefab.items.modules.ItemModule;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.SublightEngine;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTier6Rocket
extends Item
implements IHoldableItem,
ISortableItem,
IModificationItem {
    public ItemTier6Rocket(String assetName) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GSCreativeTabs.GSRocketTab;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean padFound = false;
        TileEntity tile = null;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1 = pos.func_177982_a(i, 0, j);
                IBlockState state = worldIn.func_180495_p(pos1);
                Block id = state.func_177230_c();
                int meta = id.func_176201_c(state);
                if (id != GSBlocks.ADVANCED_LANDING_PAD || meta != 0) continue;
                padFound = true;
                tile = worldIn.func_175625_s(pos1);
                centerX = (float)(pos.func_177958_n() + i) + 0.5f;
                centerY = (float)pos.func_177956_o() + 0.4f;
                centerZ = (float)(pos.func_177952_p() + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (padFound) {
            if (!ItemTier6Rocket.placeRocketOnPad(playerIn, stack, worldIn, tile, centerX, centerY, centerZ)) {
                return EnumActionResult.FAIL;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < IRocketType.EnumRocketType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
            ItemStack withengine = new ItemStack((Item)this, 1, 0);
            if (!withengine.func_77942_o()) {
                withengine.func_77982_d(new NBTTagCompound());
            }
            withengine.func_77978_p().func_74757_a(SpaceData.Engine_Type.SUBLIGHT_ENGINE.getName(), true);
            withengine.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, 0);
            list.add((Object)withengine);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.need_advanced_lp.desc"));
        IRocketType.EnumRocketType type = par1ItemStack.func_77952_i() < 10 ? (par1ItemStack.func_77952_i() >= 5 ? IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 5] : IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()]) : IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            tooltip.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            tooltip.add(EnumColor.RED + "\u00a7o" + GCCoreUtil.translate((String)"gui.creative_only.desc"));
        }
        if (par1ItemStack.func_77942_o()) {
            if (par1ItemStack.func_77978_p().func_74764_b("RocketFuel")) {
                int meta = par1ItemStack.func_77952_i() >= 5 ? par1ItemStack.func_77952_i() - 5 : par1ItemStack.func_77952_i();
                EntityTier6Rocket rocket = new EntityTier6Rocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[meta]);
                tooltip.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + par1ItemStack.func_77978_p().func_74762_e("RocketFuel") + " / " + rocket.fuelTank.getCapacity());
            }
            for (SpaceData.Engine_Type engines : SpaceData.Engine_Type.values()) {
                if (!par1ItemStack.func_77978_p().func_74764_b(engines.getName())) continue;
                int meta = par1ItemStack.func_77952_i() >= 5 ? par1ItemStack.func_77952_i() - 5 : par1ItemStack.func_77952_i();
                EntityTier6Rocket rocket = new EntityTier6Rocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[meta], engines);
                tooltip.add(GCCoreUtil.translate((String)"gui.message.engine_type.name") + " " + rocket.getEngine().getName());
            }
        }
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.ROCKET;
    }

    public static boolean placeRocketOnPad(EntityPlayer player, ItemStack stack, World worldIn, TileEntity tile, float centerX, float centerY, float centerZ) {
        if (tile instanceof TileEntityLandingPad) {
            if (((TileEntityLandingPad)tile).getDockedEntity() != null) {
                return false;
            }
        } else if (tile instanceof TileEntityAdvLandingPad) {
            if (((TileEntityAdvLandingPad)tile).getDockedEntity() != null) {
                return false;
            }
        } else {
            return false;
        }
        EntityTier6Rocket rocket = new EntityTier6Rocket(worldIn, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i()]);
        for (SpaceData.Engine_Type engines : SpaceData.Engine_Type.values()) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(engines.getName())) continue;
            if (engines == SpaceData.Engine_Type.ION_ENGINE) {
                if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
                    if (((IGalacticraftWorldProvider)worldIn.field_73011_w).getGravity() < 0.06f) {
                        player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.planet_not_for_ion")));
                        return false;
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.planet_not_for_ion")));
                    return false;
                }
            }
            rocket.setEngine(engines);
        }
        rocket.field_70177_z += 45.0f;
        rocket.func_70107_b(rocket.field_70165_t, rocket.field_70163_u + rocket.getOnPadYOffset(), rocket.field_70161_v);
        worldIn.func_72838_d((Entity)rocket);
        if (rocket.getType().getPreFueled()) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, rocket.getMaxFuel()), true);
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
        }
        return true;
    }

    @Override
    public GSUtils.Module_Type getType(ItemStack stack) {
        return GSUtils.Module_Type.ROCKET;
    }

    @Override
    public ItemModule[] getAvailableModules() {
        return new ItemModule[]{new SublightEngine()};
    }

    @Override
    public int getModificationCount(ItemStack stack) {
        return 1;
    }
}

