/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.parsing.InputTokenizer;
import org.spongepowered.api.command.args.parsing.SingleArg;
import org.spongepowered.api.command.args.parsing.TokenizerState;
import org.spongepowered.api.text.Text;

class QuotedStringTokenizer
implements InputTokenizer {
    private static final int CHAR_BACKSLASH = 92;
    private static final int CHAR_SINGLE_QUOTE = 39;
    private static final int CHAR_DOUBLE_QUOTE = 34;
    private final boolean handleQuotedStrings;
    private final boolean forceLenient;
    private final boolean trimTrailingSpace;

    QuotedStringTokenizer(boolean handleQuotedStrings, boolean forceLenient, boolean trimTrailingSpace) {
        this.handleQuotedStrings = handleQuotedStrings;
        this.forceLenient = forceLenient;
        this.trimTrailingSpace = trimTrailingSpace;
    }

    @Override
    public List<SingleArg> tokenize(String arguments, boolean lenient) throws ArgumentParseException {
        if (arguments.length() == 0) {
            return Collections.emptyList();
        }
        TokenizerState state = new TokenizerState(arguments, lenient);
        ArrayList<SingleArg> returnedArgs = new ArrayList<SingleArg>(arguments.length() / 4);
        if (this.trimTrailingSpace) {
            this.skipWhiteSpace(state);
        }
        while (state.hasMore()) {
            if (!this.trimTrailingSpace) {
                this.skipWhiteSpace(state);
            }
            int startIdx = state.getIndex() + 1;
            String arg = this.nextArg(state);
            returnedArgs.add(new SingleArg(arg, startIdx, state.getIndex()));
            if (!this.trimTrailingSpace) continue;
            this.skipWhiteSpace(state);
        }
        return returnedArgs;
    }

    private void skipWhiteSpace(TokenizerState state) throws ArgumentParseException {
        if (!state.hasMore()) {
            return;
        }
        while (state.hasMore() && Character.isWhitespace(state.peek())) {
            state.next();
        }
    }

    private String nextArg(TokenizerState state) throws ArgumentParseException {
        StringBuilder argBuilder = new StringBuilder();
        if (state.hasMore()) {
            int codePoint = state.peek();
            if (this.handleQuotedStrings && (codePoint == 34 || codePoint == 39)) {
                this.parseQuotedString(state, codePoint, argBuilder);
            } else {
                this.parseUnquotedString(state, argBuilder);
            }
        }
        return argBuilder.toString();
    }

    private void parseQuotedString(TokenizerState state, int startQuotation, StringBuilder builder) throws ArgumentParseException {
        int nextCodePoint = state.next();
        if (nextCodePoint != startQuotation) {
            throw state.createException(Text.of(String.format("Actual next character '%c' did not match expected quotation character '%c'", nextCodePoint, startQuotation)));
        }
        while (true) {
            if (!state.hasMore()) {
                if (state.isLenient() || this.forceLenient) {
                    return;
                }
                throw state.createException(Text.of("Unterminated quoted string found"));
            }
            nextCodePoint = state.peek();
            if (nextCodePoint == startQuotation) {
                state.next();
                return;
            }
            if (nextCodePoint == 92) {
                this.parseEscape(state, builder);
                continue;
            }
            builder.appendCodePoint(state.next());
        }
    }

    private void parseUnquotedString(TokenizerState state, StringBuilder builder) throws ArgumentParseException {
        while (state.hasMore()) {
            int nextCodePoint = state.peek();
            if (Character.isWhitespace(nextCodePoint)) {
                return;
            }
            if (nextCodePoint == 92) {
                this.parseEscape(state, builder);
                continue;
            }
            builder.appendCodePoint(state.next());
        }
    }

    private void parseEscape(TokenizerState state, StringBuilder builder) throws ArgumentParseException {
        state.next();
        builder.appendCodePoint(state.next());
    }
}

