/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class PhaseTrackerCategory
extends ConfigCategory {
    @Setting(value="verbose", comment="If 'true', the phase tracker will print out when there are too many phases \nbeing entered, usually considered as an issue of phase re-entrance and \nindicates an unexpected issue of tracking phases not to complete. \nIf this is not reported yet, please report to Sponge. If it has been \nreported, you may disable this.")
    private boolean isVerbose = true;
    @Setting(value="verbose-errors", comment="If 'true', the phase tracker will dump extra information about the current phases \nwhen certain non-PhaseTracker related exceptions occur. This is usually not necessary, as the information \nin the exception itself can normally be used to determine the cause of the issue")
    private boolean verboseErrors = false;
    @Setting(value="capture-async-spawning-entities", comment="If set to 'true', when a mod or plugin attempts to spawn an entity \noff the main server thread, Sponge will automatically \ncapture said entity to spawn it properly on the main \nserver thread. The catch to this is that some mods are \nnot considering the consequences of spawning an entity \noff the server thread, and are unaware of potential race \nconditions they may cause. If this is set to false, \nSponge will politely ignore the entity being spawned, \nand emit a warning about said spawn anyways.")
    private boolean captureAndSpawnEntitiesSync = true;
    @Setting(value="generate-stacktrace-per-phase", comment="If 'true', more thorough debugging for PhaseStates \nsuch that a StackTrace is created every time a PhaseState \nswitches, allowing for more fine grained troubleshooting \nin the cases of runaway phase states. Note that this is \nnot extremely performant and may have some associated costs \nwith generating the stack traces constantly.")
    private boolean generateStackTracePerStateEntry = false;
    @Setting(value="maximum-printed-runaway-counts", comment="If verbose is not enabled, this restricts the amount of \nrunaway phase state printouts, usually happens on a server \nwhere a PhaseState is not completing. Although rare, it should \nnever happen, but when it does, sometimes it can continuously print \nmore and more. This attempts to placate that while a fix can be worked on \nto resolve the runaway. If verbose is enabled, they will always print.")
    private int maxRunawayCount = 3;
    @Setting(value="max-block-processing-depth", comment="The maximum number of times to recursively process transactions in a single phase.\nSome mods may interact badly with Sponge's block capturing system, causing Sponge to\nend up capturing block transactions every time it tries to process an existing batch.\nDue to the recursive nature of the depth-first processing that Sponge uses to handle block transactions,\nthis can result in a stack overflow, which causes us to lose all infomration about the original cause of the issue.\nTo prevent a stack overflow, Sponge tracks the current processing depth, and aborts processing when it exceeds\nthis threshold.\nThe default value should almost always work properly -  it's unlikely you'll ever have to change it.")
    private int maxBlockProcessingDepth = 100;

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public int getMaxBlockProcessingDepth() {
        return this.maxBlockProcessingDepth;
    }

    public boolean verboseErrors() {
        return this.verboseErrors;
    }

    public boolean captureEntitiesAsync() {
        return this.captureAndSpawnEntitiesSync;
    }

    public boolean generateStackTracePerStateEntry() {
        return this.generateStackTracePerStateEntry;
    }

    public int getMaximumRunawayCount() {
        return this.maxRunawayCount;
    }
}

