/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataAlreadyRegisteredException;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.SpongeManipulatorRegistry;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.util.SpongeCatalogBuilder;

public final class SpongeDataRegistrationBuilder<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends SpongeCatalogBuilder<DataRegistration<M, I>, DataRegistration.Builder<M, I>>
implements DataRegistration.Builder<M, I> {
    @Nullable
    Class<M> manipulatorClass;
    @Nullable
    Class<I> immutableClass;
    @Nullable
    DataManipulatorBuilder<M, I> manipulatorBuilder;
    @Nullable
    PluginContainer container;
    @Nullable
    Class<? extends M> implementationData;
    @Nullable
    Class<? extends I> immutableImplementation;
    private DataProcessor<M, I> dataProcessor;
    private List<Key<?>> keys = new ArrayList();
    private AbstractSingleDataSingleTargetProcessor<?, ?, ?, M, I> dualProcessor;

    @Override
    public <D extends DataManipulator<D, C>, C extends ImmutableDataManipulator<C, D>> SpongeDataRegistrationBuilder<D, C> dataClass(Class<D> manipulatorClass) {
        this.manipulatorClass = (Class)Preconditions.checkNotNull(manipulatorClass, (Object)"DataManipulator class cannot be null!");
        return this;
    }

    @Override
    public SpongeDataRegistrationBuilder<M, I> immutableClass(Class<I> immutableDataClass) {
        Preconditions.checkState((this.manipulatorClass != null ? 1 : 0) != 0, (Object)"DataManipulator class must be set prior to setting the immutable variant!");
        this.immutableClass = (Class)Preconditions.checkNotNull(immutableDataClass, (Object)"ImmutableDataManipulator class cannot be null!");
        return this;
    }

    @Override
    public SpongeDataRegistrationBuilder<M, I> builder(DataManipulatorBuilder<M, I> builder) {
        this.manipulatorBuilder = (DataManipulatorBuilder)Preconditions.checkNotNull(builder, (Object)"ManipulatorBuilder cannot be null!");
        return this;
    }

    @Override
    public SpongeDataRegistrationBuilder<M, I> dataImplementation(Class<? extends M> implementation) {
        Preconditions.checkState((this.manipulatorClass != null ? 1 : 0) != 0, (Object)"DataManipulator class must be set prior to setting the immutable variant!");
        Preconditions.checkArgument((boolean)this.manipulatorClass.isAssignableFrom(implementation), (Object)"Manipulator implementation class must be a subtype of the manipulator interface!");
        this.implementationData = implementation;
        return this;
    }

    @Override
    public SpongeDataRegistrationBuilder<M, I> immutableImplementation(Class<? extends I> immutable) {
        Preconditions.checkState((this.immutableClass != null ? 1 : 0) != 0, (Object)"ImmutableDataManipulator class must be set prior to setting the immutable variant!");
        Preconditions.checkArgument((boolean)this.immutableClass.isAssignableFrom(immutable), (Object)"Immutable manipulator implementation class must be a subtype of the immutable manipulator interface!");
        this.immutableImplementation = (Class)Preconditions.checkNotNull(immutable);
        return this;
    }

    SpongeDataRegistrationBuilder<M, I> dataProcessor(DataProcessor<M, I> processor) {
        Preconditions.checkState((this.implementationData != null ? 1 : 0) != 0, (Object)"Must be called after an implementation class has been set!");
        this.dataProcessor = (DataProcessor)Preconditions.checkNotNull(processor);
        return this;
    }

    public SpongeDataRegistrationBuilder<M, I> dualProcessor(AbstractSingleDataSingleTargetProcessor<?, ?, ?, M, I> processor) {
        Preconditions.checkState((this.implementationData != null ? 1 : 0) != 0, (Object)"Must be called after an implementation class has been set!");
        this.dualProcessor = (AbstractSingleDataSingleTargetProcessor)Preconditions.checkNotNull(processor);
        return this;
    }

    SpongeDataRegistrationBuilder<M, I> key(Key<?> key) {
        Preconditions.checkState((this.implementationData != null ? 1 : 0) != 0, (Object)"Must be called after an implementation class has been set!");
        return this;
    }

    SpongeDataRegistrationBuilder<M, I> valueProcessor(ValueProcessor<?, ?> processor) {
        return this;
    }

    @Override
    public SpongeDataRegistrationBuilder<M, I> from(DataRegistration<M, I> value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot set a builder with already created DataRegistrations!");
    }

    @Override
    protected DataRegistration<M, I> build(PluginContainer plugin, String id, Translation name) throws IllegalStateException, IllegalArgumentException, DataAlreadyRegisteredException {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Registrations cannot take place at this time!");
        Preconditions.checkState((this.manipulatorBuilder != null ? 1 : 0) != 0, (Object)"ManipulatorBuilder cannot be null!");
        Preconditions.checkState((this.manipulatorClass != null ? 1 : 0) != 0, (Object)"DataManipulator class cannot be null!");
        Preconditions.checkState((this.immutableClass != null ? 1 : 0) != 0, (Object)"ImmutableDataManipulator class cannot be null!");
        id = plugin.getId() + ':' + id;
        SpongeManipulatorRegistry.getInstance().validateRegistrationId(id);
        SpongeDataManager.getInstance().validateRegistration(this);
        this.container = Sponge.getPluginManager().getPlugin(plugin.getId()).orElseThrow(() -> new IllegalArgumentException("Unknown plugin id: " + plugin.getId()));
        SpongeDataRegistration registration = new SpongeDataRegistration(id, name, this);
        SpongeDataManager.getInstance().registerInternally(registration);
        SpongeManipulatorRegistry.getInstance().register(registration);
        return registration;
    }

    @Override
    public SpongeDataRegistrationBuilder<M, I> reset() {
        super.reset();
        this.manipulatorClass = null;
        this.immutableClass = null;
        this.manipulatorBuilder = null;
        this.container = null;
        this.id = null;
        this.name = null;
        return this;
    }
}

