/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFoodData;
import org.spongepowered.api.data.manipulator.mutable.entity.FoodData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeFoodData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeFoodData
extends AbstractData<FoodData, ImmutableFoodData>
implements FoodData {
    private int foodLevel;
    private double foodSaturationLevel;
    private double foodExhaustionLevel;

    public SpongeFoodData(int foodLevel, double foodSaturationLevel, double foodExhaustionLevel) {
        super(FoodData.class);
        this.foodLevel = foodLevel;
        this.foodSaturationLevel = foodSaturationLevel;
        this.foodExhaustionLevel = foodExhaustionLevel;
        this.registerGettersAndSetters();
    }

    public SpongeFoodData() {
        this(20, 5.0, 0.0);
    }

    @Override
    public FoodData copy() {
        return new SpongeFoodData(this.foodLevel, this.foodSaturationLevel, this.foodExhaustionLevel);
    }

    @Override
    public ImmutableFoodData asImmutable() {
        return new ImmutableSpongeFoodData(this.foodLevel, this.foodSaturationLevel, this.foodExhaustionLevel);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FOOD_LEVEL.getQuery(), (Object)this.foodLevel).set(Keys.SATURATION.getQuery(), (Object)this.foodSaturationLevel).set(Keys.EXHAUSTION.getQuery(), (Object)this.foodExhaustionLevel);
    }

    @Override
    public MutableBoundedValue<Integer> foodLevel() {
        return SpongeValueFactory.boundedBuilder(Keys.FOOD_LEVEL).defaultValue(20).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.foodLevel).build();
    }

    @Override
    public MutableBoundedValue<Double> exhaustion() {
        return SpongeValueFactory.boundedBuilder(Keys.EXHAUSTION).defaultValue(0.0).minimum(0.0).maximum((Double)Double.MAX_VALUE).actualValue(this.foodExhaustionLevel).build();
    }

    @Override
    public MutableBoundedValue<Double> saturation() {
        return SpongeValueFactory.boundedBuilder(Keys.SATURATION).defaultValue(20.0).minimum(0.0).maximum((Double)Double.MAX_VALUE).actualValue(this.foodSaturationLevel).build();
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    public double getFoodSaturation() {
        return this.foodSaturationLevel;
    }

    public void setFoodSaturation(double foodSaturationLevel) {
        this.foodSaturationLevel = (float)foodSaturationLevel;
    }

    public double getFoodExhaustion() {
        return this.foodExhaustionLevel;
    }

    public void setFoodExhaustion(double foodExhaustionLevel) {
        this.foodExhaustionLevel = (float)foodExhaustionLevel;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.FOOD_LEVEL, this::getFoodLevel);
        this.registerFieldSetter(Keys.FOOD_LEVEL, this::setFoodLevel);
        this.registerKeyValue(Keys.FOOD_LEVEL, this::foodLevel);
        this.registerFieldGetter(Keys.SATURATION, this::getFoodSaturation);
        this.registerFieldSetter(Keys.SATURATION, this::setFoodSaturation);
        this.registerKeyValue(Keys.SATURATION, this::saturation);
        this.registerFieldGetter(Keys.EXHAUSTION, this::getFoodExhaustion);
        this.registerFieldSetter(Keys.EXHAUSTION, this::setFoodExhaustion);
        this.registerKeyValue(Keys.EXHAUSTION, this::exhaustion);
    }
}

